/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.WaystoneActivatedEvent;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.blay09.mods.waystones.config.DimensionalWarp;
import net.blay09.mods.waystones.config.WaystoneConfig;
import net.blay09.mods.waystones.core.IPlayerWaystoneData;
import net.blay09.mods.waystones.core.InMemoryPlayerWaystoneData;
import net.blay09.mods.waystones.core.PersistentPlayerWaystoneData;
import net.blay09.mods.waystones.core.WarpMode;
import net.blay09.mods.waystones.core.WaystoneEditPermissions;
import net.blay09.mods.waystones.core.WaystoneManager;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.item.ModItems;
import net.blay09.mods.waystones.network.NetworkHandler;
import net.blay09.mods.waystones.network.message.TeleportEffectMessage;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class PlayerWaystoneManager {
    private static IPlayerWaystoneData persistentPlayerWaystoneData = new PersistentPlayerWaystoneData();
    private static IPlayerWaystoneData inMemoryPlayerWaystoneData = new InMemoryPlayerWaystoneData();

    public static boolean mayBreakWaystone(PlayerEntity player, IBlockReader world, BlockPos pos) {
        if (((Boolean)WaystoneConfig.SERVER.restrictToCreative.get()).booleanValue() && !player.field_71075_bZ.field_75098_d) {
            return false;
        }
        IWaystone waystone = WaystoneManager.get().getWaystoneAt(world, pos).orElseThrow(IllegalStateException::new);
        if (!player.field_71075_bZ.field_75098_d) {
            if (waystone.wasGenerated() && ((Boolean)WaystoneConfig.SERVER.generatedWaystonesUnbreakable.get()).booleanValue()) {
                return false;
            }
            return !waystone.isGlobal() || (Boolean)WaystoneConfig.SERVER.globalWaystoneRequiresCreative.get() != false;
        }
        return true;
    }

    public static boolean mayPlaceWaystone(@Nullable PlayerEntity player) {
        return (Boolean)WaystoneConfig.SERVER.restrictToCreative.get() == false || player != null && player.field_71075_bZ.field_75098_d;
    }

    public static WaystoneEditPermissions mayEditWaystone(PlayerEntity player, World world, IWaystone waystone) {
        if (((Boolean)WaystoneConfig.SERVER.restrictToCreative.get()).booleanValue() && !player.field_71075_bZ.field_75098_d) {
            return WaystoneEditPermissions.NOT_CREATIVE;
        }
        if (((Boolean)WaystoneConfig.SERVER.restrictRenameToOwner.get()).booleanValue() && !waystone.isOwner(player)) {
            return WaystoneEditPermissions.NOT_THE_OWNER;
        }
        if (waystone.isGlobal() && !player.field_71075_bZ.field_75098_d && !((Boolean)WaystoneConfig.SERVER.globalWaystoneRequiresCreative.get()).booleanValue()) {
            return WaystoneEditPermissions.GET_CREATIVE;
        }
        return WaystoneEditPermissions.ALLOW;
    }

    public static boolean isWaystoneActivated(PlayerEntity player, IWaystone waystone) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.field_70170_p).isWaystoneActivated(player, waystone);
    }

    public static void activateWaystone(PlayerEntity player, IWaystone waystone) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.field_70170_p).activateWaystone(player, waystone);
        MinecraftForge.EVENT_BUS.post((Event)new WaystoneActivatedEvent(player, waystone));
    }

    public static int getExperienceLevelCost(PlayerEntity player, IWaystone waystone, WarpMode warpMode) {
        boolean enableXPCost;
        if (waystone.getDimensionType() != player.field_70170_p.func_201675_m().func_186058_p()) {
            return (Integer)WaystoneConfig.SERVER.dimensionalWarpXpCost.get();
        }
        double xpCostMultiplier = warpMode.getXpCostMultiplier();
        boolean bl = enableXPCost = !player.field_71075_bZ.field_75098_d;
        if (waystone.isGlobal()) {
            xpCostMultiplier *= ((Double)WaystoneConfig.SERVER.globalWaystoneXpCostMultiplier.get()).doubleValue();
        }
        BlockPos pos = waystone.getPos();
        double dist = Math.sqrt(player.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()));
        double xpLevelCost = (Integer)WaystoneConfig.SERVER.blocksPerXPLevel.get() > 0 ? MathHelper.func_151237_a((double)(dist / (double)((Integer)WaystoneConfig.SERVER.blocksPerXPLevel.get()).intValue()), (double)0.0, (double)((Double)WaystoneConfig.SERVER.maximumXpCost.get())) : 0.0;
        return enableXPCost ? (int)Math.round(xpLevelCost * xpCostMultiplier) : 0;
    }

    public static boolean canUseInventoryButton(PlayerEntity player) {
        return PlayerWaystoneManager.getInventoryButtonCooldownLeft(player) <= 0L;
    }

    public static boolean canUseWarpStone(PlayerEntity player, ItemStack heldItem) {
        return PlayerWaystoneManager.getWarpStoneCooldownLeft(player) <= 0L;
    }

    public static double getCooldownMultiplier(IWaystone waystone) {
        return waystone.isGlobal() ? (Double)WaystoneConfig.SERVER.globalWaystoneCooldownMultiplier.get() : 1.0;
    }

    public static boolean tryTeleportToWaystone(ServerPlayerEntity player, IWaystone waystone, WarpMode warpMode, @Nullable IWaystone fromWaystone) {
        boolean isDimensionalWarp;
        if (!waystone.isValid()) {
            return false;
        }
        ItemStack warpItem = PlayerWaystoneManager.findWarpItem((PlayerEntity)player, warpMode);
        if (!PlayerWaystoneManager.canUseWarpMode((PlayerEntity)player, warpMode, warpItem, fromWaystone)) {
            return false;
        }
        int xpLevelCost = PlayerWaystoneManager.getExperienceLevelCost((PlayerEntity)player, waystone, warpMode);
        if (player.field_71068_ca < xpLevelCost) {
            return false;
        }
        boolean bl = isDimensionalWarp = waystone.getDimensionType() != player.field_70170_p.func_201675_m().func_186058_p();
        if (isDimensionalWarp && !PlayerWaystoneManager.canDimensionalWarpTo((PlayerEntity)player, waystone)) {
            TranslationTextComponent chatComponent = new TranslationTextComponent("chat.waystones.cannot_dimension_warp", new Object[0]);
            chatComponent.func_150256_b().func_150238_a(TextFormatting.RED);
            player.func_146105_b((ITextComponent)chatComponent, false);
            return false;
        }
        if (warpMode.consumesItem() && !player.field_71075_bZ.field_75098_d) {
            warpItem.func_190918_g(1);
        }
        if (warpMode == WarpMode.INVENTORY_BUTTON) {
            int cooldown = (int)((double)((Integer)WaystoneConfig.SERVER.warpStoneCooldown.get()).intValue() * PlayerWaystoneManager.getCooldownMultiplier(waystone));
            PlayerWaystoneManager.getPlayerWaystoneData(player.field_70170_p).setInventoryButtonCooldownUntil((PlayerEntity)player, System.currentTimeMillis() + (long)(cooldown * 1000));
            WaystoneSyncManager.sendWaystoneCooldowns((PlayerEntity)player);
        } else if (warpMode == WarpMode.WARP_STONE) {
            int cooldown = (int)((double)((Integer)WaystoneConfig.SERVER.warpStoneCooldown.get()).intValue() * PlayerWaystoneManager.getCooldownMultiplier(waystone));
            PlayerWaystoneManager.getPlayerWaystoneData(player.field_70170_p).setWarpStoneCooldownUntil((PlayerEntity)player, System.currentTimeMillis() + (long)(cooldown * 1000));
            WaystoneSyncManager.sendWaystoneCooldowns((PlayerEntity)player);
        }
        if (xpLevelCost > 0) {
            player.func_82242_a(-xpLevelCost);
        }
        PlayerWaystoneManager.teleportToWaystone(player, waystone);
        return true;
    }

    private static boolean canDimensionalWarpTo(PlayerEntity player, IWaystone waystone) {
        DimensionalWarp dimensionalWarpMode = (DimensionalWarp)((Object)WaystoneConfig.SERVER.dimensionalWarp.get());
        return dimensionalWarpMode == DimensionalWarp.ALLOW || dimensionalWarpMode == DimensionalWarp.GLOBAL_ONLY && waystone.isGlobal();
    }

    private static ItemStack findWarpItem(PlayerEntity player, WarpMode warpMode) {
        switch (warpMode) {
            case WARP_SCROLL: {
                return PlayerWaystoneManager.findWarpItem(player, ModItems.warpScroll);
            }
            case WARP_STONE: {
                return PlayerWaystoneManager.findWarpItem(player, ModItems.warpStone);
            }
            case RETURN_SCROLL: {
                return PlayerWaystoneManager.findWarpItem(player, ModItems.returnScroll);
            }
            case BOUND_SCROLL: {
                return PlayerWaystoneManager.findWarpItem(player, ModItems.boundScroll);
            }
        }
        return ItemStack.field_190927_a;
    }

    private static ItemStack findWarpItem(PlayerEntity player, Item warpItem) {
        if (player.func_184614_ca().func_77973_b() == warpItem) {
            return player.func_184614_ca();
        }
        if (player.func_184592_cb().func_77973_b() == warpItem) {
            return player.func_184592_cb();
        }
        return ItemStack.field_190927_a;
    }

    private static void teleportToWaystone(ServerPlayerEntity player, IWaystone waystone) {
        Direction targetDir;
        BlockPos targetPos;
        BlockPos sourcePos = player.func_180425_c();
        BlockPos pos = waystone.getPos();
        MinecraftServer server = player.func_184102_h();
        ServerWorld targetWorld = Objects.requireNonNull(server).func_71218_a(waystone.getDimensionType());
        BlockState state = targetWorld.func_180495_p(pos);
        if (state.func_177230_c() instanceof WaystoneBlock) {
            Direction direction = (Direction)state.func_177229_b((IProperty)WaystoneBlock.FACING);
            targetPos = pos.func_177972_a(direction);
            targetDir = direction;
        } else {
            targetPos = pos;
            targetDir = Direction.NORTH;
        }
        player.func_200619_a(targetWorld, (double)targetPos.func_177958_n() + 0.5, (double)targetPos.func_177956_o() + 0.5, (double)targetPos.func_177952_p() + 0.5, targetDir.func_185119_l(), player.field_70125_A);
        NetworkHandler.channel.send(PacketDistributor.TRACKING_CHUNK.with(() -> player.field_70170_p.func_175726_f(sourcePos)), (Object)new TeleportEffectMessage(sourcePos));
        NetworkHandler.channel.send(PacketDistributor.TRACKING_CHUNK.with(() -> player.field_70170_p.func_175726_f(targetPos)), (Object)new TeleportEffectMessage(targetPos));
    }

    public static void deactivateWaystone(PlayerEntity player, IWaystone waystone) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.field_70170_p).deactivateWaystone(player, waystone);
    }

    private static boolean canUseWarpMode(PlayerEntity player, WarpMode warpMode, ItemStack heldItem, @Nullable IWaystone fromWaystone) {
        switch (warpMode) {
            case INVENTORY_BUTTON: {
                return PlayerWaystoneManager.canUseInventoryButton(player);
            }
            case WARP_SCROLL: {
                return !heldItem.func_190926_b() && heldItem.func_77973_b() == ModItems.warpScroll;
            }
            case BOUND_SCROLL: {
                return !heldItem.func_190926_b() && heldItem.func_77973_b() == ModItems.boundScroll;
            }
            case RETURN_SCROLL: {
                return !heldItem.func_190926_b() && heldItem.func_77973_b() == ModItems.returnScroll;
            }
            case WARP_STONE: {
                return !heldItem.func_190926_b() && heldItem.func_77973_b() == ModItems.warpStone && PlayerWaystoneManager.canUseWarpStone(player, heldItem);
            }
            case WAYSTONE_TO_WAYSTONE: {
                return fromWaystone != null && fromWaystone.isValid();
            }
        }
        return false;
    }

    public static long getWarpStoneCooldownUntil(PlayerEntity player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.field_70170_p).getWarpStoneCooldownUntil(player);
    }

    public static long getWarpStoneCooldownLeft(PlayerEntity player) {
        long cooldownUntil = PlayerWaystoneManager.getWarpStoneCooldownUntil(player);
        return Math.max(0L, cooldownUntil - System.currentTimeMillis());
    }

    public static void setWarpStoneCooldownUntil(PlayerEntity player, long timeStamp) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.field_70170_p).setWarpStoneCooldownUntil(player, timeStamp);
    }

    public static long getInventoryButtonCooldownUntil(PlayerEntity player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.field_70170_p).getInventoryButtonCooldownUntil(player);
    }

    public static long getInventoryButtonCooldownLeft(PlayerEntity player) {
        long cooldownUntil = PlayerWaystoneManager.getInventoryButtonCooldownUntil(player);
        return Math.max(0L, cooldownUntil - System.currentTimeMillis());
    }

    public static void setInventoryButtonCooldownUntil(PlayerEntity player, long timeStamp) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.field_70170_p).setInventoryButtonCooldownUntil(player, timeStamp);
    }

    @Nullable
    public static IWaystone getNearestWaystone(PlayerEntity player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.field_70170_p).getWaystones(player).stream().min((first, second) -> {
            double firstDist = first.getPos().func_218140_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, true);
            double secondDist = second.getPos().func_218140_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, true);
            return (int)Math.round(firstDist) - (int)Math.round(secondDist);
        }).orElse(null);
    }

    public static List<IWaystone> getWaystones(PlayerEntity player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.field_70170_p).getWaystones(player);
    }

    public static IPlayerWaystoneData getPlayerWaystoneData(World world) {
        return world.field_72995_K ? inMemoryPlayerWaystoneData : persistentPlayerWaystoneData;
    }

    public static IPlayerWaystoneData getPlayerWaystoneData(LogicalSide side) {
        return side.isClient() ? inMemoryPlayerWaystoneData : persistentPlayerWaystoneData;
    }

    public static boolean mayTeleportToWaystone(PlayerEntity player, IWaystone waystone) {
        return true;
    }

    public static void swapWaystoneSorting(PlayerEntity player, int index, int otherIndex) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.field_70170_p).swapWaystoneSorting(player, index, otherIndex);
    }

    public static boolean mayEditGlobalWaystones(PlayerEntity player) {
        return player.field_71075_bZ.field_75098_d || (Boolean)WaystoneConfig.SERVER.globalWaystoneRequiresCreative.get() == false;
    }

    public static void makeWaystoneGlobal(IWaystone waystone) {
        List players = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v();
        for (ServerPlayerEntity player : players) {
            if (PlayerWaystoneManager.isWaystoneActivated((PlayerEntity)player, waystone)) continue;
            PlayerWaystoneManager.activateWaystone((PlayerEntity)player, waystone);
        }
    }

    public static void removeKnownWaystone(IWaystone waystone) {
        List players = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v();
        for (ServerPlayerEntity player : players) {
            PlayerWaystoneManager.deactivateWaystone((PlayerEntity)player, waystone);
            WaystoneSyncManager.sendKnownWaystones((PlayerEntity)player);
        }
    }
}

