/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.util;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPos {
    private static final int NUM_X_BITS;
    private static final int NUM_Z_BITS;
    private static final int NUM_Y_BITS;
    private static final int Y_SHIFT;
    private static final int X_SHIFT;
    private static final long X_MASK;
    private static final long Y_MASK;
    private static final long Z_MASK;
    private final int x;
    private final int y;
    private final int z;

    public BlockPos(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public BlockPos(TileEntity tileEntity) {
        this.x = tileEntity.field_145851_c;
        this.y = tileEntity.field_145848_d;
        this.z = tileEntity.field_145849_e;
    }

    public BlockPos(EntityPlayer player) {
        this.x = (int)player.field_70165_t;
        this.y = (int)player.field_70163_u;
        this.z = (int)player.field_70161_v;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public long toLong() {
        return ((long)this.getX() & X_MASK) << X_SHIFT | ((long)this.getY() & Y_MASK) << Y_SHIFT | (long)this.getZ() & Z_MASK;
    }

    public static BlockPos fromLong(long value) {
        int i = (int)(value << 64 - X_SHIFT - NUM_X_BITS >> 64 - NUM_X_BITS);
        int j = (int)(value << 64 - Y_SHIFT - NUM_Y_BITS >> 64 - NUM_Y_BITS);
        int k = (int)(value << 64 - NUM_Z_BITS >> 64 - NUM_Z_BITS);
        return new BlockPos(i, j, k);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockPos blockPos = (BlockPos)o;
        return this.x == blockPos.x && this.y == blockPos.y && this.z == blockPos.z;
    }

    public int hashCode() {
        int result = this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public boolean equals(int xCoord, int yCoord, int zCoord) {
        return this.x == xCoord && this.y == yCoord && this.z == zCoord;
    }

    public BlockPos offset(ForgeDirection facing) {
        return new BlockPos(this.x + facing.offsetX, this.y + facing.offsetY, this.z + facing.offsetZ);
    }

    static {
        NUM_Z_BITS = NUM_X_BITS = 1 + MathHelper.func_151239_c((int)MathHelper.func_151236_b((int)30000000));
        NUM_Y_BITS = 64 - NUM_X_BITS - NUM_Z_BITS;
        Y_SHIFT = NUM_Z_BITS;
        X_SHIFT = Y_SHIFT + NUM_Y_BITS;
        X_MASK = (1L << NUM_X_BITS) - 1L;
        Y_MASK = (1L << NUM_Y_BITS) - 1L;
        Z_MASK = (1L << NUM_Z_BITS) - 1L;
    }
}

