/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.angels.common;

import java.util.ArrayList;
import java.util.List;
import me.swirtzly.angels.common.blocks.BlockAngelPlinth;
import me.swirtzly.angels.common.blocks.BlockAngelStatue;
import me.swirtzly.angels.common.blocks.BlockChronodyneGenerator;
import me.swirtzly.angels.common.blocks.BlockMineable;
import me.swirtzly.angels.common.blocks.BlockSnowArm;
import me.swirtzly.angels.common.entities.AngelEnums;
import me.swirtzly.angels.common.entities.EntityAngelPainting;
import me.swirtzly.angels.common.entities.EntityAnomaly;
import me.swirtzly.angels.common.entities.EntityChronodyneGenerator;
import me.swirtzly.angels.common.entities.EntityWeepingAngel;
import me.swirtzly.angels.common.items.ItemAngelSpawner;
import me.swirtzly.angels.common.items.ItemChronodyneGenerator;
import me.swirtzly.angels.common.items.ItemDetector;
import me.swirtzly.angels.common.items.ItemHanging;
import me.swirtzly.angels.common.misc.WATabs;
import me.swirtzly.angels.common.tileentities.TileEntityChronodyneGenerator;
import me.swirtzly.angels.common.tileentities.TileEntityPlinth;
import me.swirtzly.angels.common.tileentities.TileEntitySnowArm;
import me.swirtzly.angels.common.tileentities.TileEntityStatue;
import me.swirtzly.angels.utils.AngelUtils;
import me.swirtzly.angels.utils.WADamageSource;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class WAObjects {
    public static DamageSource ANGEL = new WADamageSource("backintime");
    public static DamageSource STONE = new WADamageSource("punch_stone");
    public static DamageSource ANGEL_NECK_SNAP = new WADamageSource("neck_snap");
    public static List<Item> ITEMS = new ArrayList<Item>();
    private static List<Item> ITEM_BLOCKS = new ArrayList<Item>();

    @SubscribeEvent
    public static void addItems(RegistryEvent.Register<Item> e) {
        IForgeRegistry reg = e.getRegistry();
        WAObjects.registerItems((IForgeRegistry<Item>)reg, WATabs.MAIN_TAB, ITEM_BLOCKS.toArray(new Item[ITEM_BLOCKS.size()]));
        reg.registerAll((IForgeRegistryEntry[])new Item[]{WAObjects.setUpItem(new ItemHanging(), "angel_painting", true), WAObjects.setUpItem(new ItemDetector(), "timey_wimey_detector", true), WAObjects.setUpItem(new ItemChronodyneGenerator(), "chronodyne_generator", true), WAObjects.setUpItem(new ItemAngelSpawner<EntityWeepingAngel>(AngelEnums.AngelType.ANGEL_ONE, EntityWeepingAngel::new), "angel_0", true), WAObjects.setUpItem(new ItemAngelSpawner<EntityWeepingAngel>(AngelEnums.AngelType.ANGEL_TWO, EntityWeepingAngel::new), "angel_1", true), WAObjects.setUpItem(new ItemAngelSpawner<EntityWeepingAngel>(AngelEnums.AngelType.ANGEL_CHILD, EntityWeepingAngel::new), "angel_child", true), WAObjects.setUpItem(new Item(), "kontron_ingot", true), WAObjects.setUpItem(new ItemAngelSpawner<EntityWeepingAngel>(AngelEnums.AngelType.ANGEL_THREE, EntityWeepingAngel::new), "angel_2", true), WAObjects.setUpItem(new ItemAngelSpawner<EntityWeepingAngel>(AngelEnums.AngelType.ANGEL_FOUR, EntityWeepingAngel::new), "angel_3", true), WAObjects.setUpItem(new ItemAngelSpawner<EntityWeepingAngel>(AngelEnums.AngelType.ANGEL_FIVE, EntityWeepingAngel::new), "angel_4", true)});
    }

    @SubscribeEvent
    public static void addBlocks(RegistryEvent.Register<Block> e) {
        IForgeRegistry reg = e.getRegistry();
        WAObjects.registerBlocks((IForgeRegistry<Block>)reg, WAObjects.setUpBlock((Block)new BlockSnowArm(), "arm"), WAObjects.setUpBlock(new BlockAngelPlinth(), "plinth"), WAObjects.setUpBlock(new BlockMineable(() -> new ItemStack(Items.KONTRON_INGOT), 2, 1), "kontron_ore"), WAObjects.setUpBlock(new BlockAngelStatue(), "statue"));
        reg.register((IForgeRegistryEntry)WAObjects.setUpBlock(new BlockChronodyneGenerator(), "cg"));
        WAObjects.regTiles();
    }

    public static void regTiles() {
        GameRegistry.registerTileEntity(TileEntitySnowArm.class, (ResourceLocation)new ResourceLocation("weeping-angels:snowarm"));
        GameRegistry.registerTileEntity(TileEntityChronodyneGenerator.class, (ResourceLocation)new ResourceLocation("weeping-angels:cg"));
        GameRegistry.registerTileEntity(TileEntityPlinth.class, (ResourceLocation)new ResourceLocation("weeping-angels:plinth"));
        GameRegistry.registerTileEntity(TileEntityStatue.class, (ResourceLocation)new ResourceLocation("weeping-angels:statue"));
    }

    @SubscribeEvent
    public static void addEntities(RegistryEvent.Register<EntityEntry> e) {
        IForgeRegistry reg = e.getRegistry();
        reg.registerAll((IForgeRegistryEntry[])new EntityEntry[]{EntityEntries.ANOMALY, EntityEntries.CHRONODYNE_GENERATOR, EntityEntries.WEEPING_ANGEL, EntityEntries.WEEPING_ANGEL_PAINTING});
        AngelUtils.setUpSpawns();
    }

    @SubscribeEvent
    public static void addSounds(RegistryEvent.Register<SoundEvent> e) {
        IForgeRegistry reg = e.getRegistry();
        reg.registerAll((IForgeRegistryEntry[])new SoundEvent[]{WAObjects.setUpSound("angel_seen_1"), WAObjects.setUpSound("angel_seen_2"), WAObjects.setUpSound("angel_seen_3"), WAObjects.setUpSound("angel_seen_4"), WAObjects.setUpSound("angel_seen_5"), WAObjects.setUpSound("angel_seen_6"), WAObjects.setUpSound("angel_seen_7"), WAObjects.setUpSound("angel_seen_8"), WAObjects.setUpSound("stone_scrap"), WAObjects.setUpSound("child_run"), WAObjects.setUpSound("laughing_child"), WAObjects.setUpSound("light_break"), WAObjects.setUpSound("angel_teleport"), WAObjects.setUpSound("angel_ambient"), WAObjects.setUpSound("ding"), WAObjects.setUpSound("blow"), WAObjects.setUpSound("angel_death"), WAObjects.setUpSound("angel_neck_snap")});
    }

    private static SoundEvent setUpSound(String soundName) {
        return (SoundEvent)new SoundEvent(new ResourceLocation("weeping-angels", soundName)).setRegistryName(soundName);
    }

    private static Item setUpItem(Item item, String name, boolean addToTab) {
        item.setRegistryName("weeping-angels", name);
        item.func_77655_b(name);
        if (addToTab) {
            item.func_77637_a(WATabs.MAIN_TAB);
        }
        ITEMS.add(item);
        return item;
    }

    private static Block setUpBlock(Block block, String name) {
        block.setRegistryName("weeping-angels", name);
        block.func_149663_c("weeping-angels." + name);
        return block;
    }

    private static void registerItems(IForgeRegistry<Item> reg, CreativeTabs tab, Item[] items) {
        reg.registerAll((IForgeRegistryEntry[])items);
        for (Item item : items) {
            item.func_77637_a(tab);
            ITEMS.add(item);
        }
    }

    private static void registerBlocks(IForgeRegistry<Block> reg, Block ... blocks) {
        reg.registerAll((IForgeRegistryEntry[])blocks);
        for (Block block : blocks) {
            block.func_149647_a(WATabs.MAIN_TAB);
            ITEM_BLOCKS.add(((Item)new ItemBlock(block).setRegistryName(block.getRegistryName())).func_77655_b(block.func_149739_a()));
        }
    }

    @GameRegistry.ObjectHolder(value="weeping-angels")
    public static class EntityEntries {
        public static final EntityEntry WEEPING_ANGEL = EntityEntryBuilder.create().entity(EntityWeepingAngel.class).id(new ResourceLocation("weeping-angels", "weepingangel"), 0).name("angel").tracker(80, 3, false).build();
        public static final EntityEntry WEEPING_ANGEL_PAINTING = EntityEntryBuilder.create().entity(EntityAngelPainting.class).id(new ResourceLocation("weeping-angels", "weepingAngelpainting"), 1).name("weepingAngelpainting").tracker(80, Integer.MAX_VALUE, false).build();
        public static final EntityEntry CHRONODYNE_GENERATOR = EntityEntryBuilder.create().entity(EntityChronodyneGenerator.class).id(new ResourceLocation("weeping-angels", "chronodyne_generator"), 2).name("chronodyne_generator").tracker(80, 3, true).build();
        public static final EntityEntry ANOMALY = EntityEntryBuilder.create().entity(EntityAnomaly.class).id(new ResourceLocation("weeping-angels", "anomaly"), 3).name("anomaly").tracker(80, 3, true).build();
    }

    @GameRegistry.ObjectHolder(value="weeping-angels")
    public static class Sounds {
        public static final SoundEvent ANGEL_SEEN_1 = null;
        public static final SoundEvent ANGEL_SEEN_2 = null;
        public static final SoundEvent ANGEL_SEEN_3 = null;
        public static final SoundEvent ANGEL_SEEN_4 = null;
        public static final SoundEvent ANGEL_SEEN_5 = null;
        public static final SoundEvent ANGEL_SEEN_6 = null;
        public static final SoundEvent ANGEL_SEEN_7 = null;
        public static final SoundEvent ANGEL_SEEN_8 = null;
        public static final SoundEvent STONE_SCRAP = null;
        public static final SoundEvent CHILD_RUN = null;
        public static final SoundEvent LAUGHING_CHILD = null;
        public static final SoundEvent LIGHT_BREAK = null;
        public static final SoundEvent ANGEL_TELEPORT = null;
        public static final SoundEvent ANGEL_AMBIENT = null;
        public static final SoundEvent DING = null;
        public static final SoundEvent BLOW = null;
        public static final SoundEvent ANGEL_DEATH = null;
        public static final SoundEvent ANGEL_NECK_SNAP = null;
    }

    @GameRegistry.ObjectHolder(value="weeping-angels")
    public static class Items {
        public static final Item ANGEL_PAINTING = null;
        public static final Item TIMEY_WIMEY_DETECTOR = null;
        public static final Item CHRONODYNE_GENERATOR = null;
        public static final Item ANGEL_0 = null;
        public static final Item ANGEL_1 = null;
        public static final Item ANGEL_2 = null;
        public static final Item ANGEL_3 = null;
        public static final Item ANGEL_CHILD = null;
        public static final Item KONTRON_INGOT = null;
    }

    @GameRegistry.ObjectHolder(value="weeping-angels")
    public static class Blocks {
        public static final Block ARM = null;
        public static final Block CG = null;
        public static final Block PLINTH = null;
        public static final Block KONTRON_ORE = null;
        public static final Block STATUE = null;
    }
}

