/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.angels.common.entities;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import me.swirtzly.angels.common.WAObjects;
import me.swirtzly.angels.common.entities.EntityWeepingAngel;
import me.swirtzly.angels.utils.Teleporter;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityAngelPainting
extends EntityHanging
implements IEntityAdditionalSpawnData {
    public EnumAngelArt art;

    public EntityAngelPainting(World worldIn) {
        super(worldIn);
    }

    public EntityAngelPainting(World worldIn, BlockPos pos, EnumFacing side) {
        super(worldIn, pos);
        EnumAngelArt[] ENUM_ART;
        ArrayList ART_LIST = Lists.newArrayList();
        EnumAngelArt[] enumAngelArtArray = ENUM_ART = EnumAngelArt.values();
        int n = enumAngelArtArray.length;
        for (int i = 0; i < n; ++i) {
            EnumAngelArt EnumAngelArt2;
            this.art = EnumAngelArt2 = enumAngelArtArray[i];
            this.func_174859_a(side);
            if (!this.func_70518_d()) continue;
            ART_LIST.add(EnumAngelArt2);
        }
        if (!ART_LIST.isEmpty()) {
            this.art = (EnumAngelArt)((Object)ART_LIST.get(this.field_70146_Z.nextInt(ART_LIST.size())));
        }
        this.func_174859_a(side);
    }

    @SideOnly(value=Side.CLIENT)
    public EntityAngelPainting(World worldIn, BlockPos pos, EnumFacing side, String name) {
        this(worldIn, pos, side);
        EnumAngelArt[] ENUM_ART;
        for (EnumAngelArt EnumAngelArt2 : ENUM_ART = EnumAngelArt.values()) {
            if (!EnumAngelArt2.title.equals(name)) continue;
            this.art = EnumAngelArt2;
            break;
        }
        this.func_174859_a(side);
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        tagCompound.func_74778_a("Motive", this.art.title);
        super.func_70014_b(tagCompound);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa % 200 == 0) {
            if (this.art.name().contains("Blank")) {
                return;
            }
            if (this.art.equals((Object)EnumAngelArt.ANGEL_ONE)) {
                this.spawnAngel(this.func_130014_f_());
                this.art = EnumAngelArt.BlankPaintingOne;
            }
            if (this.art.equals((Object)EnumAngelArt.ANGEL_TWO)) {
                this.spawnAngel(this.func_130014_f_());
                this.art = EnumAngelArt.BlankPaintingTwo;
            }
            if (this.art.equals((Object)EnumAngelArt.AngelThree)) {
                this.spawnAngel(this.func_130014_f_());
                this.art = EnumAngelArt.BlankPaintingThree;
            }
            if (this.art.equals((Object)EnumAngelArt.AngelFour)) {
                this.spawnAngel(this.func_130014_f_());
                this.art = EnumAngelArt.BlankPaintingFour;
            }
            if (this.art.equals((Object)EnumAngelArt.AngelFive)) {
                this.spawnAngel(this.func_130014_f_());
                this.art = EnumAngelArt.BlankPaintingFive;
            }
            if (this.art.equals((Object)EnumAngelArt.AngelSix)) {
                this.spawnAngel(this.func_130014_f_());
                this.art = EnumAngelArt.BlankPaintingSix;
            }
        }
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        EnumAngelArt[] ENUM_ART;
        String s = tagCompund.func_74779_i("Motive");
        for (EnumAngelArt EnumAngelArt2 : ENUM_ART = EnumAngelArt.values()) {
            if (!EnumAngelArt2.title.equals(s)) continue;
            this.art = EnumAngelArt2;
        }
        if (this.art == null) {
            this.art = EnumAngelArt.AngelFive;
        }
        super.func_70037_a(tagCompund);
    }

    public int func_82329_d() {
        if (this.art == null) {
            this.art = EnumAngelArt.AngelFive;
        }
        return this.art.sizeX;
    }

    public int func_82330_g() {
        return this.art.sizeY;
    }

    public void func_110128_b(Entity entity) {
        if (this.field_70170_p.func_82736_K().func_82766_b("doTileDrops")) {
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                if (entityplayer.field_71075_bZ.field_75098_d) {
                    return;
                }
            }
            this.func_70099_a(new ItemStack(WAObjects.Items.ANGEL_PAINTING), 0.0f);
        }
    }

    public void func_184523_o() {
        this.func_184185_a(SoundEvents.field_187694_dK, 1.0f, 1.0f);
    }

    public void func_70012_b(double x, double y, double z, float yaw, float pitch) {
        BlockPos blockpos = new BlockPos(x - this.field_70165_t, y - this.field_70163_u, z - this.field_70161_v);
        BlockPos hangingPos = this.field_174861_a.func_177971_a((Vec3i)blockpos);
        this.func_70107_b(hangingPos.func_177958_n(), (double)hangingPos.func_177956_o() - 1.0, hangingPos.func_177952_p());
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.art.ordinal());
        buffer.writeInt(this.field_70176_ah);
        buffer.writeInt(this.field_70162_ai);
        buffer.writeInt(this.field_70164_aj);
        buffer.writeByte(this.func_174811_aO().func_176745_a());
    }

    public void readSpawnData(ByteBuf buffer) {
        EnumAngelArt[] ENUM_ART = EnumAngelArt.values();
        this.art = ENUM_ART[buffer.readInt()];
        this.field_70176_ah = buffer.readInt();
        this.field_70162_ai = buffer.readInt();
        this.field_70164_aj = buffer.readInt();
        this.func_174859_a(EnumFacing.func_176731_b((int)buffer.readByte()));
    }

    private void spawnAngel(World world) {
        if (!world.field_72995_K) {
            EntityWeepingAngel angel = new EntityWeepingAngel(world);
            angel.func_82149_j((Entity)this);
            Teleporter.move((Entity)angel, this.field_71093_bK, new BlockPos(this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0));
            world.func_72838_d((Entity)angel);
        }
    }

    public static enum EnumAngelArt {
        ANGEL_ONE("Angel_One", 0, 0),
        ANGEL_TWO("Angel_Two", 0, 64),
        BlankPaintingOne("Paint_BlankOne", 16, 64),
        AngelThree("Angel_Three", 32, 64),
        BlankPaintingTwo("Paint_BlankTwo", 48, 64),
        AngelFour("Angel_Four", 64, 64),
        BlankPaintingThree("Paint_BlankThree", 80, 64),
        AngelFive("Angel_Five", 96, 64),
        BlankPaintingFour("Paint_BlankFour", 112, 64),
        AngelSix("Angel_Six", 128, 64),
        BlankPaintingFive("Angel_Five", 144, 64),
        AngelSeven("Angel_Seven", 160, 64),
        BlankPaintingSix("Paint_BlankSix", 176, 64);

        public final String title;
        public final int sizeX;
        public final int sizeY;
        public final int offsetX;
        public final int offsetY;

        private EnumAngelArt(String name, int offsetX, int offsetY) {
            this.title = name;
            this.sizeX = 16;
            this.sizeY = 32;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
        }
    }
}

