/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.angels.common.entities;

import me.swirtzly.angels.client.models.poses.PoseManager;
import me.swirtzly.angels.common.WAObjects;
import me.swirtzly.angels.common.entities.AngelEnums;
import me.swirtzly.angels.common.entities.EntityQuantumLockBase;
import me.swirtzly.angels.common.misc.WAConstants;
import me.swirtzly.angels.config.WAConfig;
import me.swirtzly.angels.utils.AngelUtils;
import me.swirtzly.angels.utils.Teleporter;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockEndPortal;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketSoundEffect;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;

public class EntityWeepingAngel
extends EntityQuantumLockBase {
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(EntityWeepingAngel.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IS_CHILD = EntityDataManager.func_187226_a(EntityWeepingAngel.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<String> CURRENT_POSE = EntityDataManager.func_187226_a(EntityWeepingAngel.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> HUNGER_LEVEL = EntityDataManager.func_187226_a(EntityWeepingAngel.class, (DataSerializer)DataSerializers.field_187192_b);
    public static ResourceLocation LOOT_TABLE = new ResourceLocation("weeping-angels", "weepingangel");
    private SoundEvent[] SEEN_SOUNDS = new SoundEvent[]{WAObjects.Sounds.ANGEL_SEEN_1, WAObjects.Sounds.ANGEL_SEEN_2, WAObjects.Sounds.ANGEL_SEEN_3, WAObjects.Sounds.ANGEL_SEEN_4, WAObjects.Sounds.ANGEL_SEEN_5, WAObjects.Sounds.ANGEL_SEEN_6, WAObjects.Sounds.ANGEL_SEEN_7, WAObjects.Sounds.ANGEL_SEEN_8};
    private SoundEvent[] CHILD_SOUNDS = new SoundEvent[]{SoundEvents.field_191264_hc, WAObjects.Sounds.LAUGHING_CHILD};

    public EntityWeepingAngel(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 50.0f));
        this.field_70728_aV = WAConfig.angels.xpGained;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_CHILD, (Object)(this.field_70146_Z.nextInt(10) == 4 ? 1 : 0));
        this.func_184212_Q().func_187214_a(TYPE, (Object)AngelUtils.randomType().getId());
        this.func_184212_Q().func_187214_a(CURRENT_POSE, (Object)PoseManager.randomEnum(PoseManager.AngelPoses.class).name());
        this.func_184212_Q().func_187214_a(HUNGER_LEVEL, (Object)50);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        this.func_184185_a(WAObjects.Sounds.ANGEL_AMBIENT, 0.5f, 1.0f);
        return super.func_180482_a(difficulty, livingdata);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187843_fX;
    }

    protected SoundEvent func_184615_bR() {
        return WAObjects.Sounds.ANGEL_DEATH;
    }

    protected SoundEvent func_184639_G() {
        if (this.isCherub() && this.field_70173_aa % AngelUtils.secondsToTicks(2) == 0) {
            return this.CHILD_SOUNDS[this.field_70146_Z.nextInt(this.CHILD_SOUNDS.length)];
        }
        return null;
    }

    public float func_70047_e() {
        return this.isCherub() ? this.field_70131_O : 1.3f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(WAConfig.angels.damage);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(9999999.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
    }

    public boolean func_70652_k(Entity entity) {
        if (entity instanceof EntityPlayerMP) {
            boolean shouldTeleport;
            EntityPlayerMP playerMP = (EntityPlayerMP)entity;
            if (WAConfig.angels.torchBlowOut && this.isCherub()) {
                AngelUtils.removeLightFromHand(playerMP, this);
            }
            if (this.func_184614_ca().func_190926_b() && this.field_70146_Z.nextBoolean()) {
                for (int i = 0; i < playerMP.field_71071_by.func_70302_i_(); ++i) {
                    ItemStack stack = playerMP.field_71071_by.func_70301_a(i);
                    for (String regName : WAConstants.KEYS) {
                        if (!regName.matches(stack.func_77973_b().getRegistryName().toString())) continue;
                        this.func_184611_a(EnumHand.MAIN_HAND, playerMP.field_71071_by.func_70301_a(i).func_77946_l());
                        playerMP.field_71071_by.func_70301_a(i).func_190920_e(0);
                        playerMP.field_71069_bz.func_75142_b();
                    }
                }
            }
            if (WAConfig.teleport.justTeleport) {
                if (!this.isCherub()) {
                    this.teleportInteraction((EntityPlayer)playerMP);
                    return false;
                }
                this.dealDamage((EntityPlayer)playerMP);
                return true;
            }
            boolean bl = shouldTeleport = this.field_70146_Z.nextInt(10) < 5 && !this.isWeak();
            if (shouldTeleport) {
                this.teleportInteraction((EntityPlayer)playerMP);
                return false;
            }
            this.dealDamage((EntityPlayer)playerMP);
            return true;
        }
        return true;
    }

    protected ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    public void dealDamage(EntityPlayer playerMP) {
        if (this.func_110143_aJ() > 5.0f) {
            playerMP.func_70097_a(WAObjects.ANGEL, 4.0f);
            this.func_70691_i(4.0f);
        } else {
            playerMP.func_70097_a(WAObjects.ANGEL_NECK_SNAP, 4.0f);
            this.func_70691_i(2.0f);
        }
    }

    public void dropAngelStuff() {
        ResourceLocation resourcelocation = this.func_184647_J();
        LootTable loottable = this.field_70170_p.func_73046_m().func_130014_f_().func_184146_ak().func_186521_a(resourcelocation);
        LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)this.field_70170_p).func_186472_a((Entity)this).func_186473_a(DamageSource.field_76366_f);
        loottable.func_186462_a(this.field_70146_Z, lootcontext$builder.func_186471_a());
        this.func_70099_a(this.func_184614_ca(), this.func_184614_ca().func_190916_E());
        this.func_70099_a(this.func_184592_cb(), this.func_184592_cb().func_190916_E());
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        this.func_70099_a(this.func_184614_ca(), this.func_184614_ca().func_190916_E());
        this.func_70099_a(this.func_184592_cb(), this.func_184592_cb().func_190916_E());
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74778_a("pose", this.getPose());
        compound.func_74768_a("type", this.getType());
        compound.func_74757_a("angelChild", this.isCherub());
        compound.func_74768_a("hungerLevel", this.getHungerLevel());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("pose")) {
            this.setPose(compound.func_74779_i("pose"));
        }
        if (compound.func_74764_b("type")) {
            this.setType(compound.func_74762_e("type"));
        }
        if (compound.func_74764_b("angelChild")) {
            this.setChild(compound.func_74767_n("angelChild"));
        }
        if (compound.func_74764_b("hungerLevel")) {
            this.setHungerLevel(compound.func_74762_e("hungerLevel"));
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70173_aa % 2400 == 0 && !this.field_70170_p.field_72995_K) {
            this.setHungerLevel(this.getHungerLevel() - 2);
            if (this.isWeak()) {
                this.func_70097_a(DamageSource.field_76366_f, 2.0f);
            }
        }
    }

    @Override
    public void invokeSeen(EntityPlayer player) {
        super.invokeSeen(player);
        if (player instanceof EntityPlayerMP && this.getSeenTime() == 1 && this.getPrevPos().func_177986_g() != this.func_180425_c().func_177986_g()) {
            this.setPrevPos(this.func_180425_c());
            if (WAConfig.angels.playSeenSounds) {
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketSoundEffect(this.getSeenSound(), SoundCategory.HOSTILE, player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.2f, 1.0f));
            }
            if (this.getType() != AngelEnums.AngelType.ANGEL_THREE.getId()) {
                this.setPose(PoseManager.randomEnum(PoseManager.AngelPoses.class).name());
            } else {
                this.setPose(this.field_70146_Z.nextBoolean() ? PoseManager.AngelPoses.ANGRY.name() : PoseManager.AngelPoses.HIDING_FACE.name());
            }
        }
    }

    public SoundEvent getSeenSound() {
        return this.SEEN_SOUNDS[this.field_70146_Z.nextInt(this.SEEN_SOUNDS.length)];
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        SoundType soundtype = blockIn.getSoundType(this.field_70170_p.func_180495_p(pos), this.field_70170_p, pos, (Entity)this);
        if (this.field_70170_p.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150431_aC) {
            soundtype = Blocks.field_150431_aC.func_185467_w();
            this.func_184185_a(soundtype.func_185844_d(), soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b());
        }
        if (!blockIn.func_176223_P().func_185904_a().func_76224_d()) {
            if (WAConfig.angels.playScrapSounds && !this.isCherub()) {
                this.func_184185_a(WAObjects.Sounds.STONE_SCRAP, soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b());
            }
            if (this.isCherub() && this.field_70170_p.field_73012_v.nextInt(5) == 5) {
                this.func_184185_a(WAObjects.Sounds.CHILD_RUN, soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b());
            }
        }
    }

    @Override
    public void moveTowards(EntityLivingBase entity) {
        super.moveTowards(entity);
        if (this.isQuantumLocked()) {
            return;
        }
        if (WAConfig.angels.playScrapSounds && !this.isCherub()) {
            this.func_184185_a(WAObjects.Sounds.STONE_SCRAP, 0.2f, 1.0f);
        }
        if (this.isCherub() && this.field_70170_p.field_73012_v.nextInt(5) == 5) {
            this.func_184185_a(WAObjects.Sounds.CHILD_RUN, 1.0f, 1.0f);
        }
    }

    public boolean isWeak() {
        return this.getHungerLevel() < 15;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getSeenTime() == 0 || this.field_70170_p.func_175699_k(this.func_180425_c()) == 0 || this.field_70170_p.func_175623_d(this.func_180425_c().func_177977_b())) {
            this.func_94061_f(false);
        }
        if (this.field_70173_aa % 500 == 0 && this.func_70638_az() == null && !this.isQuantumLocked() && this.getSeenTime() == 0) {
            this.setPose(PoseManager.AngelPoses.HIDING_FACE.name());
        }
        this.replaceBlocks(this.func_174813_aQ().func_186662_g((double)WAConfig.angels.blockBreakRange));
    }

    public void func_70074_a(EntityLivingBase entityLivingIn) {
        super.func_70074_a(entityLivingIn);
        if (entityLivingIn instanceof EntityPlayer) {
            this.func_184185_a(WAObjects.Sounds.ANGEL_NECK_SNAP, 1.0f, 1.0f);
        }
    }

    protected PathNavigate func_175447_b(World worldIn) {
        PathNavigateGround navigator = new PathNavigateGround((EntityLiving)this, worldIn);
        navigator.func_179693_d(false);
        navigator.func_179688_b(true);
        navigator.func_179685_e(false);
        return navigator;
    }

    private void replaceBlocks(AxisAlignedBB box) {
        if (this.field_70170_p.field_72995_K || !WAConfig.angels.blockBreaking || this.field_70173_aa % 100 != 0 || this.isQuantumLocked()) {
            return;
        }
        if (this.field_70170_p.func_175699_k(this.func_180425_c()) == 0) {
            return;
        }
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)new BlockPos(box.field_72340_a, box.field_72338_b, box.field_72339_c), (BlockPos)new BlockPos(box.field_72336_d, box.field_72337_e, box.field_72334_f))) {
            IBlockState blockState = this.field_70170_p.func_180495_p(pos);
            if (!this.field_70170_p.func_82736_K().func_82766_b("mobGriefing") || !(this.func_110143_aJ() > 5.0f)) continue;
            if (blockState.func_177230_c() instanceof BlockButton && this.field_70146_Z.nextInt(5) < 2) {
                this.field_70170_p.func_180501_a(pos, blockState.func_177226_a((IProperty)BlockLever.field_176359_b, (Comparable)Boolean.TRUE), 3);
                this.field_70170_p.func_175704_b(pos, pos);
                this.field_70170_p.func_175685_c(pos, blockState.func_177230_c(), false);
                this.field_70170_p.func_175685_c(pos.func_177972_a(((EnumFacing)blockState.func_177229_b((IProperty)BlockButton.field_176387_N)).func_176734_d()), blockState.func_177230_c(), false);
                this.field_70170_p.func_175684_a(pos, blockState.func_177230_c(), blockState.func_177230_c() == Blocks.field_150471_bO ? 20 : 30);
            }
            if (blockState.func_177230_c() instanceof BlockLever && this.field_70146_Z.nextInt(5) < 2) {
                blockState = blockState.func_177231_a((IProperty)BlockLever.field_176359_b);
                this.field_70170_p.func_180501_a(pos, blockState, 3);
                float f = (Boolean)blockState.func_177229_b((IProperty)BlockLever.field_176359_b) != false ? 0.6f : 0.5f;
                this.field_70170_p.func_184133_a(null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, f);
                this.field_70170_p.func_175685_c(pos, blockState.func_177230_c(), false);
                EnumFacing enumfacing = ((BlockLever.EnumOrientation)blockState.func_177229_b((IProperty)BlockLever.field_176360_a)).func_176852_c();
                this.field_70170_p.func_175685_c(pos.func_177972_a(enumfacing.func_176734_d()), blockState.func_177230_c(), false);
            }
            if (!this.canBreak(blockState) || blockState.func_177230_c() == Blocks.field_150353_l || blockState.func_177230_c() == Blocks.field_150350_a) continue;
            if (blockState.func_177230_c() == Blocks.field_150478_aa || blockState.func_177230_c() == Blocks.field_150429_aA || blockState.func_177230_c() == Blocks.field_150426_aN) {
                AngelUtils.playBreakEvent((Entity)this, pos, Blocks.field_150350_a);
                return;
            }
            if (blockState.func_177230_c() == Blocks.field_150428_aP) {
                AngelUtils.playBreakEvent((Entity)this, pos, Blocks.field_150423_aK);
                return;
            }
            if (blockState.func_177230_c() == Blocks.field_150374_bv) {
                AngelUtils.playBreakEvent((Entity)this, pos, Blocks.field_150379_bu);
                return;
            }
            if (!(blockState.func_177230_c() instanceof BlockPortal) && !(blockState.func_177230_c() instanceof BlockEndPortal)) continue;
            if (this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70691_i(1.5f);
                this.field_70170_p.func_175698_g(pos);
            }
            return;
        }
    }

    private boolean canBreak(IBlockState blockState) {
        for (String regName : WAConfig.angels.disAllowedBlocks) {
            if (!blockState.func_177230_c().getRegistryName().toString().equals(regName)) continue;
            return false;
        }
        return true;
    }

    private void teleportInteraction(EntityPlayer player) {
        if (this.field_70170_p.field_72995_K || player.func_184812_l_() && !WAConfig.angels.teleportInCreative) {
            return;
        }
        AngelUtils.EnumTeleportType type = WAConfig.teleport.teleportType;
        switch (type) {
            case STRUCTURES: {
                Teleporter.handleStructures(player);
                break;
            }
            case RANDOM_PLACE: {
                if (this.field_70146_Z.nextBoolean()) {
                    BlockPos pos = new BlockPos(player.field_70165_t + (double)this.field_70146_Z.nextInt(WAConfig.teleport.teleportRange), 0.0, player.field_70161_v + (double)this.field_70146_Z.nextInt(WAConfig.teleport.teleportRange));
                    if (AngelUtils.isPosOutsideBorder(pos, player.field_70170_p)) {
                        pos = this.field_70170_p.func_175694_M().func_177982_a(this.field_70146_Z.nextInt(WAConfig.teleport.teleportRange), 0, this.field_70146_Z.nextInt(WAConfig.teleport.teleportRange));
                    }
                    Teleporter.moveSafeAcrossDim((Entity)player, pos);
                } else {
                    Teleporter.handleStructures(player);
                }
            }
            case DONT: {
                this.dealDamage(player);
                break;
            }
        }
    }

    public String getPose() {
        return (String)this.func_184212_Q().func_187225_a(CURRENT_POSE);
    }

    public void setPose(String newPose) {
        this.func_184212_Q().func_187227_b(CURRENT_POSE, (Object)newPose);
    }

    public boolean isCherub() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_CHILD);
    }

    public void setChild(boolean child) {
        this.func_184212_Q().func_187227_b(IS_CHILD, (Object)child);
    }

    public int getType() {
        return (Integer)this.func_184212_Q().func_187225_a(TYPE);
    }

    public void setType(int angelType) {
        this.func_184212_Q().func_187227_b(TYPE, (Object)angelType);
    }

    public int getHungerLevel() {
        return (Integer)this.func_184212_Q().func_187225_a(HUNGER_LEVEL);
    }

    public void setHungerLevel(int hunger) {
        this.func_184212_Q().func_187227_b(HUNGER_LEVEL, (Object)hunger);
    }
}

