/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.angels.common.world.generation.generators;

import java.util.Random;
import javax.annotation.Nonnull;
import me.swirtzly.angels.common.WAObjects;
import me.swirtzly.angels.config.WAConfig;
import me.swirtzly.angels.utils.AngelUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenOres
implements IWorldGenerator {
    public static final int OVERWORLD_MIN_Y = 8;
    public static final int OVERWORLD_MAX_Y = 64;
    public static final int OVERWORLD_SIZE = 6;
    public static final int OVERWORLD_CHANCE = 4;

    public void generate(@Nonnull Random random, int chunkX, int chunkZ, @Nonnull World world, @Nonnull IChunkGenerator chunkGenerator, @Nonnull IChunkProvider chunkProvider) {
        if (!WAConfig.worldGen.genOres) {
            return;
        }
        switch (world.field_73011_w.func_186058_p()) {
            case NETHER: {
                break;
            }
            case OVERWORLD: {
                this.genOverworld(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
                break;
            }
            case THE_END: {
                break;
            }
        }
    }

    private void genOverworld(@Nonnull Random random, int chunkX, int chunkZ, @Nonnull World world, @Nonnull IChunkGenerator chunkGenerator, @Nonnull IChunkProvider chunkProvider) {
        this.generateOre(WAObjects.Blocks.KONTRON_ORE.func_176223_P(), world, random, chunkX << 4, chunkZ << 4, 8, 64, 6, 4);
    }

    private void generateOre(@Nonnull IBlockState ore, @Nonnull World world, @Nonnull Random random, int x, int z, int minY, int maxY, int size, int chances) {
        for (int chance = 0; chance < chances; ++chance) {
            BlockPos pos = new BlockPos((double)(x + random.nextInt(8)), (double)minY + AngelUtils.randomBetween(minY, maxY), (double)(z + random.nextInt(8)));
            WorldGenMinable generator = new WorldGenMinable(ore, size);
            generator.func_180709_b(world, random, pos);
        }
    }
}

