/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.angels.compat.tardis;

import java.util.Objects;
import me.swirtzly.angels.WeepingAngels;
import me.swirtzly.angels.common.entities.EntityWeepingAngel;
import me.swirtzly.angels.config.WAConfig;
import me.swirtzly.angels.utils.Teleporter;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.tardis.mod.common.dimensions.TDimensions;
import net.tardis.mod.common.dimensions.WorldProviderTardis;
import net.tardis.mod.common.sounds.TSounds;
import net.tardis.mod.common.tileentity.TileEntityDoor;
import net.tardis.mod.common.tileentity.TileEntityTardis;
import net.tardis.mod.network.NetworkHandler;
import net.tardis.mod.network.packets.MessageDoorOpen;

public class TardisMod {
    public static void register() {
        if (WAConfig.integrations.tardisModIntegration) {
            WeepingAngels.LOGGER.info("Tardis Mod Detected, registering compatibility events");
            MinecraftForge.EVENT_BUS.register((Object)new TardisMod());
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent e) {
        if (e.getEntity() instanceof EntityWeepingAngel) {
            EntityWeepingAngel weepingAngel = (EntityWeepingAngel)e.getEntity();
            if (weepingAngel.field_70173_aa % 200 == 0 && WAConfig.integrations.tardisFuelTheft && e.getEntity().field_70170_p.field_73011_w instanceof WorldProviderTardis) {
                AxisAlignedBB box = weepingAngel.func_174813_aQ().func_186662_g((double)WAConfig.angels.blockBreakRange);
                for (BlockPos pos : BlockPos.func_177980_a((BlockPos)new BlockPos(box.field_72340_a, box.field_72338_b, box.field_72339_c), (BlockPos)new BlockPos(box.field_72336_d, box.field_72337_e, box.field_72334_f))) {
                    IBlockState blockState = weepingAngel.field_70170_p.func_180495_p(pos);
                    if (!blockState.func_177230_c().hasTileEntity(blockState) || weepingAngel.field_70170_p.func_175625_s(pos) == null) continue;
                    this.processTile(Objects.requireNonNull(weepingAngel.field_70170_p.func_175625_s(pos)), weepingAngel);
                }
            }
        }
    }

    private void processTile(TileEntity tileEntity, EntityWeepingAngel weepingAngel) {
        if (weepingAngel.func_174818_b(tileEntity.func_174877_v()) > 15.0) {
            return;
        }
        if (tileEntity instanceof TileEntityTardis && weepingAngel.field_70170_p.field_73011_w instanceof WorldProviderTardis) {
            TileEntityTardis tardis = (TileEntityTardis)tileEntity;
            if (tardis.fuel > 0.0f) {
                tardis.setFuel(tardis.fuel - TileEntityTardis.defaultFuelUse * 1.5f);
                tardis.func_145831_w().func_184133_a(null, tileEntity.func_174877_v(), TSounds.cloister_bell, SoundCategory.BLOCKS, 1.0f, 1.0f);
                tardis.func_70296_d();
                weepingAngel.func_70691_i(1.0f);
                return;
            }
        }
        if (tileEntity instanceof TileEntityDoor) {
            TileEntityDoor door = (TileEntityDoor)tileEntity;
            weepingAngel.func_70661_as().func_75492_a((double)tileEntity.func_174877_v().func_177958_n(), (double)tileEntity.func_174877_v().func_177956_o(), (double)tileEntity.func_174877_v().func_177952_p(), WAConfig.angels.moveSpeed);
            if (!(!(weepingAngel.func_174818_b(tileEntity.func_174877_v()) < 5.0) || weepingAngel.func_184614_ca().func_190926_b() && door.isLocked)) {
                NetworkHandler.NETWORK.sendToDimension((IMessage)new MessageDoorOpen(door.func_174877_v(), door), door.func_145831_w().field_73011_w.getDimension());
                BlockPos pos = door.getConsolePos().func_177967_a(EnumFacing.SOUTH, 3);
                weepingAngel.changeDimension(TDimensions.TARDIS_ID, new Teleporter.WATeleport(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
                try {
                    TileEntityTardis tile = (TileEntityTardis)DimensionManager.getWorld((int)TDimensions.TARDIS_ID).func_175625_s(door.getConsolePos());
                    if (tile != null && !tile.isInFlight() && weepingAngel.field_70173_aa < 500 && WAConfig.integrations.tardisTheft) {
                        DimensionType dimensionDest = null;
                        dimensionDest = WAConfig.integrations.tardisTheftDimensional ? Teleporter.getRandomDimension((Entity)weepingAngel, door.func_145831_w().field_73012_v) : DimensionManager.getWorld((int)tile.dimension).field_73011_w.func_186058_p();
                        tile.setDesination(new BlockPos(tile.func_174877_v().func_177958_n() + tile.func_145831_w().field_73012_v.nextInt(WAConfig.integrations.theftRange), 64, tile.func_174877_v().func_177952_p() + tile.func_145831_w().field_73012_v.nextInt(WAConfig.integrations.theftRange)), dimensionDest.func_186068_a());
                        tile.getDoor().setOpen(false);
                        tile.startFlight();
                        tile.func_70296_d();
                        door.func_70296_d();
                    }
                }
                catch (Exception exc) {
                    WeepingAngels.LOGGER.error("Something went wrong while a Angel entered the tardis", (Throwable)exc);
                }
            }
        }
    }
}

