/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.angels.utils;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import me.swirtzly.angels.common.entities.EntityQuantumLockBase;
import me.swirtzly.angels.config.WAConfig;
import me.swirtzly.angels.proxy.CommonProxy;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;

public class ViewUtil {
    private static final float headSize = 0.15f;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isInFrontOfEntity(Entity entity, Entity target, boolean vr) {
        Vec3d vecLook;
        Vec3d vecTargetsPos = target.func_174791_d();
        if (vr) {
            if (!(entity instanceof EntityPlayer)) throw new RuntimeException("Attempted to use a non-player entity with VRSupport: " + entity.getEntityData());
            vecLook = CommonProxy.reflector.getHMDRot((EntityPlayer)entity);
        } else {
            vecLook = entity.func_70040_Z();
        }
        Vec3d vecFinal = vecTargetsPos.func_72444_a(new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v)).func_72432_b();
        vecFinal = new Vec3d(vecFinal.field_72450_a, 0.0, vecFinal.field_72449_c);
        if (!(vecFinal.func_72430_b(vecLook) < 0.0)) return false;
        return true;
    }

    public static boolean viewBlocked(EntityLivingBase viewer, EntityLivingBase angel) {
        if (viewer.func_70608_bn()) {
            return false;
        }
        AxisAlignedBB viewerBoundBox = viewer.func_174813_aQ();
        AxisAlignedBB angelBoundingBox = angel.func_174813_aQ();
        Vec3d[] viewerPoints = new Vec3d[]{new Vec3d(viewerBoundBox.field_72340_a, viewerBoundBox.field_72338_b, viewerBoundBox.field_72339_c), new Vec3d(viewerBoundBox.field_72340_a, viewerBoundBox.field_72338_b, viewerBoundBox.field_72334_f), new Vec3d(viewerBoundBox.field_72340_a, viewerBoundBox.field_72337_e, viewerBoundBox.field_72339_c), new Vec3d(viewerBoundBox.field_72340_a, viewerBoundBox.field_72337_e, viewerBoundBox.field_72334_f), new Vec3d(viewerBoundBox.field_72336_d, viewerBoundBox.field_72337_e, viewerBoundBox.field_72339_c), new Vec3d(viewerBoundBox.field_72336_d, viewerBoundBox.field_72337_e, viewerBoundBox.field_72334_f), new Vec3d(viewerBoundBox.field_72336_d, viewerBoundBox.field_72338_b, viewerBoundBox.field_72334_f), new Vec3d(viewerBoundBox.field_72336_d, viewerBoundBox.field_72338_b, viewerBoundBox.field_72339_c)};
        if (viewer instanceof EntityPlayer) {
            Vec3d pos2 = CommonProxy.reflector.isVRPlayer((EntityPlayer)viewer) ? CommonProxy.reflector.getHMDPos((EntityPlayer)viewer) : new Vec3d(viewer.field_70165_t, viewer.field_70163_u + (double)1.62f, viewer.field_70161_v);
            viewerPoints[0] = pos2.func_72441_c((double)-0.15f, (double)-0.15f, (double)-0.15f);
            viewerPoints[1] = pos2.func_72441_c((double)-0.15f, (double)-0.15f, (double)0.15f);
            viewerPoints[2] = pos2.func_72441_c((double)-0.15f, (double)0.15f, (double)-0.15f);
            viewerPoints[3] = pos2.func_72441_c((double)-0.15f, (double)0.15f, (double)0.15f);
            viewerPoints[4] = pos2.func_72441_c((double)0.15f, (double)0.15f, (double)-0.15f);
            viewerPoints[5] = pos2.func_72441_c((double)0.15f, (double)0.15f, (double)0.15f);
            viewerPoints[6] = pos2.func_72441_c((double)0.15f, (double)-0.15f, (double)0.15f);
            viewerPoints[7] = pos2.func_72441_c((double)0.15f, (double)-0.15f, (double)-0.15f);
        }
        Vec3d[] angelPoints = new Vec3d[]{new Vec3d(angelBoundingBox.field_72340_a, angelBoundingBox.field_72338_b, angelBoundingBox.field_72339_c), new Vec3d(angelBoundingBox.field_72340_a, angelBoundingBox.field_72338_b, angelBoundingBox.field_72334_f), new Vec3d(angelBoundingBox.field_72340_a, angelBoundingBox.field_72337_e, angelBoundingBox.field_72339_c), new Vec3d(angelBoundingBox.field_72340_a, angelBoundingBox.field_72337_e, angelBoundingBox.field_72334_f), new Vec3d(angelBoundingBox.field_72336_d, angelBoundingBox.field_72337_e, angelBoundingBox.field_72339_c), new Vec3d(angelBoundingBox.field_72336_d, angelBoundingBox.field_72337_e, angelBoundingBox.field_72334_f), new Vec3d(angelBoundingBox.field_72336_d, angelBoundingBox.field_72338_b, angelBoundingBox.field_72334_f), new Vec3d(angelBoundingBox.field_72336_d, angelBoundingBox.field_72338_b, angelBoundingBox.field_72339_c)};
        for (int i = 0; i < viewerPoints.length; ++i) {
            if (viewer.field_70170_p.func_147447_a(viewerPoints[i], angelPoints[i], false, true, false) == null) {
                return false;
            }
            if (ViewUtil.rayTraceBlocks(viewer.field_70170_p, viewerPoints[i], angelPoints[i], pos -> {
                IBlockState state = viewer.field_70170_p.func_180495_p(pos);
                return !ViewUtil.canSeeThrough(state, angel.field_70170_p, pos);
            }) != null) continue;
            return false;
        }
        if (angel.field_70173_aa % 1200 == 0 && angel.func_70032_d((Entity)viewer) < 15.0f) {
            viewer.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 15));
        }
        return true;
    }

    @Nullable
    private static RayTraceResult rayTraceBlocks(World world, Vec3d vec31, Vec3d vec32, Predicate<BlockPos> stopOn) {
        if (!(Double.isNaN(vec31.field_72450_a) || Double.isNaN(vec31.field_72448_b) || Double.isNaN(vec31.field_72449_c) || Double.isNaN(vec32.field_72450_a) || Double.isNaN(vec32.field_72448_b) || Double.isNaN(vec32.field_72449_c))) {
            RayTraceResult raytraceresult;
            int i = MathHelper.func_76128_c((double)vec32.field_72450_a);
            int j = MathHelper.func_76128_c((double)vec32.field_72448_b);
            int k = MathHelper.func_76128_c((double)vec32.field_72449_c);
            int l = MathHelper.func_76128_c((double)vec31.field_72450_a);
            int i1 = MathHelper.func_76128_c((double)vec31.field_72448_b);
            int j1 = MathHelper.func_76128_c((double)vec31.field_72449_c);
            BlockPos blockpos = new BlockPos(l, i1, j1);
            IBlockState iblockstate = world.func_180495_p(blockpos);
            if (stopOn.test(blockpos) && (raytraceresult = iblockstate.func_185910_a(world, blockpos, vec31, vec32)) != null) {
                return raytraceresult;
            }
            int k1 = 200;
            while (k1-- >= 0) {
                RayTraceResult raytraceresult1;
                EnumFacing enumfacing;
                if (Double.isNaN(vec31.field_72450_a) || Double.isNaN(vec31.field_72448_b) || Double.isNaN(vec31.field_72449_c)) {
                    return null;
                }
                if (l == i && i1 == j && j1 == k) {
                    return null;
                }
                boolean flag2 = true;
                boolean flag = true;
                boolean flag1 = true;
                double d0 = 999.0;
                double d1 = 999.0;
                double d2 = 999.0;
                if (i > l) {
                    d0 = (double)l + 1.0;
                } else if (i < l) {
                    d0 = (double)l + 0.0;
                } else {
                    flag2 = false;
                }
                if (j > i1) {
                    d1 = (double)i1 + 1.0;
                } else if (j < i1) {
                    d1 = (double)i1 + 0.0;
                } else {
                    flag = false;
                }
                if (k > j1) {
                    d2 = (double)j1 + 1.0;
                } else if (k < j1) {
                    d2 = (double)j1 + 0.0;
                } else {
                    flag1 = false;
                }
                double d3 = 999.0;
                double d4 = 999.0;
                double d5 = 999.0;
                double d6 = vec32.field_72450_a - vec31.field_72450_a;
                double d7 = vec32.field_72448_b - vec31.field_72448_b;
                double d8 = vec32.field_72449_c - vec31.field_72449_c;
                if (flag2) {
                    d3 = (d0 - vec31.field_72450_a) / d6;
                }
                if (flag) {
                    d4 = (d1 - vec31.field_72448_b) / d7;
                }
                if (flag1) {
                    d5 = (d2 - vec31.field_72449_c) / d8;
                }
                if (d3 == -0.0) {
                    d3 = -1.0E-4;
                }
                if (d4 == -0.0) {
                    d4 = -1.0E-4;
                }
                if (d5 == -0.0) {
                    d5 = -1.0E-4;
                }
                if (d3 < d4 && d3 < d5) {
                    enumfacing = i > l ? EnumFacing.WEST : EnumFacing.EAST;
                    vec31 = new Vec3d(d0, vec31.field_72448_b + d7 * d3, vec31.field_72449_c + d8 * d3);
                } else if (d4 < d5) {
                    enumfacing = j > i1 ? EnumFacing.DOWN : EnumFacing.UP;
                    vec31 = new Vec3d(vec31.field_72450_a + d6 * d4, d1, vec31.field_72449_c + d8 * d4);
                } else {
                    enumfacing = k > j1 ? EnumFacing.NORTH : EnumFacing.SOUTH;
                    vec31 = new Vec3d(vec31.field_72450_a + d6 * d5, vec31.field_72448_b + d7 * d5, d2);
                }
                if (!stopOn.test(blockpos = new BlockPos(l = MathHelper.func_76128_c((double)vec31.field_72450_a) - (enumfacing == EnumFacing.EAST ? 1 : 0), i1 = MathHelper.func_76128_c((double)vec31.field_72448_b) - (enumfacing == EnumFacing.UP ? 1 : 0), j1 = MathHelper.func_76128_c((double)vec31.field_72449_c) - (enumfacing == EnumFacing.SOUTH ? 1 : 0))) || (raytraceresult1 = world.func_180495_p(blockpos).func_185910_a(world, blockpos, vec31, vec32)) == null) continue;
                return raytraceresult1;
            }
        }
        return null;
    }

    public static boolean canEntitySee(EntityLivingBase viewer, EntityLivingBase beingViewed) {
        double dx = beingViewed.field_70165_t - viewer.field_70165_t;
        double dz = beingViewed.field_70165_t - viewer.field_70161_v;
        while (dx * dx + dz * dz < 1.0E-4) {
            dx = (Math.random() - Math.random()) * 0.01;
            dz = (Math.random() - Math.random()) * 0.01;
        }
        while (viewer.field_70177_z > 360.0f) {
            viewer.field_70177_z -= 360.0f;
        }
        while (viewer.field_70177_z < -360.0f) {
            viewer.field_70177_z += 360.0f;
        }
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - viewer.field_70177_z;
        yaw -= 90.0f;
        while (yaw < -180.0f) {
            yaw += 360.0f;
        }
        while (yaw >= 180.0f) {
            yaw -= 360.0f;
        }
        return yaw < 60.0f && yaw > -60.0f && viewer.func_70685_l((Entity)beingViewed);
    }

    public static boolean isInSightTile(EntityLivingBase viewer, TileEntity tile) {
        double dx = (double)tile.func_174877_v().func_177958_n() - viewer.field_70165_t;
        double dz = (double)tile.func_174877_v().func_177958_n() - viewer.field_70161_v;
        while (dx * dx + dz * dz < 1.0E-4) {
            dx = (Math.random() - Math.random()) * 0.01;
            dz = (Math.random() - Math.random()) * 0.01;
        }
        while (viewer.field_70177_z > 360.0f) {
            viewer.field_70177_z -= 360.0f;
        }
        while (viewer.field_70177_z < -360.0f) {
            viewer.field_70177_z += 360.0f;
        }
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - viewer.field_70177_z;
        yaw -= 90.0f;
        while (yaw < -180.0f) {
            yaw += 360.0f;
        }
        while (yaw >= 180.0f) {
            yaw -= 360.0f;
        }
        return yaw < 60.0f && yaw > -60.0f;
    }

    public static boolean isInSight(EntityLivingBase livingBase, EntityQuantumLockBase angel) {
        if (ViewUtil.viewBlocked(livingBase, (EntityLivingBase)angel)) {
            return false;
        }
        if (livingBase instanceof EntityPlayer) {
            return ViewUtil.isInFrontOfEntity((Entity)livingBase, (Entity)angel, CommonProxy.reflector.isVRPlayer((EntityPlayer)livingBase));
        }
        return ViewUtil.isInFrontOfEntity((Entity)livingBase, (Entity)angel, false);
    }

    public static boolean canSeeThrough(IBlockState blockState, World world, BlockPos pos) {
        Block block = blockState.func_177230_c();
        if (block instanceof BlockPortal) {
            return !Loader.isModLoaded((String)"betterportals");
        }
        if (!blockState.func_185896_q() || !blockState.func_185914_p()) {
            return true;
        }
        if (block instanceof BlockDoor) {
            return blockState.func_177228_b().get((Object)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.UPPER;
        }
        for (String transparent_block : WAConfig.angels.transparent_blocks) {
            if (!blockState.func_177230_c().getRegistryName().toString().equals(transparent_block)) continue;
            return true;
        }
        return blockState.func_185890_d((IBlockAccess)world, pos) == Block.field_185506_k;
    }
}

