/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.abyssaldepths;

import chumbanotz.abyssaldepths.ADConfig;
import chumbanotz.abyssaldepths.AbyssalDepths;
import chumbanotz.abyssaldepths.block.ADBlocks;
import chumbanotz.abyssaldepths.block.Seaweed;
import chumbanotz.abyssaldepths.entity.BodyPart;
import chumbanotz.abyssaldepths.entity.SeaSerpent;
import chumbanotz.abyssaldepths.entity.Seahorse;
import chumbanotz.abyssaldepths.entity.billfish.Sailfish;
import chumbanotz.abyssaldepths.entity.billfish.Swordfish;
import chumbanotz.abyssaldepths.entity.fish.Basslet;
import chumbanotz.abyssaldepths.entity.fish.Butterflyfish;
import chumbanotz.abyssaldepths.entity.fish.Clownfish;
import chumbanotz.abyssaldepths.entity.fish.CommonFish;
import chumbanotz.abyssaldepths.item.Goggles;
import chumbanotz.abyssaldepths.item.SpikeSword;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="abyssaldepths")
public class RegistryHandler {
    private static int entityId;

    @SubscribeEvent
    public static void onBlockRegistry(RegistryEvent.Register<Block> event) {
        event.getRegistry().register((IForgeRegistryEntry)RegistryHandler.setRegistryName("seaweed", new Seaweed()));
    }

    @SubscribeEvent
    public static void onItemRegistry(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)RegistryHandler.setRegistryName("seaweed", new ItemBlock(ADBlocks.SEAWEED)), (Item)RegistryHandler.setRegistryName("goggles", new Goggles()), RegistryHandler.setRegistryName("short_billfish_spike", new Item()), RegistryHandler.setRegistryName("long_billfish_spike", new Item()), RegistryHandler.setRegistryName("spike_sword", new SpikeSword()), (Item)RegistryHandler.setRegistryName("bannerfish", new ItemFood(3, 0.4f, false)), (Item)RegistryHandler.setRegistryName("butterflyfish", new ItemFood(2, 0.1f, false)), (Item)RegistryHandler.setRegistryName("cooked_butterflyfish", new ItemFood(6, 0.6f, false)), (Item)RegistryHandler.setRegistryName("masked_butterflyfish", new ItemFood(2, 0.1f, false)), (Item)RegistryHandler.setRegistryName("raccoon_butterflyfish", new ItemFood(2, 0.1f, false)), (Item)RegistryHandler.setRegistryName("spotfin_butterflyfish", new ItemFood(2, 0.1f, false))});
    }

    @SubscribeEvent
    public static void onEntityEntryRegistry(RegistryEvent.Register<EntityEntry> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new EntityEntry[]{RegistryHandler.createEntry("body_part", BodyPart.class).tracker(80, 1, true).build(), RegistryHandler.createEntry("fish", CommonFish.class, 8762546, 12307920, ADConfig.SPAWNS.fishWeight, 3, 5).build(), RegistryHandler.createEntry("clownfish", Clownfish.class, 13785366, 0xFFFFFF, ADConfig.SPAWNS.clownfishWeight, 2, 3).build(), RegistryHandler.createEntry("seahorse", Seahorse.class, 13818758, 0x778833, ADConfig.SPAWNS.seahorseWeight, 1, 3).build(), RegistryHandler.createEntry("butterflyfish", Butterflyfish.class, 8762546, 12307920, ADConfig.SPAWNS.butterflyfishWeight, 2, 5).build(), RegistryHandler.createEntry("masked_butterflyfish", Butterflyfish.Masked.class, 16438016, 3817060, ADConfig.SPAWNS.maskedButterflyfishWeight, 2, 5).build(), RegistryHandler.createEntry("raccoon_butterflyfish", Butterflyfish.Raccoon.class, 16297728, 1513499, ADConfig.SPAWNS.raccoonButterflyfishWeight, 3, 5).build(), RegistryHandler.createEntry("spotfin_butterflyfish", Butterflyfish.Spotfin.class, 16311296, 16121335, ADConfig.SPAWNS.spotfinButterflyfishWeight, 3, 5).build(), RegistryHandler.createEntry("bannerfish", Butterflyfish.Banner.class, 16183797, 0x121212, ADConfig.SPAWNS.bannerfishWeight, 2, 5).build(), RegistryHandler.createEntry("fairy_basslet", Basslet.Fairy.class, 12599507, 16693761, ADConfig.SPAWNS.fairyBassletWeight, 1, 4).build(), RegistryHandler.createEntry("blackcap_basslet", Basslet.BlackCap.class, 12599507, 0x121212, ADConfig.SPAWNS.blackcapBassletWeight, 1, 4).build(), RegistryHandler.createEntry("sailfish", Sailfish.class, 1060456, 0xE0E0E0, ADConfig.SPAWNS.sailfishWeight, 1, 5).build(), RegistryHandler.createEntry("swordfish", Swordfish.class, 1060456, 0xE0E0E0, ADConfig.SPAWNS.swordfishWeight, 1, 4).build(), RegistryHandler.createEntry("sea_serpent", SeaSerpent.class, 5938242, 9398119, ADConfig.SPAWNS.seaSerpentWeight, 1, 2).build()});
    }

    private static EntityEntryBuilder<?> createEntry(String name, Class<? extends EntityLiving> entityClass, int eggPrimary, int eggSecondary, int weight, int min, int max) {
        RegistryHandler.addSpawn(entityClass, weight, min, max);
        return RegistryHandler.createEntry(name, entityClass).egg(eggPrimary, eggSecondary).tracker(80, 3, true);
    }

    private static EntityEntryBuilder<?> createEntry(String name, Class<? extends Entity> entityClass) {
        if (EntityLiving.class.isAssignableFrom(entityClass)) {
            LootTableList.func_186375_a((ResourceLocation)AbyssalDepths.prefix("entities/" + name));
            EntitySpawnPlacementRegistry.setPlacementType(entityClass, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
        }
        return EntityEntryBuilder.create().entity(entityClass).id(AbyssalDepths.prefix(name), entityId++).name("abyssaldepths." + name);
    }

    private static void addSpawn(Class<? extends EntityLiving> entityClass, int weight, int min, int max) {
        if (weight <= 0) {
            return;
        }
        for (Biome biome : ForgeRegistries.BIOMES) {
            boolean add = false;
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.VOID) || !(add = entityClass == CommonFish.class ? BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WATER) : BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN))) continue;
            biome.func_76747_a(EnumCreatureType.WATER_CREATURE).add(new Biome.SpawnListEntry(entityClass, MathHelper.func_76125_a((int)weight, (int)1, (int)100), min, max));
        }
    }

    public static <T extends IForgeRegistryEntry<T>> T setRegistryName(String name, T entry) {
        ResourceLocation registryName = AbyssalDepths.prefix(name);
        if (entry instanceof Block) {
            ((Block)entry).func_149663_c("abyssaldepths." + registryName.func_110623_a());
            ((Block)entry).func_149647_a(AbyssalDepths.CREATIVE_TAB);
        }
        if (entry instanceof Item) {
            ((Item)entry).func_77655_b("abyssaldepths." + registryName.func_110623_a());
            ((Item)entry).func_77637_a(AbyssalDepths.CREATIVE_TAB);
        }
        return (T)((IForgeRegistryEntry)entry.setRegistryName(registryName));
    }
}

