/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.abyssaldepths.client.renderer;

import chumbanotz.abyssaldepths.AbyssalDepths;
import chumbanotz.abyssaldepths.client.model.ModelFish;
import chumbanotz.abyssaldepths.client.renderer.RenderAquaticCreature;
import chumbanotz.abyssaldepths.entity.fish.Basslet;
import chumbanotz.abyssaldepths.entity.fish.Butterflyfish;
import chumbanotz.abyssaldepths.entity.fish.Clownfish;
import chumbanotz.abyssaldepths.entity.fish.CommonFish;
import chumbanotz.abyssaldepths.entity.fish.Fish;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderFish
extends RenderAquaticCreature<Fish> {
    private static final ResourceLocation fishTexture = AbyssalDepths.getEntityTexture("fish");
    private static final ResourceLocation fishGrayTexture = AbyssalDepths.getEntityTexture("fish_grayscale");
    private static final ResourceLocation clownfishTexture = AbyssalDepths.getEntityTexture("clownfish");
    private static final ResourceLocation clownfishTexture1 = AbyssalDepths.getEntityTexture("clownfish_1");
    private static final ResourceLocation butterflyfishTexture = AbyssalDepths.getEntityTexture("butterflyfish/grayscale");
    private static final ResourceLocation butterflyfishMaskedTexture = AbyssalDepths.getEntityTexture("butterflyfish/masked");
    private static final ResourceLocation butterflyfishRaccoonTexture = AbyssalDepths.getEntityTexture("butterflyfish/raccoon");
    private static final ResourceLocation butterflyfishSpotfinTexture = AbyssalDepths.getEntityTexture("butterflyfish/spotfin");
    private static final ResourceLocation bannerfishTexture = AbyssalDepths.getEntityTexture("bannerfish");
    private static final ResourceLocation bassletFairyTexture = AbyssalDepths.getEntityTexture("basslet/fairy");
    private static final ResourceLocation bassletBlackCapTexture = AbyssalDepths.getEntityTexture("basslet/blackcap");

    public RenderFish(RenderManager rendermanagerIn) {
        super(rendermanagerIn, new ModelFish(), 0.4f);
    }

    public RenderFish(RenderManager rendermanagerIn, ModelBase base, float shadowSize) {
        super(rendermanagerIn, base, shadowSize);
    }

    public ResourceLocation getEntityTexture(Fish entity) {
        if (entity instanceof CommonFish && ((CommonFish)entity).isColorful()) {
            return fishGrayTexture;
        }
        if (entity instanceof Clownfish) {
            return ((Clownfish)entity).hasOneStripe() ? clownfishTexture1 : clownfishTexture;
        }
        if (entity instanceof Butterflyfish.Masked) {
            return butterflyfishMaskedTexture;
        }
        if (entity instanceof Butterflyfish.Raccoon) {
            return butterflyfishRaccoonTexture;
        }
        if (entity instanceof Butterflyfish.Spotfin) {
            return butterflyfishSpotfinTexture;
        }
        if (entity instanceof Butterflyfish.Banner) {
            return bannerfishTexture;
        }
        if (entity instanceof Butterflyfish) {
            return butterflyfishTexture;
        }
        if (entity instanceof Basslet.Fairy) {
            return bassletFairyTexture;
        }
        return entity instanceof Basslet.BlackCap ? bassletBlackCapTexture : fishTexture;
    }

    @Override
    protected void preRenderCallback(Fish living, float partialTick) {
        super.preRenderCallback(living, partialTick);
        if (living.getScale() != 1.0f) {
            GlStateManager.func_179152_a((float)living.getScale(), (float)living.getScale(), (float)living.getScale());
        }
    }

    protected void renderModel(Fish living, float par2, float par3, float par4, float par5, float par6, float par7) {
        this.field_76989_e = living.getScale() * 0.25f;
        if (!living.isColorful()) {
            super.func_77036_a((EntityLivingBase)living, par2, par3, par4, par5, par6, par7);
        } else {
            this.func_180548_c((Entity)living);
            int color = living.getColor();
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color >> 0 & 0xFF) / 255.0f;
            GlStateManager.func_179124_c((float)red, (float)green, (float)blue);
            if (!living.func_82150_aj()) {
                this.field_77045_g.func_78088_a((Entity)living, par2, par3, par4, par5, par6, par7);
            } else if (!living.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)0.15f);
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)770, (int)771);
                GlStateManager.func_179092_a((int)516, (float)0.003921569f);
                this.field_77045_g.func_78088_a((Entity)living, par2, par3, par4, par5, par6, par7);
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179084_k();
                GlStateManager.func_179092_a((int)516, (float)0.1f);
                GlStateManager.func_179121_F();
                GlStateManager.func_179132_a((boolean)true);
            } else {
                this.field_77045_g.func_78087_a(par2, par3, par4, par5, par6, par7, (Entity)living);
            }
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

