/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.abyssaldepths.client.renderer;

import chumbanotz.abyssaldepths.AbyssalDepths;
import chumbanotz.abyssaldepths.client.model.ModelSeahorse;
import chumbanotz.abyssaldepths.client.renderer.RenderAquaticCreature;
import chumbanotz.abyssaldepths.entity.Seahorse;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.LayeredTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderSeahorse
extends RenderAquaticCreature<Seahorse> {
    private static final Map<String, ResourceLocation> LAYERED_LOCATION_CACHE = Maps.newHashMap();
    private static final ResourceLocation TEXTURE = AbyssalDepths.getEntityTexture("seahorse/grayscale");
    private static final ResourceLocation EYES_TEXTURE = AbyssalDepths.getEntityTexture("seahorse/eyes");

    public RenderSeahorse(RenderManager rendermanagerIn) {
        super(rendermanagerIn, new ModelSeahorse(), 0.4f);
        this.func_177094_a(new LayerEyes());
    }

    public ResourceLocation getEntityTexture(Seahorse entity) {
        if (entity.getMark() == 0) {
            return TEXTURE;
        }
        String textureId = this.getTextureId(entity);
        ResourceLocation layered = LAYERED_LOCATION_CACHE.get(textureId);
        if (layered == null) {
            layered = new ResourceLocation(textureId);
            String[] textures = new String[]{"abyssaldepths:textures/entity/seahorse/grayscale.png", "abyssaldepths:textures/entity/seahorse/mark" + entity.getMark() + ".png"};
            Minecraft.func_71410_x().func_110434_K().func_110579_a(layered, (ITextureObject)new LayeredTexture(textures));
            LAYERED_LOCATION_CACHE.put(textureId, layered);
        }
        return layered;
    }

    protected void renderModel(Seahorse living, float par2, float par3, float par4, float par5, float par6, float par7) {
        this.func_180548_c((Entity)living);
        int color = living.getColor();
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color >> 0 & 0xFF) / 255.0f;
        GlStateManager.func_179124_c((float)red, (float)green, (float)blue);
        if (!living.func_82150_aj()) {
            this.field_77045_g.func_78088_a((Entity)living, par2, par3, par4, par5, par6, par7);
        } else if (!living.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)0.15f);
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179092_a((int)516, (float)0.003921569f);
            this.field_77045_g.func_78088_a((Entity)living, par2, par3, par4, par5, par6, par7);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179084_k();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179121_F();
            GlStateManager.func_179132_a((boolean)true);
        } else {
            this.field_77045_g.func_78087_a(par2, par3, par4, par5, par6, par7, (Entity)living);
        }
    }

    private String getTextureId(Seahorse seahorse) {
        String path = "abyssaldepths:textures/entity/seahorse/";
        String markNo = String.valueOf(seahorse.getMark());
        return path + markNo + ".png";
    }

    @SideOnly(value=Side.CLIENT)
    class LayerEyes
    implements LayerRenderer<Seahorse> {
        private final ModelSeahorse modelSeahorse = new ModelSeahorse(0.01f);

        LayerEyes() {
        }

        public void doRenderLayer(Seahorse entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            if (!entitylivingbaseIn.func_82150_aj()) {
                RenderSeahorse.this.func_110776_a(EYES_TEXTURE);
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                this.modelSeahorse.func_78088_a((Entity)entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            }
        }

        public boolean func_177142_b() {
            return true;
        }
    }
}

