/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.abyssaldepths.entity;

import chumbanotz.abyssaldepths.AbyssalDepths;
import chumbanotz.abyssaldepths.util.ADGlobal;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class AquaticCreature
extends EntityCreature {
    protected float currentYaw;
    public float currentPitch;
    protected float prevCurrentYaw;
    public float prevCurrentPitch;
    protected double netSpeed;
    protected double dPosX;
    protected double dPosY;
    protected double dPosZ;
    protected Vec3d targetVec;

    public AquaticCreature(World world) {
        super(world);
    }

    protected int func_70693_a(EntityPlayer player) {
        return 1 + this.field_70170_p.field_73012_v.nextInt(3);
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return super.func_184228_n(entityIn) && entityIn instanceof EntityLivingBase;
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    public boolean onLand() {
        return !this.func_70090_H() && this.field_70122_E;
    }

    public boolean getTamed() {
        return false;
    }

    public boolean getRotatePitch() {
        return true;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.field_70761_aq = this.field_70759_as = MathHelper.func_76142_g((float)this.field_70759_as);
        this.field_70177_z = this.field_70759_as;
        if (this.dPosX * this.dPosX + this.dPosY * this.dPosY + this.dPosZ * this.dPosZ < 1.6000001778593287E-5) {
            this.field_70125_A = 0.0f;
        }
        this.currentYaw = ADGlobal.wrapAngleAround(this.currentYaw, this.field_70177_z);
        this.currentPitch = ADGlobal.wrapAngleAround(this.currentPitch, this.field_70125_A);
        this.prevCurrentYaw = this.currentYaw;
        this.prevCurrentPitch = this.currentPitch;
        this.prevCurrentYaw = ADGlobal.wrapAngleAround(this.prevCurrentYaw, this.currentYaw);
        this.prevCurrentPitch = ADGlobal.wrapAngleAround(this.prevCurrentPitch, this.currentPitch);
        this.currentYaw += (this.field_70177_z - this.currentYaw) * 0.6f;
    }

    protected void func_70619_bc() {
        this.moveCreature();
    }

    protected abstract void moveCreature();

    public boolean findNewPath() {
        return this.field_70146_Z.nextInt(70) == 0 || this.onLand() && this.field_70146_Z.nextInt(10) == 0;
    }

    protected double addPathY() {
        return this.func_70047_e();
    }

    public boolean setRandomPath() {
        double x = this.field_70165_t + (3.0 + (double)this.field_70146_Z.nextFloat() * 3.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1);
        double y = this.field_70163_u + ((double)this.field_70146_Z.nextFloat() - 0.5) * 6.0 + this.addPathY();
        double z = this.field_70161_v + (3.0 + (double)this.field_70146_Z.nextFloat() * 3.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1);
        if (this.onLand()) {
            x = this.field_70165_t + (2.0 + (double)this.field_70146_Z.nextFloat() * 8.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1);
            z = this.field_70161_v + (2.0 + (double)this.field_70146_Z.nextFloat() * 8.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1);
        }
        if (this.isClearPath(x, y, z)) {
            this.targetVec = new Vec3d(x, y, z);
            return true;
        }
        return false;
    }

    public boolean isClearPath(double x, double y, double z) {
        boolean water = this.field_70170_p.func_180495_p(new BlockPos((int)x, (int)y, (int)z)).func_185904_a() == Material.field_151586_h;
        boolean seen = this.field_70170_p.func_72933_a(new Vec3d(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v), new Vec3d(x, y, z)) == null;
        return water && seen;
    }

    public boolean isClearPathWaterBelow(double x, double y, double z) {
        boolean water = this.field_70170_p.func_180495_p(new BlockPos((int)x, (int)y, (int)z)).func_185904_a() == Material.field_151586_h;
        boolean waterBelow = this.field_70170_p.func_180495_p(new BlockPos((int)x, (int)y - 1, (int)z)).func_185904_a() == Material.field_151586_h;
        boolean seen = this.field_70170_p.func_72933_a(new Vec3d(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v), new Vec3d(x, y, z)) == null;
        return (water || waterBelow) && seen;
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        float delta;
        float f6;
        if (this.func_70090_H()) {
            double posY = this.field_70163_u;
            this.func_191958_b(strafe, vertical, forward, 0.04f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.84;
            this.field_70181_x *= 0.84;
            this.field_70179_y *= 0.84;
            if (this.field_70123_F && this.func_70038_c(this.field_70159_w, this.field_70181_x + (double)0.6f - this.field_70163_u + posY, this.field_70179_y)) {
                this.field_70181_x = 0.3f;
            }
        } else if (this.func_180799_ab()) {
            double posY = this.field_70163_u;
            this.func_191958_b(strafe, vertical, forward, 0.02f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
            if (!this.func_189652_ae()) {
                this.field_70181_x -= 0.02;
            }
            if (this.field_70123_F && this.func_70038_c(this.field_70159_w, this.field_70181_x + (double)0.6f - this.field_70163_u + posY, this.field_70179_y)) {
                this.field_70181_x = 0.3f;
            }
        } else {
            float f2 = 0.91f;
            BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185345_c((double)this.field_70165_t, (double)(this.func_174813_aQ().field_72338_b - 1.0), (double)this.field_70161_v);
            if (this.field_70122_E) {
                IBlockState underState = this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos);
                f2 = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, (BlockPos)blockpos$pooledmutableblockpos, (Entity)this) * 0.91f;
            }
            float f3 = 0.16277136f / (f2 * f2 * f2);
            float friction = this.field_70122_E ? this.func_70689_ay() * f3 : this.field_70747_aH;
            this.func_191958_b(strafe, vertical, forward, friction);
            f2 = 0.91f;
            if (this.field_70122_E) {
                IBlockState underState = this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos);
                f2 = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, (BlockPos)blockpos$pooledmutableblockpos, (Entity)this) * 0.91f;
                f2 *= 0.1f;
            }
            if (this.func_70617_f_()) {
                this.field_70159_w = MathHelper.func_151237_a((double)this.field_70159_w, (double)-0.15f, (double)0.15f);
                this.field_70179_y = MathHelper.func_151237_a((double)this.field_70179_y, (double)-0.15f, (double)0.15f);
                this.field_70143_R = 0.0f;
                if (this.field_70181_x < -0.15) {
                    this.field_70181_x = -0.15;
                }
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            if (this.field_70123_F && this.func_70617_f_()) {
                this.field_70181_x = 0.2;
            }
            if (this.func_70644_a(MobEffects.field_188424_y)) {
                this.field_70181_x += (0.05 * (double)(this.func_70660_b(MobEffects.field_188424_y).func_76458_c() + 1) - this.field_70181_x) * 0.2;
            } else {
                blockpos$pooledmutableblockpos.func_189532_c(this.field_70165_t, 0.0, this.field_70161_v);
                if (!this.field_70170_p.field_72995_K || this.field_70170_p.func_175667_e((BlockPos)blockpos$pooledmutableblockpos) && this.field_70170_p.func_175726_f((BlockPos)blockpos$pooledmutableblockpos).func_177410_o()) {
                    if (!this.func_189652_ae()) {
                        this.field_70181_x -= 0.08;
                    }
                } else {
                    this.field_70181_x = this.field_70163_u > 0.0 ? -0.1 : 0.0;
                }
            }
            this.field_70181_x *= (double)0.98f;
            this.field_70159_w *= (double)(f2 *= 0.4f);
            this.field_70179_y *= (double)f2;
            blockpos$pooledmutableblockpos.func_185344_t();
        }
        this.field_184618_aE = this.field_70721_aZ;
        double x = this.field_70165_t - this.field_70169_q;
        double y = this.field_70163_u - this.field_70167_r;
        double z = this.field_70161_v - this.field_70166_s;
        if (!this.field_70170_p.field_72995_K) {
            x = this.dPosX;
            y = this.dPosY;
            z = this.dPosZ;
        }
        if ((f6 = MathHelper.func_76133_a((double)(x * x + y * y + z * z)) * 4.0f) > 1.0f) {
            f6 = 1.0f;
        }
        this.field_70721_aZ = !this.func_70090_H() && !this.field_70122_E ? (this.field_70721_aZ *= 0.4f) : ((delta = f6 - this.field_70721_aZ) >= 0.0f ? (this.field_70721_aZ += delta * 0.4f) : (this.field_70721_aZ += delta * 0.1f));
        this.field_184619_aG += this.field_70721_aZ;
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
        double xx = this.field_70159_w;
        double yy = this.field_70181_x;
        double zz = this.field_70179_y;
        super.func_70653_a(entityIn, strength, xRatio, zRatio);
        if (this.func_70090_H()) {
            this.field_70159_w += (xx - this.field_70159_w) * 0.5;
            this.field_70181_x += (yy - this.field_70181_x) * (double)0.8f;
            this.field_70179_y += (zz - this.field_70179_y) * 0.5;
        } else {
            this.field_70181_x += (yy - this.field_70181_x) * (double)0.4f;
        }
    }

    public boolean func_70601_bi() {
        return true;
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this);
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        if (forSpawnCount && this.func_104002_bU()) {
            return false;
        }
        return type == EnumCreatureType.WATER_CREATURE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
    }

    protected ResourceLocation func_184647_J() {
        return AbyssalDepths.prefix("entities/" + EntityList.func_191301_a((Entity)this).func_110623_a());
    }
}

