/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.abyssaldepths.entity;

import chumbanotz.abyssaldepths.entity.ComplexCreature;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class BodyPart
extends Entity {
    private static final DataParameter<Float> SCALE = EntityDataManager.func_187226_a(BodyPart.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> BASE_ENTITY_ID = EntityDataManager.func_187226_a(BodyPart.class, (DataSerializer)DataSerializers.field_187192_b);
    protected boolean spawned;
    private int inWaterTick;
    private boolean wasInWater;
    private ComplexCreature base;

    public BodyPart(World world) {
        super(world);
        this.spawned = true;
        this.field_70156_m = true;
        this.field_70158_ak = true;
    }

    public BodyPart(ComplexCreature creature, float scale) {
        super(creature.field_70170_p);
        this.base = creature;
        this.spawned = false;
        this.setScale(scale);
        this.func_70105_a(scale, scale);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(SCALE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(BASE_ENTITY_ID, (Object)-1);
    }

    public float getScale() {
        return ((Float)this.field_70180_af.func_187225_a(SCALE)).floatValue();
    }

    private void setScale(float scale) {
        this.field_70180_af.func_187227_b(SCALE, (Object)Float.valueOf(scale));
    }

    public int getBaseId() {
        return (Integer)this.field_70180_af.func_187225_a(BASE_ENTITY_ID);
    }

    private void setDataBase(ComplexCreature base) {
        this.field_70180_af.func_187227_b(BASE_ENTITY_ID, (Object)base.func_145782_y());
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (SCALE.equals(key)) {
            this.func_70105_a(this.getScale(), this.getScale());
        }
    }

    private boolean compareDataSize() {
        return this.field_70130_N == this.getScale();
    }

    public ComplexCreature getBase() {
        return this.base;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return this.base.getPickedResult(target);
    }

    public void func_70071_h_() {
        boolean wasInWater = this.field_70170_p.func_180495_p(new BlockPos((int)this.field_70165_t, (int)this.func_174813_aQ().field_72338_b, (int)this.field_70161_v)).func_185904_a() == Material.field_151586_h;
        super.func_70071_h_();
        if (!this.compareDataSize()) {
            float w = this.getScale();
            this.func_70105_a(w, w);
        }
        int baseId = this.getBaseId();
        if (!this.field_70170_p.field_72995_K) {
            if (this.base != null && baseId == -1) {
                this.setDataBase(this.base);
            }
        } else if (this.base == null && baseId != -1) {
            this.base = (ComplexCreature)this.field_70170_p.func_73045_a(baseId);
        }
        if (this.base != null && this.base.field_70128_L) {
            this.func_70106_y();
        }
        this.collideWithNearbyEntities();
        --this.inWaterTick;
        float scale = this.getScale();
        if (this.field_70170_p.func_180495_p(new BlockPos((int)this.field_70165_t, (int)this.func_174813_aQ().field_72338_b, (int)this.field_70161_v)).func_185904_a() == Material.field_151586_h) {
            this.inWaterTick = 20;
            if (!this.wasInWater) {
                for (int i = 0; i < 12; ++i) {
                    float x = (scale * 0.4f + this.field_70146_Z.nextFloat() * 0.6f) * (float)(this.field_70146_Z.nextBoolean() ? 1 : -1);
                    float z = (scale * 0.4f + this.field_70146_Z.nextFloat() * 0.6f) * (float)(this.field_70146_Z.nextBoolean() ? 1 : -1);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + (double)x, this.field_70163_u + 0.5 + 0.5 * (double)scale * (double)this.field_70146_Z.nextFloat(), this.field_70161_v + (double)z, (double)(x * 0.1f), (double)(0.1f + 0.3f * scale * this.field_70146_Z.nextFloat()), (double)(z * 0.1f), new int[]{Block.func_149682_b((Block)Blocks.field_150355_j)});
                }
            }
        } else if (this.inWaterTick > 0) {
            for (int i = 0; i < 4; ++i) {
                float x = scale * 1.2f * (this.field_70146_Z.nextFloat() - 0.5f);
                float y = scale * 0.4f * this.field_70146_Z.nextFloat();
                float z = scale * 1.2f * (this.field_70146_Z.nextFloat() - 0.5f);
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_SPLASH, this.field_70165_t + (double)x, this.func_174813_aQ().field_72338_b + (double)y, this.field_70161_v + (double)z, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        this.wasInWater = wasInWater;
    }

    private void collideWithNearbyEntities() {
        if (this.base == null) {
            return;
        }
        for (Entity entity : this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(0.2, 0.0, 0.2))) {
            if (entity == this.base || entity instanceof BodyPart && ((BodyPart)entity).base == this.base) continue;
            if (entity.func_70104_M()) {
                entity.func_70108_f((Entity)this);
            }
            this.base.collideWithEntity(this, entity);
        }
    }

    public void func_70108_f(Entity entity) {
        double d1;
        double d0;
        double d2;
        if (!this.func_184223_x(entity) && (d2 = MathHelper.func_76132_a((double)(d0 = entity.field_70165_t - this.field_70165_t), (double)(d1 = entity.field_70161_v - this.field_70161_v))) >= (double)0.01f) {
            d2 = MathHelper.func_76133_a((double)d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            entity.func_70024_g(d0 *= (double)(1.0f - this.field_70144_Y), 0.0, d1 *= (double)(1.0f - this.field_70144_Y));
        }
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        return this.base.func_184230_a(player, hand);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return this.base != null && this.base.func_70097_a(source, amount);
    }

    public boolean func_70028_i(Entity entityIn) {
        return super.func_70028_i(entityIn) || entityIn == this.base || entityIn instanceof BodyPart && ((BodyPart)entityIn).base == this.base;
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }
}

