/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.abyssaldepths.entity;

import chumbanotz.abyssaldepths.entity.AquaticCreature;
import chumbanotz.abyssaldepths.entity.BodyPart;
import chumbanotz.abyssaldepths.entity.fish.Fish;
import chumbanotz.abyssaldepths.util.Bone;
import chumbanotz.abyssaldepths.util.Euler;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class ComplexCreature
extends AquaticCreature {
    private static final DataParameter<Integer> TICKS_EXISTED = EntityDataManager.func_187226_a(ComplexCreature.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> LIMB_SWING = EntityDataManager.func_187226_a(ComplexCreature.class, (DataSerializer)DataSerializers.field_187193_c);
    protected int moveTick;

    public ComplexCreature(World world) {
        super(world);
        this.field_70158_ak = true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TICKS_EXISTED, (Object)0);
        this.field_70180_af.func_187214_a(LIMB_SWING, (Object)Float.valueOf(0.0f));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70090_H() {
        return this.field_70170_p.func_72918_a(this.func_174813_aQ().func_72314_b(0.0, -0.3, 0.0), Material.field_151586_h, (Entity)this);
    }

    public void func_70071_h_() {
        double prevX = this.field_70165_t;
        double prevY = this.field_70163_u;
        double prevZ = this.field_70161_v;
        super.func_70071_h_();
        BodyPart[] partList = this.getPartList();
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < partList.length; ++i) {
                if (partList[i].spawned) continue;
                this.field_70170_p.func_72838_d((Entity)partList[i]);
                partList[i].spawned = true;
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(TICKS_EXISTED, (Object)this.field_70173_aa);
            this.field_70180_af.func_187227_b(LIMB_SWING, (Object)Float.valueOf(this.field_184619_aG));
        } else {
            this.field_70173_aa = (Integer)this.field_70180_af.func_187225_a(TICKS_EXISTED);
            if (this.dPosX * this.dPosX + this.dPosY * this.dPosY + this.dPosZ * this.dPosZ < 1.6000001778593287E-5 || this.field_70173_aa % 100 == 0) {
                this.field_184619_aG = ((Float)this.field_70180_af.func_187225_a(LIMB_SWING)).floatValue();
            }
        }
        this.dPosX = this.field_70165_t - prevX;
        this.dPosY = this.field_70163_u - prevY;
        this.dPosZ = this.field_70161_v - prevZ;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.func_82168_bl();
        if (!this.func_70090_H()) {
            if (this.field_70122_E) {
                this.currentPitch *= 0.6f;
            } else {
                double d = MathHelper.func_76133_a((double)(this.dPosX * this.dPosX + this.dPosZ * this.dPosZ));
                float pitch = -((float)Math.atan2(this.dPosY, d)) * 57.295776f;
                this.currentPitch += (pitch - this.currentPitch) * 0.25f;
            }
        } else {
            this.currentPitch += (this.field_70125_A - this.currentPitch) * 0.1f;
        }
        this.updateParts();
    }

    @Override
    protected void moveCreature() {
        double targetSpeed = 0.0;
        EntityLivingBase target = this.func_70638_az();
        if (target != null) {
            ++this.moveTick;
            targetSpeed = this.moveByTarget(target);
        } else if (this.targetVec != null) {
            ++this.moveTick;
            targetSpeed = this.moveByPathing();
        } else if (this.findNewPath() && this.field_70173_aa > 20) {
            this.setRandomPath();
        }
        Vec3d vec = this.func_70040_Z();
        this.netSpeed += (targetSpeed - this.netSpeed) * 0.1;
        float dYaw = Math.abs(this.currentYaw - this.prevCurrentYaw);
        if (dYaw > 0.02f && this.netSpeed > targetSpeed * 0.6) {
            this.netSpeed += (targetSpeed * 0.6 - this.netSpeed) * 0.4;
        }
        if (this.onLand()) {
            this.netSpeed = 0.0;
            if (this.targetVec != null && this.field_70146_Z.nextInt(12) == 0) {
                this.field_70159_w = vec.field_72450_a * 0.25;
                this.field_70181_x = 0.2f;
                this.field_70179_y = vec.field_72449_c * 0.25;
            }
        }
        this.func_70091_d(MoverType.SELF, vec.field_72450_a * this.netSpeed, vec.field_72448_b * this.netSpeed, vec.field_72449_c * this.netSpeed);
    }

    public double moveByTarget(EntityLivingBase target) {
        return 0.0;
    }

    public double moveByPathing() {
        this.func_70671_ap().func_75650_a(this.targetVec.field_72450_a, this.targetVec.field_72448_b, this.targetVec.field_72449_c, 3.0f, 85.0f);
        if (this.field_70123_F && this.field_70181_x < (double)0.2f) {
            this.field_70181_x = 0.2f;
        }
        if (this.targetVec.func_72438_d(this.func_174791_d()) < 3.0 || this.moveTick > 120) {
            this.moveTick = 0;
            if (this.field_70146_Z.nextInt(5) < 3) {
                this.setRandomPath();
            } else {
                this.targetVec = null;
            }
        }
        return this.getMovementSpeed();
    }

    public final double getMovementSpeed() {
        return this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 1.8;
    }

    public abstract BodyPart[] getPartList();

    public abstract Bone getBaseBone();

    public abstract Bone[] getBoneList();

    protected void updateParts() {
        this.getBaseBone().setRotation(this.currentPitch, this.field_70177_z, 0.0f);
        this.resetBoneAngles();
        this.updatePitchRotations(1.0f);
        this.updateYawRotations(1.0f);
        this.setBodyPartPositions();
    }

    public void updatePitchRotations(float partialTick) {
    }

    public void updateYawRotations(float partialTick) {
    }

    private void setBodyPartPositions() {
        BodyPart[] partList = this.getPartList();
        Bone baseBone = this.getBaseBone();
        Bone[] boneList = this.getBoneList();
        Vec3d vec = boneList[0].getRotation().getRotated(baseBone.getRotation()).rotateVector(boneList[0].getLength() / 2.0f);
        partList[0].func_70012_b(this.field_70165_t + vec.field_72450_a, this.field_70163_u + vec.field_72448_b, this.field_70161_v + vec.field_72449_c, this.field_70177_z, this.field_70125_A);
        vec = baseBone.getRotatedVector();
        Euler angle = baseBone.getRotation();
        for (int i = 1; i < partList.length; ++i) {
            angle = angle.getRotated(boneList[i].getRotation());
            float length = boneList[i].getLength();
            Vec3d midVec = angle.rotateVector(length / 2.0f);
            partList[i].func_70012_b(this.field_70165_t + vec.field_72450_a + midVec.field_72450_a, this.field_70163_u + vec.field_72448_b + midVec.field_72448_b, this.field_70161_v + vec.field_72449_c + midVec.field_72449_c, this.field_70177_z, this.field_70125_A);
            Vec3d target = angle.rotateVector(length);
            vec = vec.func_72441_c(target.field_72450_a, target.field_72448_b, target.field_72449_c);
        }
    }

    public void resetBoneAngles() {
        for (Bone bone : this.getBoneList()) {
            bone.setRotation(0.0f, 0.0f, 0.0f);
        }
    }

    public void collideWithEntity(BodyPart part, Entity entity) {
    }

    public void eatOrDamageEntity(Entity target, float dmg) {
        EntityLiving living;
        if (target instanceof EntityLiving && target instanceof Fish && (living = (EntityLiving)target).func_110143_aJ() - dmg < 0.0f) {
            this.func_184609_a(EnumHand.MAIN_HAND);
            living.func_70106_y();
        }
        if (target.func_70089_S()) {
            target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), dmg);
        }
    }

    public void eatOrDamageEntity(BodyPart part, Entity target, float dmg) {
        EntityLiving living;
        if (target instanceof EntityLiving && target.field_70130_N < this.field_70130_N + 0.5f && target.field_70131_O < this.field_70131_O + 0.5f && (living = (EntityLiving)target).func_110143_aJ() - dmg < 0.0f && (part == this.getPartList()[0] || part == this.getPartList()[1])) {
            this.func_184609_a(EnumHand.MAIN_HAND);
            living.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 0.0f);
            living.func_70106_y();
        }
        if (target.func_70089_S() && target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), dmg)) {
            this.func_184609_a(EnumHand.MAIN_HAND);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if ("arrow".equals(source.func_76355_l())) {
            amount *= 0.25f;
        }
        return super.func_70097_a(source, amount);
    }
}

