/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.abyssaldepths.entity;

import chumbanotz.abyssaldepths.entity.WaterCreature;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class School {
    private int maxSchoolSize = 10;
    private float radius = 8.0f;
    private boolean openToCombine;
    private WaterCreature leader;
    private final World world;
    private final List<WaterCreature> creatureList = new ArrayList<WaterCreature>();

    public School(WaterCreature creature) {
        this.openToCombine = creature.field_70170_p.field_73012_v.nextInt(4) == 0;
        this.world = creature.field_70170_p;
        this.setLeader(creature);
    }

    public void setLeader(WaterCreature creature) {
        this.leader = creature;
        if (!this.creatureList.contains((Object)this.leader)) {
            this.addCreature(this.leader);
        }
    }

    public void chooseRandomLeader() {
        this.setLeader(this.creatureList.get(this.world.field_73012_v.nextInt(this.creatureList.size())));
    }

    public WaterCreature getLeader() {
        return this.leader;
    }

    public void addCreature(WaterCreature creature) {
        if (!this.creatureList.contains((Object)creature)) {
            this.creatureList.add(creature);
        }
    }

    public boolean ridinSolo() {
        return this.creatureList.size() == 1;
    }

    public boolean containsCreature(WaterCreature creature) {
        return this.creatureList.contains((Object)creature);
    }

    public void removeCreature(WaterCreature creature) {
        this.creatureList.remove((Object)creature);
        if (this.creatureList.size() > 1 && this.getLeader() == creature) {
            this.chooseRandomLeader();
        }
        creature.initSchool();
        creature.school.setOpenToCombine(false);
        creature.followEntity = null;
        creature.targetVec = null;
    }

    public void setMaxSize(int maxSchoolSize) {
        this.maxSchoolSize = maxSchoolSize;
    }

    public int getMaxSize() {
        return this.maxSchoolSize;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setOpenToCombine(boolean openToCombine) {
        this.openToCombine = openToCombine;
    }

    public boolean getOpenToCombine() {
        return this.openToCombine;
    }

    public void updateSchool() {
        int i;
        boolean combine = this.getOpenToCombine();
        if (!combine && this.world.field_73012_v.nextInt(1500) == 0) {
            this.setOpenToCombine(true);
        } else if (combine && this.world.field_73012_v.nextInt(1800) == 0) {
            this.setOpenToCombine(false);
        }
        if (this.getOpenToCombine()) {
            List list = this.world.func_72872_a(WaterCreature.class, this.getLeader().func_174813_aQ().func_72314_b(16.0, 12.0, 16.0));
            for (int i2 = 0; i2 < list.size(); ++i2) {
                WaterCreature creature = (WaterCreature)((Object)list.get(i2));
                if (this.containsCreature(creature) || creature.school == null || !creature.canCombineWith(this)) continue;
                int netSize = this.creatureList.size() + creature.school.creatureList.size();
                if (!creature.school.getOpenToCombine() || !((Object)((Object)creature)).getClass().equals(((Object)((Object)this.getLeader())).getClass()) || netSize > this.getMaxSize() || netSize > creature.school.getMaxSize()) continue;
                School.combineSchools(this, creature.school);
            }
        }
        boolean nearLeader = false;
        List leaderList = this.world.func_72872_a(WaterCreature.class, this.leader.func_174813_aQ().func_186662_g(3.0));
        for (i = 0; i < leaderList.size(); ++i) {
            WaterCreature creature = (WaterCreature)((Object)leaderList.get(i));
            if (creature == this.leader || !this.containsCreature(creature)) continue;
            nearLeader = true;
            break;
        }
        for (i = 0; i < this.creatureList.size(); ++i) {
            WaterCreature creature = this.creatureList.get(i);
            if (creature.func_70089_S() && creature.func_70090_H() && creature.func_70068_e((Entity)this.leader) <= 1024.0 && creature.func_184187_bx() == null) {
                if (creature == this.leader) continue;
                if (creature.func_70068_e((Entity)this.leader) <= (double)(this.radius * this.radius) && nearLeader) {
                    double dy;
                    List list = this.world.func_72872_a(WaterCreature.class, creature.func_174813_aQ().func_186662_g(16.0));
                    WaterCreature closestEntity = null;
                    double distSq = 1024.0;
                    boolean hasNearby = false;
                    for (int j = 0; j < list.size(); ++j) {
                        float w;
                        WaterCreature thing = (WaterCreature)((Object)list.get(j));
                        if (creature == thing || !this.containsCreature(thing)) continue;
                        dy = creature.func_70068_e((Entity)thing);
                        if (dy < (double)((w = (creature.field_70130_N + thing.field_70130_N) * 0.5f + 1.0f) * w)) {
                            hasNearby = true;
                            break;
                        }
                        if (!(dy < distSq * distSq)) continue;
                        closestEntity = thing;
                        distSq = dy;
                    }
                    if (!hasNearby && closestEntity != null) {
                        creature.followEntity = closestEntity;
                        creature.targetVec = null;
                        continue;
                    }
                    creature.followEntity = null;
                    if (this.leader.targetVec != null) {
                        if (creature.targetVec != null && this.world.field_73012_v.nextInt(10) != 0) continue;
                        double dx = this.leader.targetVec.field_72450_a - this.leader.field_70165_t + (double)((this.world.field_73012_v.nextFloat() - 0.5f) * 1.1f);
                        dy = this.leader.targetVec.field_72448_b - this.leader.field_70163_u + (double)((this.world.field_73012_v.nextFloat() - 0.5f) * 1.2f);
                        double dz = this.leader.targetVec.field_72449_c - this.leader.field_70161_v + (double)((this.world.field_73012_v.nextFloat() - 0.5f) * 1.1f);
                        creature.targetVec = new Vec3d(creature.field_70165_t + dx, creature.field_70163_u + dy, creature.field_70161_v + dz);
                        continue;
                    }
                    creature.targetVec = null;
                    Vec3d vec = this.leader.func_70040_Z();
                    creature.func_70671_ap().func_75650_a(creature.field_70165_t + vec.field_72450_a, creature.field_70163_u + vec.field_72448_b, creature.field_70161_v + vec.field_72449_c, 6.0f, 85.0f);
                    continue;
                }
                creature.followEntity = this.leader;
                creature.targetVec = null;
                continue;
            }
            this.removeCreature(creature);
            --i;
        }
    }

    public static School combineSchools(School school1, School school2) {
        if (school2.creatureList.size() > school1.creatureList.size()) {
            school1.setLeader(school2.getLeader());
        }
        if (school2.getMaxSize() < school1.getMaxSize()) {
            school1.setMaxSize(school2.getMaxSize());
        }
        if (school2.getRadius() < school1.getRadius()) {
            school1.setRadius(school2.getRadius());
        }
        school1.creatureList.addAll(school2.creatureList);
        for (WaterCreature creature : school2.creatureList) {
            creature.school = school1;
        }
        return school1;
    }
}

