/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.abyssaldepths.entity;

import chumbanotz.abyssaldepths.entity.BodyPart;
import chumbanotz.abyssaldepths.entity.ComplexCreature;
import chumbanotz.abyssaldepths.entity.ai.EntityAIHuntUnderwater;
import chumbanotz.abyssaldepths.util.Bone;
import chumbanotz.abyssaldepths.util.Euler;
import com.google.common.base.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class SeaSerpent
extends ComplexCreature
implements IMob {
    private static final Predicate<EntityLivingBase> IN_BOAT = target -> target.func_184187_bx() instanceof EntityBoat && target.func_184187_bx().func_70090_H();
    private static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(SeaSerpent.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Byte> HUNGER = EntityDataManager.func_187226_a(SeaSerpent.class, (DataSerializer)DataSerializers.field_187191_a);
    public static final int[] PART_HEIGHT = new int[]{8, 14, 12, 10, 8, 6, 5, 4};
    public static final int[] PART_LENGTH = new int[]{18, 24, 24, 20, 14, 16, 18, 22};
    private final BodyPart[] partList = new BodyPart[8];
    private final Bone baseBone = new Bone();
    private final Bone[] boneList = new Bone[8];
    private final Euler[] targetAngles = new Euler[8];
    private int strikeTick;
    private boolean strikeStopped;
    private Vec3d oldVec;

    public SeaSerpent(World world) {
        super(world);
        int i;
        this.baseBone.setLength(0.0f);
        this.boneList[0] = new Bone(this.baseBone);
        this.boneList[0].setLength((float)PART_LENGTH[0] / 16.0f);
        for (i = 1; i < this.boneList.length; ++i) {
            this.boneList[i] = new Bone(i == 1 ? this.baseBone : this.boneList[i - 1]);
            this.boneList[i].setLength((float)(-PART_LENGTH[i]) / 16.0f);
        }
        for (i = 0; i < this.partList.length; ++i) {
            this.targetAngles[i] = new Euler();
            this.partList[i] = new BodyPart(this, (float)PART_LENGTH[i] / 16.0f);
        }
        this.updateParts();
        this.func_70105_a(1.1f, 1.1f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACKING, (Object)false);
        this.field_70180_af.func_187214_a(HUNGER, (Object)((byte)this.field_70146_Z.nextInt(16)));
    }

    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new AIHuntPrey(this, IN_BOAT));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new AIHuntPrey(this, (Predicate<? super EntityLivingBase>)((Predicate)Entity::func_70090_H)));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(90.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(48.0);
    }

    public boolean isAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACKING);
    }

    private void setAttacking(boolean attacking) {
        this.field_70180_af.func_187227_b(ATTACKING, (Object)attacking);
    }

    public int getHunger() {
        return ((Byte)this.field_70180_af.func_187225_a(HUNGER)).byteValue();
    }

    private void setHunger(int hunger) {
        this.field_70180_af.func_187227_b(HUNGER, (Object)((byte)hunger));
    }

    public int func_70641_bl() {
        return 2;
    }

    @Override
    protected int func_70693_a(EntityPlayer player) {
        return 25;
    }

    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public BodyPart[] getPartList() {
        return this.partList;
    }

    @Override
    public Bone getBaseBone() {
        return this.baseBone;
    }

    @Override
    public Bone[] getBoneList() {
        return this.boneList;
    }

    @Override
    public void updatePitchRotations(float partialTick) {
        Euler euler;
        for (int i = this.boneList.length - 1; i > 1; --i) {
            if (partialTick == 1.0f) {
                euler = this.boneList[i].getRotation();
                this.targetAngles[i].x = this.targetAngles[i - 1].x;
                euler.x += this.targetAngles[i].x;
                continue;
            }
            euler = this.boneList[i].getRotation();
            euler.x += this.targetAngles[i].x + (this.targetAngles[i - 1].x - this.targetAngles[i].x) * partialTick;
        }
        this.targetAngles[1].x = -(this.currentPitch - this.prevCurrentPitch) * 2.4f;
        float moveScale = this.field_184618_aE + (this.field_70721_aZ - this.field_184618_aE) * partialTick;
        float moveTick = this.field_184619_aG - this.field_70721_aZ * (1.0f - partialTick);
        if (moveScale > 1.0f) {
            moveScale = 1.0f;
        }
        for (int i = 0; i < this.boneList.length; ++i) {
            float breatheAnim = MathHelper.func_76126_a((float)(0.1f * ((float)this.field_70173_aa + partialTick - (float)i * 6.0f)));
            float moveAnim = MathHelper.func_76126_a((float)(0.2f * (moveTick - (float)i * 2.0f))) * moveScale;
            euler = this.boneList[i].getRotation();
            euler.x += breatheAnim * 1.1f;
            euler = this.boneList[i].getRotation();
            euler.x += moveAnim * 6.0f;
            if (i != 0 || partialTick != 1.0f) continue;
            Euler angle = new Euler(this.currentPitch + 90.0f, this.field_70177_z, 0.0f);
            Vec3d vec = angle.rotateVector(moveAnim * 0.03f);
            this.field_70159_w += vec.field_72450_a;
            this.field_70181_x += vec.field_72448_b;
            this.field_70179_y += vec.field_72449_c;
        }
    }

    @Override
    public void updateYawRotations(float partialTick) {
        for (int i = this.boneList.length - 1; i > 1; --i) {
            Euler euler;
            if (partialTick == 1.0f) {
                euler = this.boneList[i].getRotation();
                this.targetAngles[i].y = this.targetAngles[i - 1].y;
                euler.y += this.targetAngles[i].y;
                continue;
            }
            euler = this.boneList[i].getRotation();
            euler.y += this.targetAngles[i].y + (this.targetAngles[i - 1].y - this.targetAngles[i].y) * partialTick;
        }
        this.targetAngles[1].y = -(this.currentYaw - this.prevCurrentYaw) * 2.5f;
        this.targetAngles[0].y = (this.currentYaw - this.prevCurrentYaw) * 1.5f;
    }

    private double getStrikeRange() {
        return 6.0;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.getHunger() <= 0) {
                if (this.field_70173_aa % 40 == 0) {
                    this.func_70691_i(1.0f);
                }
                if (this.field_70146_Z.nextInt(3600) == 0) {
                    this.setHunger(14 + this.field_70146_Z.nextInt(8));
                }
            }
            this.strikeTick = Math.max(0, this.strikeTick - 1);
        }
    }

    @Override
    public double moveByTarget(EntityLivingBase target) {
        double targetSpeed = this.getMovementSpeed() * 1.06;
        double dSq = this.func_70068_e((Entity)target);
        double range = 32.0;
        double strikeRange = this.getStrikeRange();
        if (this.isAttacking()) {
            double dSq1;
            if (dSq < strikeRange * strikeRange) {
                if (this.targetVec == null) {
                    this.targetVec = new Vec3d(target.field_70165_t - this.field_70165_t, target.field_70163_u - this.field_70163_u, target.field_70161_v - this.field_70161_v);
                    this.targetVec = this.targetVec.func_72432_b();
                }
                if (this.oldVec == null) {
                    this.oldVec = this.func_174791_d();
                }
                if (this.func_70090_H()) {
                    this.func_70671_ap().func_75651_a((Entity)target, 15.0f, 85.0f);
                    float scale = 9.0f;
                    this.field_70159_w += (this.targetVec.field_72450_a * (targetSpeed *= (double)0.3f) * (double)scale - this.field_70159_w) * 0.6;
                    this.field_70181_x += (this.targetVec.field_72448_b * targetSpeed * (double)scale - this.field_70181_x) * 0.6;
                    this.field_70179_y += (this.targetVec.field_72449_c * targetSpeed * (double)scale - this.field_70179_y) * 0.6;
                }
            } else if (!this.strikeStopped) {
                this.func_70671_ap().func_75651_a((Entity)target, 8.0f, 85.0f);
                this.targetVec = new Vec3d(target.field_70165_t - this.field_70165_t, target.field_70163_u - this.field_70163_u, target.field_70161_v - this.field_70161_v);
                this.targetVec = this.targetVec.func_72432_b();
                this.oldVec = this.func_174791_d();
            }
            if ((dSq1 = this.func_70092_e(this.oldVec.field_72450_a, this.oldVec.field_72448_b, this.oldVec.field_72449_c)) > strikeRange * strikeRange || !this.func_70090_H() && !this.field_70122_E || this.strikeStopped) {
                this.setAttacking(false);
                this.strikeStopped = false;
                this.strikeTick = 60 + this.field_70146_Z.nextInt(20);
                this.targetVec = null;
                this.oldVec = null;
            }
        } else if (this.targetVec != null) {
            this.func_70671_ap().func_75650_a(this.targetVec.field_72450_a, this.targetVec.field_72448_b, this.targetVec.field_72449_c, 3.0f, 85.0f);
            if (this.field_70123_F && this.field_70181_x < (double)0.2f) {
                this.field_70181_x = 0.2f;
            }
            if (dSq > range * range) {
                this.moveTick = 0;
                this.targetVec = null;
            } else if (this.strikeTick <= 0 && dSq > strikeRange * strikeRange && this.field_70146_Z.nextInt(70) == 0) {
                this.setAttacking(true);
                this.moveTick = 0;
                this.targetVec = null;
            }
        } else if (dSq > range * range) {
            this.func_70671_ap().func_75651_a((Entity)target, 10.0f, 85.0f);
        } else {
            targetSpeed = 0.0;
            this.setRandomPathAround(target);
        }
        if (this.targetVec != null && this.targetVec.func_72438_d(this.func_174791_d()) < 3.0 || this.moveTick > 120) {
            this.moveTick = 0;
            this.setRandomPathAround(target);
        }
        return targetSpeed;
    }

    @Override
    public boolean findNewPath() {
        return this.field_70146_Z.nextInt(40) == 0 || this.onLand() && this.field_70146_Z.nextInt(4) == 0;
    }

    @Override
    public boolean setRandomPath() {
        double x = this.field_70165_t + (10.0 + (double)this.field_70146_Z.nextFloat() * 12.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1);
        double y = this.field_70163_u + ((double)this.field_70146_Z.nextFloat() - 0.5) * 12.0;
        double z = this.field_70161_v + (10.0 + (double)this.field_70146_Z.nextFloat() * 12.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1);
        if (this.onLand()) {
            x = this.field_70165_t + (4.0 + (double)this.field_70146_Z.nextFloat() * 16.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1);
            z = this.field_70161_v + (4.0 + (double)this.field_70146_Z.nextFloat() * 16.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1);
        }
        if (this.isClearPath(x, y, z)) {
            this.targetVec = new Vec3d(x, y, z);
            return true;
        }
        return false;
    }

    private boolean setRandomPathAround(EntityLivingBase living) {
        double x = living.field_70165_t + (4.0 + (double)this.field_70146_Z.nextFloat() * 5.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1);
        double y = living.func_174813_aQ().field_72338_b - 5.0 + ((double)this.field_70146_Z.nextFloat() - 0.5) * 20.0;
        double z = living.field_70161_v + (4.0 + (double)this.field_70146_Z.nextFloat() * 5.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1);
        if (this.onLand()) {
            x = this.field_70165_t + (4.0 + (double)this.field_70146_Z.nextFloat() * 16.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1);
            z = this.field_70161_v + (4.0 + (double)this.field_70146_Z.nextFloat() * 16.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1);
        }
        if (this.isClearPathWaterBelow(x, y, z)) {
            this.targetVec = new Vec3d(x, y, z);
            return true;
        }
        return false;
    }

    @Override
    public void collideWithEntity(BodyPart part, Entity entity) {
        double d0;
        double z;
        double y;
        double x;
        EntityLivingBase target = this.func_70638_az();
        float dmg = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        BodyPart[] partList = this.getPartList();
        if (partList != null && part == partList[partList.length - 1] && this.dPosX * this.dPosX + this.dPosY * this.dPosY + this.dPosZ * this.dPosZ > 0.04000000000000001) {
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), dmg * 0.6f);
            x = entity.field_70165_t - this.field_70165_t;
            y = entity.field_70163_u - this.field_70163_u;
            z = entity.field_70161_v - this.field_70161_v;
            d0 = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
            float scale = 0.12f * dmg;
            entity.field_70159_w = x / d0 * (double)scale;
            entity.field_70181_x = y / d0 * (double)scale;
            entity.field_70179_y = z / d0 * (double)scale;
            entity.field_70133_I = true;
        }
        if (this.isAttacking() && target != null && this.func_70068_e((Entity)target) < this.getStrikeRange() * this.getStrikeRange()) {
            if (!this.field_70170_p.field_72995_K && entity == target) {
                this.strikeStopped = true;
            }
            this.eatOrDamageEntity(part, entity, dmg);
            x = entity.field_70165_t - this.field_70165_t;
            y = entity.field_70163_u - this.field_70163_u;
            z = entity.field_70161_v - this.field_70161_v;
            d0 = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
            Vec3d vec = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            vec = vec.func_72432_b();
            float scale = 0.8f;
            entity.field_70159_w = (x / d0 + vec.field_72450_a) * (double)scale;
            entity.field_70181_x = (y / d0 + vec.field_72448_b) * (double)scale;
            entity.field_70179_y = (z / d0 + vec.field_72449_c) * (double)scale;
            entity.field_70133_I = true;
        }
    }

    public void func_70074_a(EntityLivingBase living) {
        int hunger = this.getHunger();
        boolean edible = false;
        if (living instanceof EntityPlayer || living instanceof IAnimals || living instanceof INpc) {
            edible = true;
        }
        if (!this.field_70170_p.field_72995_K && hunger > 0 && edible) {
            this.setHunger(hunger - 1);
        }
    }

    @Override
    public void func_70653_a(Entity entity, float f, double x, double z) {
        if (!this.func_70090_H()) {
            super.func_70653_a(entity, f, x, z);
        }
    }

    public void func_70014_b(NBTTagCompound tagcompound) {
        super.func_70014_b(tagcompound);
        tagcompound.func_74774_a("Hunger", (byte)this.getHunger());
    }

    public void func_70037_a(NBTTagCompound tagcompound) {
        super.func_70037_a(tagcompound);
        this.setHunger(tagcompound.func_74771_c("Hunger"));
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(12) == 0 && this.field_70163_u < 48.0 && super.func_70601_bi();
    }

    protected float func_70599_aP() {
        return 0.8f;
    }

    static class AIHuntPrey
    extends EntityAIHuntUnderwater<EntityLivingBase> {
        public AIHuntPrey(SeaSerpent creature, Predicate<? super EntityLivingBase> targetSelector) {
            super(creature, EntityLivingBase.class, 0, true, false, entity -> !entity.func_70662_br() && !(entity instanceof IMob) && !(entity instanceof EntityGolem) && targetSelector.test(entity));
        }

        @Override
        public boolean func_75250_a() {
            return ((SeaSerpent)this.field_75299_d).getHunger() > 0 && super.func_75250_a();
        }
    }
}

