/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.abyssaldepths.entity;

import chumbanotz.abyssaldepths.entity.AquaticCreature;
import chumbanotz.abyssaldepths.entity.School;
import chumbanotz.abyssaldepths.util.ADGlobal;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class WaterCreature
extends AquaticCreature
implements IAnimals {
    public School school;
    protected double fleeDistance = 10.0;
    protected EntityLivingBase fleeFromEntity;
    protected EntityLivingBase followEntity;
    protected Vec3d fleeLookVec;

    public WaterCreature(World world) {
        super(world);
    }

    public void initSchool() {
        this.school = new School(this);
    }

    public boolean func_70090_H() {
        return this.field_70170_p.func_72918_a(this.func_174813_aQ().func_72314_b(0.0, -0.1, 0.0), Material.field_151586_h, (Entity)this);
    }

    public boolean shouldLeaveSchool() {
        return this.field_70146_Z.nextInt(1800) == 0;
    }

    public boolean canCombineWith(School otherSchool) {
        return true;
    }

    public void func_70071_h_() {
        double prevX = this.field_70165_t;
        double prevY = this.field_70163_u;
        double prevZ = this.field_70161_v;
        int i = this.func_70086_ai();
        super.func_70071_h_();
        this.dPosX = this.field_70165_t - prevX;
        this.dPosY = this.field_70163_u - prevY;
        this.dPosZ = this.field_70161_v - prevZ;
        if (this.func_70089_S() && !this.func_70090_H()) {
            this.func_70050_g(--i);
            if (this.func_70086_ai() == -20) {
                this.func_70050_g(0);
                this.func_70097_a(DamageSource.field_76369_e, 2.0f);
            }
        } else {
            this.func_70050_g(400);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.getTamed() && this.field_70173_aa % 100 == 0) {
                this.func_70691_i(2.0f);
            }
            if (this.school == null) {
                this.initSchool();
            } else {
                WaterCreature leader = this.school.getLeader();
                if (leader == null || leader.field_70128_L) {
                    this.school.chooseRandomLeader();
                }
                if (leader == this) {
                    this.school.updateSchool();
                }
                if (!this.school.ridinSolo() && this.shouldLeaveSchool()) {
                    this.school.removeCreature(this);
                }
            }
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_70090_H()) {
            if (this.field_70122_E) {
                this.currentPitch *= 0.6f;
            } else {
                double d = MathHelper.func_76133_a((double)(this.dPosX * this.dPosX + this.dPosZ * this.dPosZ));
                float pitch = -((float)Math.atan2(this.dPosY, d)) * 57.295776f;
                this.currentPitch += (pitch - this.currentPitch) * 0.4f;
            }
        } else {
            this.currentPitch += (this.field_70125_A - this.currentPitch) * 0.05f;
        }
    }

    @Override
    protected void moveCreature() {
        double targetSpeed = 0.0;
        if (this.fleeFromEntity != null && this.func_184187_bx() == null) {
            if (this.fleeLookVec == null || this.field_70146_Z.nextInt(30) == 0) {
                this.fleeLookVec = new Vec3d(this.field_70165_t - this.fleeFromEntity.field_70165_t, 2.0 + (2.0 + (double)this.field_70146_Z.nextFloat() * 3.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1), this.field_70161_v - this.fleeFromEntity.field_70161_v);
                for (int i = 0; i < 4 && !this.isClearPath(this.field_70165_t + this.fleeLookVec.field_72450_a, this.field_70163_u + this.fleeLookVec.field_72448_b, this.field_70161_v + this.fleeLookVec.field_72449_c); ++i) {
                    this.fleeLookVec = new Vec3d(0.0, 2.0 + (2.0 + (double)this.field_70146_Z.nextFloat() * 3.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1), 0.0);
                }
                this.fleeLookVec = this.fleeLookVec.func_72432_b();
                this.fleeLookVec.func_186678_a(4.0);
                this.fleeLookVec.func_72441_c((double)this.field_70146_Z.nextFloat(), 0.0, (double)this.field_70146_Z.nextFloat());
            }
            this.func_70671_ap().func_75650_a(this.field_70165_t + this.fleeLookVec.field_72450_a, this.field_70163_u + this.fleeLookVec.field_72448_b, this.field_70161_v + this.fleeLookVec.field_72449_c, 10.0f, 85.0f);
            if (this.field_70123_F && this.field_70181_x < (double)0.2f) {
                this.field_70181_x = 0.2f;
            }
            targetSpeed = this.getMovementSpeed() * 2.0;
            if (this.func_70068_e((Entity)this.fleeFromEntity) > this.fleeDistance * this.fleeDistance) {
                this.resetFleeDistance();
                this.fleeFromEntity = null;
                this.fleeLookVec = null;
            }
        } else if (this.followEntity != null) {
            this.func_70671_ap().func_75651_a((Entity)this.followEntity, 6.0f, 85.0f);
            if (this.field_70123_F && this.field_70181_x < (double)0.2f) {
                this.field_70181_x = 0.2f;
            }
            if (this.func_70068_e((Entity)this.followEntity) > 1.0) {
                targetSpeed = this.getMovementSpeed();
            }
        } else if (this.targetVec != null) {
            this.func_70671_ap().func_75650_a(this.targetVec.field_72450_a, this.targetVec.field_72448_b, this.targetVec.field_72449_c, 10.0f, 85.0f);
            if (this.field_70123_F && this.field_70181_x < (double)0.2f) {
                this.field_70181_x = 0.2f;
            }
            targetSpeed = this.getMovementSpeed();
            if (!this.getTamed() && this.func_184187_bx() instanceof EntityPlayer) {
                targetSpeed *= (double)2.2f;
            }
            double closestDist = this.getClosestPathDist();
            if (this.targetVec.func_72436_e(this.func_174791_d()) < closestDist * closestDist) {
                this.targetVec = null;
            }
        }
        if (this.findNewPath() && this.field_70173_aa > 20 && this.school.getLeader() == this) {
            this.setRandomPath();
        }
        if (this.getFlees()) {
            this.fleeFromNearbyPlayers();
        }
        Vec3d vec = this.func_70040_Z();
        this.netSpeed += (targetSpeed - this.netSpeed) * 0.1;
        if (this.onLand()) {
            this.netSpeed = 0.0;
            if (this.targetVec != null && this.field_70146_Z.nextInt(20) == 0) {
                this.field_70159_w = vec.field_72450_a * (double)0.17f;
                this.field_70181_x = 0.2f;
                this.field_70179_y = vec.field_72449_c * (double)0.17f;
            }
        }
        this.func_70091_d(MoverType.SELF, vec.field_72450_a * this.netSpeed, vec.field_72448_b * this.netSpeed, vec.field_72449_c * this.netSpeed);
    }

    public final double getMovementSpeed() {
        return this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * (double)0.8f;
    }

    public void resetFleeDistance() {
        this.fleeDistance = 8.0 + (double)this.field_70146_Z.nextFloat() * 4.0;
    }

    public float getClosestPathDist() {
        return 1.0f;
    }

    public boolean getFlees() {
        return !this.getTamed();
    }

    private void fleeFromNearbyPlayers() {
        EntityPlayer player = this.field_70170_p.func_184136_b((Entity)this, 9.0);
        if (player != null) {
            float angle = (float)Math.atan2(player.field_70161_v - this.field_70161_v, player.field_70165_t - this.field_70165_t) * 57.295776f - 90.0f;
            float delta = Math.abs((angle = ADGlobal.wrapAngleAround(angle, this.field_70177_z)) - this.field_70177_z);
            if (delta < 90.0f || this.func_70068_e((Entity)player) < 4.0 && delta < 120.0f) {
                this.fleeFromEntity = player;
                this.targetVec = null;
            }
        }
    }

    public void func_70645_a(DamageSource source) {
        super.func_70645_a(source);
        if (!this.field_70170_p.field_72995_K && this.school != null) {
            if (!this.school.ridinSolo()) {
                this.school.removeCreature(this);
            }
            if (this.school.getLeader() == this) {
                this.school.chooseRandomLeader();
            }
        }
    }
}

