/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.abyssaldepths.entity.ai;

import chumbanotz.abyssaldepths.entity.AquaticCreature;
import chumbanotz.abyssaldepths.util.ADGlobal;
import net.minecraft.entity.EntityBodyHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.MathHelper;

public class AquaticBodyHelper
extends EntityBodyHelper {
    private final AquaticCreature creature;
    protected float yaw;
    protected float pitch;
    protected float prevYaw;
    protected float prevPitch;
    protected double posX;
    protected double posY;
    protected double posZ;
    private final float pitchOffset;

    public AquaticBodyHelper(AquaticCreature livingIn, float pitchOffset) {
        super((EntityLivingBase)livingIn);
        this.creature = livingIn;
        this.pitchOffset = pitchOffset;
    }

    public void func_75664_a() {
        super.func_75664_a();
        double prevX = this.creature.field_70165_t;
        double prevY = this.creature.field_70163_u;
        double prevZ = this.creature.field_70161_v;
        this.posX = this.creature.field_70165_t - prevX;
        this.posY = this.creature.field_70163_u - prevY;
        this.posZ = this.creature.field_70161_v - prevZ;
        this.creature.field_70761_aq = this.creature.field_70759_as = MathHelper.func_76142_g((float)this.creature.field_70759_as);
        this.creature.field_70177_z = this.creature.field_70759_as;
        if (this.getDifferenceLength() < 1.6000001778593287E-5) {
            this.creature.field_70125_A = 0.0f;
        }
        this.yaw = ADGlobal.wrapAngleAround(this.yaw, this.creature.field_70177_z);
        this.pitch = ADGlobal.wrapAngleAround(this.pitch, this.creature.field_70125_A);
        this.prevYaw = this.yaw;
        this.prevPitch = this.pitch;
        this.prevYaw = ADGlobal.wrapAngleAround(this.prevYaw, this.yaw);
        this.prevPitch = ADGlobal.wrapAngleAround(this.prevPitch, this.pitch);
        this.yaw += (this.creature.field_70177_z - this.yaw) * 0.6f;
        if (!this.creature.func_70090_H()) {
            if (this.creature.field_70122_E) {
                this.pitch *= 0.6f;
            } else {
                double d = MathHelper.func_76133_a((double)(this.posX * this.posX + this.posZ * this.posZ));
                float pitch = -((float)Math.atan2(this.posY, d)) * 57.295776f;
                this.pitch += (pitch - this.pitch) * 0.4f;
            }
        } else {
            this.pitch += (this.creature.field_70125_A - this.pitch) * this.pitchOffset;
        }
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPrevPitch() {
        return this.prevPitch;
    }

    public float getPrevYaw() {
        return this.prevYaw;
    }

    public double getDifferenceLength() {
        return this.posX * this.posX + this.posY * this.posY + this.posZ * this.posZ;
    }

    public float getBodyPitch(float partialTicks) {
        return this.prevPitch + (this.pitch - this.prevPitch) * partialTicks;
    }
}

