/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.abyssaldepths.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Goggles
extends ItemArmor {
    private static final ItemArmor.ArmorMaterial GOGGLES = EnumHelper.addArmorMaterial((String)"abyssaldepthsgoggles", (String)"abyssaldepths:goggles", (int)0, (int[])new int[]{0, 0, 0, 0}, (int)0, (SoundEvent)SoundEvents.field_187719_p, (float)0.0f);
    private static final PotionEffect NIGHT_VISION = new PotionEffect(MobEffects.field_76439_r, Integer.MAX_VALUE, 0, true, false);
    private static final PotionEffect WATER_BREATHING = new PotionEffect(MobEffects.field_76427_o, Integer.MAX_VALUE, 0, true, false);

    public Goggles() {
        super(GOGGLES, 0, EntityEquipmentSlot.HEAD);
        this.func_77656_e(4800);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (player.func_70055_a(Material.field_151586_h)) {
            player.func_70690_d(NIGHT_VISION);
            player.func_70690_d(WATER_BREATHING);
            if (!player.func_184812_l_() && !player.func_175149_v()) {
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
        } else if (Goggles.hasEffects((EntityLivingBase)player)) {
            player.func_184589_d(MobEffects.field_76439_r);
            player.func_184589_d(MobEffects.field_76427_o);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77951_h()) {
            int ticks = stack.func_77958_k() - stack.func_77952_i();
            int minute = ticks / 1200;
            int second = ticks / 20 - minute * 60;
            tooltip.add(TextFormatting.GRAY + "Minutes left: " + minute + ':' + second);
        }
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        return HashMultimap.create();
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "abyssaldepths:textures/models/armor/goggles.png";
    }

    public static boolean hasEffects(EntityLivingBase entityLivingBase) {
        return Goggles.hasEffect(entityLivingBase, MobEffects.field_76439_r) && Goggles.hasEffect(entityLivingBase, MobEffects.field_76427_o);
    }

    private static boolean hasEffect(EntityLivingBase entityLivingBase, Potion potion) {
        return entityLivingBase.func_70644_a(potion) && !entityLivingBase.func_70660_b(potion).func_188418_e();
    }
}

