/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.abyssaldepths.util;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public class ADGlobal {
    public static final float PI = (float)Math.PI;
    public static final float DEG_TO_RAD = (float)Math.PI / 180;
    public static final float RAD_TO_DEG = 57.295776f;

    public static float wrapAngleAround(float angle, float target) {
        while (target - angle >= 180.0f) {
            angle += 360.0f;
        }
        while (target - angle < -180.0f) {
            angle -= 360.0f;
        }
        return angle;
    }

    public static int[] longToInts(long l) {
        int[] arr = new int[]{(int)(l >> 32), (int)l};
        return arr;
    }

    public static long intsToLong(int ... arr) {
        return (long)arr[0] << 32 | (long)arr[1] & 0xFFFFFFFFL;
    }

    public static int rgb(float red, float green, float blue) {
        return ADGlobal.rgb(MathHelper.func_76141_d((float)(red * 255.0f)), MathHelper.func_76141_d((float)(green * 255.0f)), MathHelper.func_76141_d((float)(blue * 255.0f)));
    }

    public static int rgb(int red, int green, int blue) {
        int color = (red << 8) + green;
        color = (color << 8) + blue;
        return color;
    }

    @Nullable
    public static Entity getPointedEntity(EntityLivingBase living, float maxDist) {
        Vec3d eyePos = living.func_174824_e(1.0f);
        Vec3d lookVec = living.func_70040_Z();
        Vec3d reachVec = eyePos.func_72441_c(lookVec.field_72450_a * (double)maxDist, lookVec.field_72448_b * (double)maxDist, lookVec.field_72449_c * (double)maxDist);
        Entity pointedEntity = null;
        double distance = maxDist;
        for (Entity entity : living.field_70170_p.func_72839_b((Entity)living, living.func_174813_aQ().func_72317_d(lookVec.field_72450_a * (double)maxDist, lookVec.field_72448_b * (double)maxDist, lookVec.field_72449_c * (double)maxDist).func_186662_g(1.0))) {
            double d3;
            if (!entity.func_70067_L() || entity.func_70028_i((Entity)living)) continue;
            AxisAlignedBB bbox = entity.func_174813_aQ().func_186662_g((double)entity.func_70111_Y());
            RayTraceResult result = bbox.func_72327_a(eyePos, reachVec);
            if (bbox.func_72318_a(eyePos)) {
                if (!(0.0 < distance) && distance != 0.0) continue;
                pointedEntity = entity;
                distance = 0.0;
                continue;
            }
            if (result == null || !((d3 = eyePos.func_72438_d(result.field_72307_f)) < distance) && distance != 0.0) continue;
            if (entity == living.func_184187_bx() && !entity.canRiderInteract()) {
                if (distance != 0.0) continue;
                pointedEntity = entity;
                continue;
            }
            pointedEntity = entity;
            distance = d3;
        }
        return pointedEntity;
    }
}

