/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.abyssaldepths.client.renderer.entity;

import chumbanotz.abyssaldepths.AbyssalDepths;
import chumbanotz.abyssaldepths.client.renderer.entity.AquaticMobRenderer;
import chumbanotz.abyssaldepths.client.renderer.entity.model.BillfishModel;
import chumbanotz.abyssaldepths.entity.billfish.AbstractBillfishEntity;
import chumbanotz.abyssaldepths.entity.billfish.SwordfishEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.LayeredTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.util.ResourceLocation;

public class BillfishRenderer<T extends AbstractBillfishEntity>
extends AquaticMobRenderer<T, BillfishModel<T>> {
    private static final Map<String, ResourceLocation> LAYERED_LOCATION_CACHE = new HashMap<String, ResourceLocation>();
    private static final ResourceLocation SAILFISH_TEXTURE = AbyssalDepths.getEntityTexture("billfish/sailfish");
    private static final ResourceLocation SWORDFISH_TEXTURE = AbyssalDepths.getEntityTexture("billfish/swordfish");
    private static final ResourceLocation BLUE_SWORDFISH_TEXTURE = AbyssalDepths.getEntityTexture("billfish/blue_swordfish");

    public BillfishRenderer(EntityRendererManager rendermanagerIn) {
        super(rendermanagerIn, new BillfishModel(), 0.0f);
    }

    protected ResourceLocation getBillfishTexture(T billfish) {
        if (billfish instanceof SwordfishEntity) {
            return ((SwordfishEntity)((Object)billfish)).isBlue() ? BLUE_SWORDFISH_TEXTURE : SWORDFISH_TEXTURE;
        }
        return SAILFISH_TEXTURE;
    }

    protected void preRenderCallback(T livingEntity, MatrixStack matrixStackIn, float partialTickTime) {
        if (livingEntity instanceof SwordfishEntity) {
            matrixStackIn.func_227862_a_(1.3f, 1.3f, 1.3f);
        }
    }

    public ResourceLocation getEntityTexture(T entity) {
        if (!((AbstractBillfishEntity)((Object)entity)).hasBanner() && !((AbstractBillfishEntity)((Object)entity)).hasStripes()) {
            return this.getBillfishTexture(entity);
        }
        String textureId = this.getTexture(entity);
        ResourceLocation layered = LAYERED_LOCATION_CACHE.get(textureId);
        if (layered == null) {
            layered = new ResourceLocation(textureId);
            String[] textures = new String[]{"abyssaldepths:" + this.getBillfishTexture(entity).func_110623_a(), null, null};
            if (((AbstractBillfishEntity)((Object)entity)).hasBanner()) {
                textures[1] = "abyssaldepths:textures/entity/billfish/banner.png";
            }
            if (((AbstractBillfishEntity)((Object)entity)).hasStripes()) {
                textures[2] = "abyssaldepths:textures/entity/billfish/stripes.png";
            }
            Minecraft.func_71410_x().func_110434_K().func_229263_a_(layered, (Texture)new LayeredTexture(textures));
            LAYERED_LOCATION_CACHE.put(textureId, layered);
        }
        return layered;
    }

    private String getTexture(T billfishEntity) {
        String path = "abyssaldepths:textures/entity/billfish/" + billfishEntity.getClass().getSimpleName().replace("Entity", "").toLowerCase() + "/";
        if (billfishEntity instanceof SwordfishEntity && ((SwordfishEntity)((Object)billfishEntity)).isBlue()) {
            path = path + "blue";
        }
        if (((AbstractBillfishEntity)((Object)billfishEntity)).hasBanner()) {
            path = path + "banner";
        }
        if (((AbstractBillfishEntity)((Object)billfishEntity)).hasStripes()) {
            path = path + "stripes";
        }
        return path + ".png";
    }
}

