/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.abyssaldepths.client.renderer.entity;

import chumbanotz.abyssaldepths.AbyssalDepths;
import chumbanotz.abyssaldepths.client.renderer.entity.AquaticMobRenderer;
import chumbanotz.abyssaldepths.client.renderer.entity.model.SeahorseModel;
import chumbanotz.abyssaldepths.entity.SeahorseEntity;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.LayeredTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;

public class SeahorseRenderer
extends AquaticMobRenderer<SeahorseEntity, SeahorseModel> {
    private static final Map<String, ResourceLocation> LAYERED_LOCATION_CACHE = Maps.newHashMap();
    private static final ResourceLocation TEXTURE = AbyssalDepths.getEntityTexture("seahorse/seahorse");
    private static final ResourceLocation GRAYSCALE_TEXTURE = AbyssalDepths.getEntityTexture("seahorse/grayscale");
    private static final ResourceLocation EYES_TEXTURE = AbyssalDepths.getEntityTexture("seahorse/eyes");

    public SeahorseRenderer(EntityRendererManager rendermanagerIn) {
        super(rendermanagerIn, new SeahorseModel(), 0.4f);
        this.func_177094_a(new EyesLayer((IEntityRenderer<SeahorseEntity, SeahorseModel>)this));
    }

    public void render(SeahorseEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        if (entityIn.isColorful()) {
            ((SeahorseModel)this.field_77045_g).func_228253_a_(entityIn.getRed(), entityIn.getGreen(), entityIn.getBlue());
        }
        super.func_225623_a_((MobEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        if (entityIn.isColorful()) {
            ((SeahorseModel)this.field_77045_g).func_228253_a_(1.0f, 1.0f, 1.0f);
        }
    }

    public ResourceLocation getEntityTexture(SeahorseEntity entity) {
        if (entity.getMark() == 0) {
            return entity.isColorful() ? GRAYSCALE_TEXTURE : TEXTURE;
        }
        String textureId = this.getTextureId(entity);
        ResourceLocation layered = LAYERED_LOCATION_CACHE.get(textureId);
        if (layered == null) {
            layered = new ResourceLocation(textureId);
            String[] textures = new String[]{entity.isColorful() ? "abyssaldepths:textures/entity/seahorse/grayscale.png" : "abyssaldepths:textures/entity/seahorse/seahorse.png", "abyssaldepths:textures/entity/seahorse/mark" + entity.getMark() + ".png"};
            Minecraft.func_71410_x().func_110434_K().func_229263_a_(layered, (Texture)new LayeredTexture(textures));
            LAYERED_LOCATION_CACHE.put(textureId, layered);
        }
        return layered;
    }

    private String getTextureId(SeahorseEntity seahorse) {
        String path = "abyssaldepths:textures/entity/seahorse/";
        String markNo = String.valueOf(seahorse.getMark());
        return path + markNo + ".png";
    }

    static class EyesLayer
    extends LayerRenderer<SeahorseEntity, SeahorseModel> {
        private final SeahorseModel seahorseModel = new SeahorseModel(0.01f);

        public EyesLayer(IEntityRenderer<SeahorseEntity, SeahorseModel> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, SeahorseEntity entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            EyesLayer.func_229140_a_((EntityModel)this.func_215332_c(), (EntityModel)this.seahorseModel, (ResourceLocation)EYES_TEXTURE, (MatrixStack)matrixStackIn, (IRenderTypeBuffer)bufferIn, (int)packedLightIn, (LivingEntity)entityIn, (float)limbSwing, (float)limbSwingAmount, (float)ageInTicks, (float)netHeadYaw, (float)headPitch, (float)partialTicks, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

