/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.abyssaldepths.entity;

import chumbanotz.abyssaldepths.entity.AquaticMobEntity;
import chumbanotz.abyssaldepths.entity.BodyPartEntity;
import chumbanotz.abyssaldepths.util.ADGlobal;
import chumbanotz.abyssaldepths.util.Bone;
import chumbanotz.abyssaldepths.util.Euler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class MultipartMobEntity
extends AquaticMobEntity {
    private static final DataParameter<Float> LIMB_SWING = EntityDataManager.func_187226_a(MultipartMobEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected int moveTick;

    protected MultipartMobEntity(EntityType<? extends MultipartMobEntity> type, World world) {
        super(type, world);
        this.field_70158_ak = true;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LIMB_SWING, (Object)Float.valueOf(0.0f));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
    }

    public boolean func_70090_H() {
        return super.func_70090_H();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            for (BodyPartEntity partEntity : this.getPartList()) {
                if (partEntity.isAddedToWorld()) continue;
                this.field_70170_p.func_217376_c((Entity)partEntity);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(LIMB_SWING, (Object)Float.valueOf(this.field_184619_aG));
        } else if (this.dPosX * this.dPosX + this.dPosY * this.dPosY + this.dPosZ * this.dPosZ < 1.6000001778593287E-5 || this.field_70173_aa % 100 == 0) {
            this.field_184619_aG = ((Float)this.field_70180_af.func_187225_a(LIMB_SWING)).floatValue();
        }
        this.dPosX = this.func_226277_ct_() - this.field_70169_q;
        this.dPosY = this.func_226278_cu_() - this.field_70167_r;
        this.dPosZ = this.func_226281_cx_() - this.field_70166_s;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.func_82168_bl();
        if (!this.func_70090_H()) {
            if (this.field_70122_E) {
                this.currentPitch *= 0.6f;
            } else {
                double d = MathHelper.func_76133_a((double)(this.dPosX * this.dPosX + this.dPosZ * this.dPosZ));
                float pitch = -((float)Math.atan2(this.dPosY, d)) * 57.295776f;
                this.currentPitch += (pitch - this.currentPitch) * 0.25f;
            }
        } else {
            this.currentPitch += (this.field_70125_A - this.currentPitch) * 0.1f;
        }
        this.updateParts();
    }

    @Override
    protected void moveCreature() {
        double targetSpeed = 0.0;
        LivingEntity target = this.func_70638_az();
        if (target != null) {
            ++this.moveTick;
            targetSpeed = this.moveByTarget(target);
        } else if (this.targetVec != null) {
            ++this.moveTick;
            targetSpeed = this.moveByPathing();
        } else if (this.field_70708_bq <= 100 && this.findNewPath()) {
            this.setRandomPath();
        }
        Vec3d lookVec = this.func_70040_Z();
        this.netSpeed += (targetSpeed - this.netSpeed) * 0.1;
        float dYaw = Math.abs(this.currentYaw - this.prevCurrentYaw);
        if (dYaw > 0.02f && this.netSpeed > targetSpeed * 0.6) {
            this.netSpeed += (targetSpeed * 0.6 - this.netSpeed) * 0.4;
        }
        if (this.onLand()) {
            this.netSpeed = 0.0;
            if (this.targetVec != null && this.field_70146_Z.nextInt(12) == 0) {
                this.func_213293_j(lookVec.field_72450_a * 0.25, 0.2f, lookVec.field_72449_c * 0.25);
            }
        }
        this.func_213315_a(MoverType.SELF, lookVec.func_186678_a(this.netSpeed));
    }

    public double moveByTarget(LivingEntity target) {
        return 0.0;
    }

    public double moveByPathing() {
        this.func_70671_ap().func_75650_a(this.targetVec.field_72450_a, this.targetVec.field_72448_b, this.targetVec.field_72449_c, 3.0f, 85.0f);
        Vec3d motion = this.func_213322_ci();
        if (this.field_70123_F && motion.field_72448_b < (double)0.2f) {
            this.func_213293_j(motion.field_72450_a, 0.2f, motion.field_72449_c);
        }
        if (this.targetVec.func_72438_d(this.func_213303_ch()) < 3.0 || this.moveTick > 120) {
            this.moveTick = 0;
            if (this.field_70146_Z.nextInt(5) < 3) {
                this.setRandomPath();
            } else {
                this.targetVec = null;
            }
        }
        return this.getMovementSpeed();
    }

    public final double getMovementSpeed() {
        return this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 1.8;
    }

    public abstract BodyPartEntity[] getPartList();

    public abstract Bone getBaseBone();

    public abstract Bone[] getBoneList();

    protected void updateParts() {
        this.getBaseBone().setRotation(this.currentPitch, this.field_70177_z, 0.0f);
        this.resetBoneAngles();
        this.updatePitchRotations(1.0f);
        this.updateYawRotations(1.0f);
        this.setBodyPartPositions();
    }

    public void updatePitchRotations(float partialTick) {
    }

    public void updateYawRotations(float partialTick) {
    }

    private void setBodyPartPositions() {
        BodyPartEntity[] partList = this.getPartList();
        Bone baseBone = this.getBaseBone();
        Bone[] boneList = this.getBoneList();
        Vec3d vec = boneList[0].getRotation().getRotated(baseBone.getRotation()).rotateVector(boneList[0].getLength() / 2.0f);
        partList[0].func_70012_b(this.func_226277_ct_() + vec.field_72450_a, this.func_226278_cu_() + vec.field_72448_b, this.func_226281_cx_() + vec.field_72449_c, this.field_70177_z, this.field_70125_A);
        vec = baseBone.getRotatedVector();
        Euler angle = baseBone.getRotation();
        for (int i = 1; i < partList.length; ++i) {
            angle = angle.getRotated(boneList[i].getRotation());
            float length = boneList[i].getLength();
            Vec3d midVec = angle.rotateVector(length / 2.0f);
            partList[i].func_70012_b(this.func_226277_ct_() + vec.field_72450_a + midVec.field_72450_a, this.func_226278_cu_() + vec.field_72448_b + midVec.field_72448_b, this.func_226281_cx_() + vec.field_72449_c + midVec.field_72449_c, this.field_70177_z, this.field_70125_A);
            Vec3d target = angle.rotateVector(length);
            vec = vec.func_178787_e(target);
        }
    }

    public void resetBoneAngles() {
        for (Bone bone : this.getBoneList()) {
            bone.setRotation(0.0f, 0.0f, 0.0f);
        }
    }

    public void collideWithEntity(BodyPartEntity part, Entity entity) {
    }

    public void eatOrDamageEntity(Entity target, float dmg) {
        MobEntity living;
        if (target instanceof MobEntity && target.func_213311_cf() < this.func_213311_cf() && (living = (MobEntity)target).func_110143_aJ() - dmg < 0.0f) {
            this.func_184609_a(Hand.MAIN_HAND);
            living.func_70106_y();
        }
        if (target.func_70089_S()) {
            target.func_70097_a((DamageSource)new EntityDamageSource("trident", (Entity)this), dmg);
        }
    }

    public void eatOrDamageEntity(BodyPartEntity part, Entity target, float dmg) {
        MobEntity living;
        float health;
        if (target instanceof MobEntity && target.func_213311_cf() < this.func_213311_cf() + 0.5f && target.func_213302_cg() < this.func_213302_cg() + 0.5f && (health = (living = (MobEntity)target).func_110143_aJ()) - dmg < 0.0f && (part == this.getPartList()[0] || part == this.getPartList()[1])) {
            this.func_184609_a(Hand.MAIN_HAND);
            if (living.func_70097_a(ADGlobal.consumeDamage((MobEntity)this), health) && !living.func_70089_S()) {
                living.func_70106_y();
            }
        }
        if (target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), dmg)) {
            this.func_184609_a(Hand.MAIN_HAND);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if ("arrow".equals(source.func_76355_l())) {
            amount *= 0.25f;
        }
        return super.func_70097_a(source, amount);
    }
}

