/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.abyssaldepths.entity;

import chumbanotz.abyssaldepths.entity.SchoolingMobEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class School {
    private int maxSchoolSize = 10;
    private float radius = 8.0f;
    private boolean openToCombine;
    private SchoolingMobEntity leader;
    private final World world;
    private final List<SchoolingMobEntity> creatureList = new ArrayList<SchoolingMobEntity>();

    public School(SchoolingMobEntity creature) {
        this.openToCombine = creature.field_70170_p.field_73012_v.nextInt(4) == 0;
        this.world = creature.field_70170_p;
        this.setLeader(creature);
    }

    public SchoolingMobEntity getLeader() {
        return this.leader;
    }

    public void setLeader(SchoolingMobEntity creature) {
        this.leader = creature;
        if (!this.creatureList.contains((Object)this.leader)) {
            this.addCreature(this.leader);
        }
    }

    public void chooseRandomLeader() {
        this.setLeader(this.creatureList.get(this.world.field_73012_v.nextInt(this.creatureList.size())));
    }

    public void addCreature(SchoolingMobEntity creature) {
        if (!this.creatureList.contains((Object)creature)) {
            this.creatureList.add(creature);
        }
    }

    public boolean ridinSolo() {
        return this.creatureList.size() == 1;
    }

    public boolean containsCreature(SchoolingMobEntity creature) {
        return this.creatureList.contains((Object)creature);
    }

    public void removeCreature(SchoolingMobEntity creature) {
        this.creatureList.remove((Object)creature);
        if (this.creatureList.size() > 1 && this.leader == creature) {
            this.chooseRandomLeader();
        }
        creature.school = creature.createSchool();
        creature.school.setOpenToCombine(false);
        creature.followEntity = null;
        creature.targetVec = null;
    }

    public int getMaxSize() {
        return this.maxSchoolSize;
    }

    public void setMaxSize(int maxSchoolSize) {
        this.maxSchoolSize = maxSchoolSize;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public boolean isOpenToCombine() {
        return this.openToCombine;
    }

    public void setOpenToCombine(boolean openToCombine) {
        this.openToCombine = openToCombine;
    }

    public void updateSchool() {
        boolean combine = this.isOpenToCombine();
        if (!combine && this.world.field_73012_v.nextInt(1500) == 0) {
            this.setOpenToCombine(true);
        } else if (combine && this.world.field_73012_v.nextInt(1800) == 0) {
            this.setOpenToCombine(false);
        }
        if (this.isOpenToCombine()) {
            for (Object creature : this.world.func_217357_a(SchoolingMobEntity.class, this.leader.func_174813_aQ().func_72314_b(16.0, 12.0, 16.0))) {
                if (this.containsCreature((SchoolingMobEntity)((Object)creature)) || ((SchoolingMobEntity)((Object)creature)).school == null || !((SchoolingMobEntity)((Object)creature)).canCombineWith(this)) continue;
                int netSize = this.creatureList.size() + ((SchoolingMobEntity)((Object)creature)).school.creatureList.size();
                if (!((SchoolingMobEntity)((Object)creature)).school.isOpenToCombine() || creature.func_200600_R() != this.leader.func_200600_R() || netSize > this.getMaxSize() || netSize > ((SchoolingMobEntity)((Object)creature)).school.getMaxSize()) continue;
                School.combineSchools(this, ((SchoolingMobEntity)((Object)creature)).school);
            }
        }
        boolean nearLeader = false;
        for (SchoolingMobEntity creature : this.world.func_217357_a(SchoolingMobEntity.class, this.leader.func_174813_aQ().func_186662_g(3.0))) {
            if (creature == this.leader || !this.containsCreature(creature)) continue;
            nearLeader = true;
            break;
        }
        for (int i = 0; i < this.creatureList.size(); ++i) {
            SchoolingMobEntity creature = this.creatureList.get(i);
            if (creature.func_70089_S() && creature.func_70090_H() && creature.func_70068_e((Entity)this.leader) <= 1024.0 && creature.func_184187_bx() == null) {
                if (creature == this.leader) continue;
                if (creature.func_70068_e((Entity)this.leader) <= (double)(this.radius * this.radius) && nearLeader) {
                    double dy;
                    List list = this.world.func_217357_a(SchoolingMobEntity.class, creature.func_174813_aQ().func_186662_g(16.0));
                    SchoolingMobEntity closestEntity = null;
                    double distSq = 1024.0;
                    boolean hasNearby = false;
                    for (int j = 0; j < list.size(); ++j) {
                        float w;
                        SchoolingMobEntity thing = (SchoolingMobEntity)((Object)list.get(j));
                        if (creature == thing || !this.containsCreature(thing)) continue;
                        dy = creature.func_70068_e((Entity)thing);
                        if (dy < (double)((w = (creature.func_213311_cf() + thing.func_213311_cf()) * 0.5f + 1.0f) * w)) {
                            hasNearby = true;
                            break;
                        }
                        if (!(dy < distSq * distSq)) continue;
                        closestEntity = thing;
                        distSq = dy;
                    }
                    if (!hasNearby && closestEntity != null) {
                        creature.followEntity = closestEntity;
                        creature.targetVec = null;
                        continue;
                    }
                    creature.followEntity = null;
                    if (this.leader.targetVec != null) {
                        if (creature.targetVec != null && this.world.field_73012_v.nextInt(10) != 0) continue;
                        double dx = this.leader.targetVec.field_72450_a - this.leader.func_226277_ct_() + (double)((this.world.field_73012_v.nextFloat() - 0.5f) * 1.1f);
                        dy = this.leader.targetVec.field_72448_b - this.leader.func_226278_cu_() + (double)((this.world.field_73012_v.nextFloat() - 0.5f) * 1.2f);
                        double dz = this.leader.targetVec.field_72449_c - this.leader.func_226281_cx_() + (double)((this.world.field_73012_v.nextFloat() - 0.5f) * 1.1f);
                        creature.targetVec = new Vec3d(creature.func_226277_ct_() + dx, creature.func_226278_cu_() + dy, creature.func_226281_cx_() + dz);
                        continue;
                    }
                    creature.targetVec = null;
                    Vec3d vec = this.leader.func_70040_Z();
                    creature.func_70671_ap().func_75650_a(creature.func_226277_ct_() + vec.field_72450_a, creature.func_226278_cu_() + vec.field_72448_b, creature.func_226281_cx_() + vec.field_72449_c, 6.0f, 85.0f);
                    continue;
                }
                creature.followEntity = this.leader;
                creature.targetVec = null;
                continue;
            }
            this.removeCreature(creature);
            --i;
        }
    }

    public static School combineSchools(School school1, School school2) {
        if (school2.creatureList.size() > school1.creatureList.size()) {
            school1.setLeader(school2.getLeader());
        }
        if (school2.getMaxSize() < school1.getMaxSize()) {
            school1.setMaxSize(school2.getMaxSize());
        }
        if (school2.getRadius() < school1.getRadius()) {
            school1.setRadius(school2.getRadius());
        }
        school1.creatureList.addAll(school2.creatureList);
        for (SchoolingMobEntity creature : school2.creatureList) {
            creature.school = school1;
        }
        return school1;
    }
}

