/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.abyssaldepths.entity;

import chumbanotz.abyssaldepths.entity.AquaticMobEntity;
import chumbanotz.abyssaldepths.entity.School;
import chumbanotz.abyssaldepths.util.ADGlobal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class SchoolingMobEntity
extends AquaticMobEntity {
    private static final DataParameter<Float> RED = EntityDataManager.func_187226_a(SchoolingMobEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> GREEN = EntityDataManager.func_187226_a(SchoolingMobEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> BLUE = EntityDataManager.func_187226_a(SchoolingMobEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final EntityPredicate AVOID_PLAYER_PREDICATE = new EntityPredicate().func_221013_a(6.0).func_221008_a().func_221014_c();
    protected School school = this.createSchool();
    protected double fleeDistance = 10.0;
    protected LivingEntity fleeFromEntity;
    protected LivingEntity followEntity;
    protected Vec3d fleeLookVec;

    protected SchoolingMobEntity(EntityType<? extends SchoolingMobEntity> type, World world) {
        super(type, world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(RED, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(GREEN, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(BLUE, (Object)Float.valueOf(1.0f));
    }

    public float getRed() {
        return ((Float)this.field_70180_af.func_187225_a(RED)).floatValue();
    }

    public float getGreen() {
        return ((Float)this.field_70180_af.func_187225_a(GREEN)).floatValue();
    }

    public float getBlue() {
        return ((Float)this.field_70180_af.func_187225_a(BLUE)).floatValue();
    }

    protected void setColor(float red, float green, float blue) {
        this.field_70180_af.func_187227_b(RED, (Object)Float.valueOf(red));
        this.field_70180_af.func_187227_b(GREEN, (Object)Float.valueOf(green));
        this.field_70180_af.func_187227_b(BLUE, (Object)Float.valueOf(blue));
    }

    public boolean isColorful() {
        return this.getRed() != 1.0f && this.getGreen() != 1.0f && this.getBlue() != 1.0f;
    }

    public School createSchool() {
        return new School(this);
    }

    public boolean func_70090_H() {
        return super.func_70090_H();
    }

    public boolean shouldLeaveSchool() {
        return this.field_70146_Z.nextInt(1800) == 0;
    }

    public boolean canCombineWith(School otherSchool) {
        return true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.dPosX = this.func_226277_ct_() - this.field_70169_q;
        this.dPosY = this.func_226278_cu_() - this.field_70167_r;
        this.dPosZ = this.func_226281_cx_() - this.field_70166_s;
        if (!this.field_70170_p.field_72995_K) {
            if (this.school == null) {
                this.school = this.createSchool();
            } else {
                SchoolingMobEntity leader = this.school.getLeader();
                if (leader == null || !leader.func_70089_S()) {
                    this.school.chooseRandomLeader();
                }
                if (leader == this) {
                    this.school.updateSchool();
                }
                if (!this.school.ridinSolo() && this.shouldLeaveSchool()) {
                    this.school.removeCreature(this);
                }
            }
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_70090_H()) {
            if (this.field_70122_E) {
                this.currentPitch *= 0.6f;
            } else {
                double d = MathHelper.func_76133_a((double)(this.dPosX * this.dPosX + this.dPosZ * this.dPosZ));
                float pitch = -((float)Math.atan2(this.dPosY, d)) * 57.295776f;
                this.currentPitch += (pitch - this.currentPitch) * 0.4f;
            }
        } else {
            this.currentPitch += (this.field_70125_A - this.currentPitch) * 0.05f;
        }
    }

    @Override
    protected void moveCreature() {
        Vec3d motion;
        double targetSpeed = 0.0;
        if (this.fleeFromEntity != null) {
            if (this.fleeLookVec == null || this.field_70146_Z.nextInt(30) == 0) {
                this.fleeLookVec = new Vec3d(this.func_226277_ct_() - this.fleeFromEntity.func_226277_ct_(), 2.0 + (2.0 + (double)this.field_70146_Z.nextFloat() * 3.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1), this.func_226281_cx_() - this.fleeFromEntity.func_226281_cx_());
                for (int i = 0; i < 4 && !this.isClearPath(this.func_213303_ch().func_178787_e(this.fleeLookVec)); ++i) {
                    this.fleeLookVec = new Vec3d(this.fleeLookVec.field_72450_a, 2.0 + (2.0 + (double)this.field_70146_Z.nextFloat() * 3.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1), this.fleeLookVec.field_72449_c);
                }
                this.fleeLookVec = this.fleeLookVec.func_72432_b();
                this.fleeLookVec.func_186678_a(4.0);
                this.fleeLookVec.func_72441_c((double)this.field_70146_Z.nextFloat(), 0.0, (double)this.field_70146_Z.nextFloat());
            }
            this.func_70671_ap().func_75650_a(this.func_226277_ct_() + this.fleeLookVec.field_72450_a, this.func_226278_cu_() + this.fleeLookVec.field_72448_b, this.func_226281_cx_() + this.fleeLookVec.field_72449_c, 10.0f, 85.0f);
            motion = this.func_213322_ci();
            if (this.field_70123_F && motion.field_72448_b < (double)0.2f) {
                this.func_213293_j(motion.field_72450_a, 0.2f, motion.field_72449_c);
            }
            targetSpeed = this.getMovementSpeed() * 2.0;
            if (!EntityPredicate.field_221016_a.func_221015_a((LivingEntity)this, this.fleeFromEntity) || this.func_70068_e((Entity)this.fleeFromEntity) > this.fleeDistance * this.fleeDistance) {
                this.resetFleeDistance();
                this.fleeFromEntity = null;
                this.fleeLookVec = null;
            }
        } else if (this.followEntity != null) {
            this.func_70671_ap().func_75651_a((Entity)this.followEntity, 6.0f, 85.0f);
            motion = this.func_213322_ci();
            if (this.field_70123_F && motion.field_72448_b < (double)0.2f) {
                this.func_213293_j(motion.field_72450_a, 0.2f, motion.field_72449_c);
            }
            if (this.func_70068_e((Entity)this.followEntity) > 1.0) {
                targetSpeed = this.getMovementSpeed();
            }
        } else if (this.targetVec != null) {
            this.func_70671_ap().func_75650_a(this.targetVec.field_72450_a, this.targetVec.field_72448_b, this.targetVec.field_72449_c, 10.0f, 85.0f);
            motion = this.func_213322_ci();
            if (this.field_70123_F && motion.field_72448_b < (double)0.2f) {
                this.func_213293_j(motion.field_72450_a, 0.2f, motion.field_72449_c);
            }
            targetSpeed = this.getMovementSpeed();
            if (!this.isTamed() && this.func_184187_bx() instanceof PlayerEntity) {
                targetSpeed *= (double)2.2f;
            }
            double closestDist = this.getClosestPathDist();
            if (this.targetVec.func_72436_e(this.func_213303_ch()) < closestDist * closestDist) {
                this.targetVec = null;
            }
        }
        if (this.field_70708_bq <= 100 && this.findNewPath() && this.school.getLeader() == this) {
            this.setRandomPath();
        }
        if (this.getFleesFromPlayers()) {
            this.fleeFromNearbyPlayers();
        }
        Vec3d lookVec = this.func_70040_Z();
        this.netSpeed += (targetSpeed - this.netSpeed) * 0.1;
        if (this.onLand()) {
            this.netSpeed = 0.0;
            if (this.targetVec != null && this.field_70146_Z.nextInt(20) == 0) {
                this.func_213293_j(lookVec.field_72450_a * (double)0.17f, 0.2f, lookVec.field_72449_c * (double)0.17f);
            }
        }
        this.func_213315_a(MoverType.SELF, lookVec.func_186678_a(this.netSpeed));
    }

    public final double getMovementSpeed() {
        return this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * (double)0.8f;
    }

    public void resetFleeDistance() {
        this.fleeDistance = 8.0 + (double)this.field_70146_Z.nextFloat() * 4.0;
    }

    public float getClosestPathDist() {
        return 1.0f;
    }

    public boolean getFleesFromPlayers() {
        return !this.isTamed();
    }

    private void fleeFromNearbyPlayers() {
        PlayerEntity player = this.field_70170_p.func_217370_a(AVOID_PLAYER_PREDICATE, (LivingEntity)this);
        if (player != null) {
            float angle = (float)Math.atan2(player.func_226281_cx_() - this.func_226281_cx_(), player.func_226277_ct_() - this.func_226277_ct_()) * 57.295776f - 90.0f;
            float delta = Math.abs((angle = ADGlobal.wrapAngleAround(angle, this.field_70177_z)) - this.field_70177_z);
            if (delta < 90.0f || this.func_70068_e((Entity)player) < 4.0 && delta < 120.0f) {
                this.fleeFromEntity = player;
                this.targetVec = null;
            }
        }
    }

    public void func_70645_a(DamageSource source) {
        super.func_70645_a(source);
        if (!this.field_70170_p.field_72995_K && this.school != null) {
            if (!this.school.ridinSolo()) {
                this.school.removeCreature(this);
            }
            if (this.school.getLeader() == this) {
                this.school.chooseRandomLeader();
            }
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_218657_a("Color", (INBT)this.func_70049_a(new float[]{this.getRed(), this.getGreen(), this.getBlue()}));
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("Color")) {
            ListNBT listNBT = compound.func_150295_c("Color", 5);
            this.setColor(listNBT.func_150308_e(0), listNBT.func_150308_e(1), listNBT.func_150308_e(2));
        }
    }
}

