/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.abyssaldepths.entity.billfish;

import chumbanotz.abyssaldepths.entity.BodyPartEntity;
import chumbanotz.abyssaldepths.entity.MultipartMobEntity;
import chumbanotz.abyssaldepths.entity.ai.goal.NearestWaterTargetGoal;
import chumbanotz.abyssaldepths.entity.fish.AbstractSchoolFishEntity;
import chumbanotz.abyssaldepths.util.ADGlobal;
import chumbanotz.abyssaldepths.util.Bone;
import chumbanotz.abyssaldepths.util.Euler;
import java.util.function.Predicate;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.passive.fish.AbstractGroupFishEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class AbstractBillfishEntity
extends MultipartMobEntity {
    private static final com.google.common.base.Predicate<LivingEntity> IS_PREY = target -> target.func_70090_H() && (target instanceof AbstractGroupFishEntity || target instanceof AbstractSchoolFishEntity);
    protected static final DataParameter<Byte> MARKINGS = EntityDataManager.func_187226_a(AbstractBillfishEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private int attackTime;
    private final BodyPartEntity[] partList = new BodyPartEntity[4];
    private final Bone baseBone = new Bone();
    private final Bone[] boneList = new Bone[4];
    private final Euler[] targetAngles = new Euler[4];

    protected AbstractBillfishEntity(EntityType<? extends AbstractBillfishEntity> type, World world) {
        super((EntityType<? extends MultipartMobEntity>)type, world);
        int i;
        this.baseBone.setLength(0.0f);
        this.boneList[0] = new Bone(this.baseBone);
        this.boneList[0].setLength(this.getPartLength()[0] / 16.0f);
        for (i = 1; i < this.boneList.length; ++i) {
            this.boneList[i] = new Bone(i == 1 ? this.baseBone : this.boneList[i - 1]);
            this.boneList[i].setLength(-this.getPartLength()[i] / 16.0f);
        }
        for (i = 0; i < this.partList.length; ++i) {
            this.targetAngles[i] = new Euler();
            this.partList[i] = new BodyPartEntity(this, this.getPartLength()[i] / 16.0f);
        }
        this.updateParts();
    }

    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(1, new NearestWaterTargetGoal<WaterMobEntity>((MobEntity)this, WaterMobEntity.class, 60, true, false, (Predicate<LivingEntity>)IS_PREY));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MARKINGS, (Object)0);
    }

    public boolean hasBanner() {
        return ((Byte)this.field_70180_af.func_187225_a(MARKINGS) & 1) != 0;
    }

    protected void setBanner(boolean banner) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(MARKINGS);
        this.field_70180_af.func_187227_b(MARKINGS, (Object)(banner ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE)));
    }

    public boolean hasStripes() {
        return ((Byte)this.field_70180_af.func_187225_a(MARKINGS) & 2) != 0;
    }

    protected void setStripes(boolean stripes) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(MARKINGS);
        this.field_70180_af.func_187227_b(MARKINGS, (Object)(stripes ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD)));
    }

    protected abstract float[] getPartLength();

    protected abstract double getStrikeRange();

    protected abstract float getAttackReach();

    protected abstract int getMaxAttackTime();

    @Override
    public BodyPartEntity[] getPartList() {
        return this.partList;
    }

    @Override
    public Bone getBaseBone() {
        return this.baseBone;
    }

    @Override
    public Bone[] getBoneList() {
        return this.boneList;
    }

    @Override
    public void updateYawRotations(float partialTick) {
        for (int i = this.boneList.length - 1; i > 1; --i) {
            if (partialTick == 1.0f) {
                this.targetAngles[i].y = this.targetAngles[i - 1].y;
                this.boneList[i].getRotation().y += this.targetAngles[i].y;
                continue;
            }
            this.boneList[i].getRotation().y += this.targetAngles[i].y + (this.targetAngles[i - 1].y - this.targetAngles[i].y) * partialTick;
        }
        this.targetAngles[1].y = -(this.currentYaw - this.prevCurrentYaw) * 1.4f;
        this.targetAngles[0].y = (this.currentYaw - this.prevCurrentYaw) * 1.4f;
        float moveScale = MathHelper.func_219799_g((float)partialTick, (float)this.field_184618_aE, (float)this.field_70721_aZ);
        float moveTick = this.field_184619_aG - this.field_70721_aZ * (1.0f - partialTick);
        if (moveScale > 1.0f) {
            moveScale = 1.0f;
        }
        for (int i = 0; i < this.boneList.length; ++i) {
            float breatheAnim = MathHelper.func_76126_a((float)(0.1f * ((float)this.field_70173_aa + partialTick - (float)i * 1.4f)));
            float moveAnim = MathHelper.func_76126_a((float)(0.7f * (moveTick - (float)i * 1.4f))) * moveScale;
            this.boneList[i].getRotation().y += breatheAnim * 1.1f;
            this.boneList[i].getRotation().y += moveAnim * 8.0f;
        }
    }

    @Override
    protected void moveCreature() {
        super.moveCreature();
        if (this.attackTime > this.getMaxAttackTime()) {
            Entity owner;
            boolean attack;
            float dmg = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            Entity entity = ADGlobal.getPointedEntity((LivingEntity)this, this.getAttackReach());
            boolean bl = attack = entity != null && entity.func_200600_R() != this.func_200600_R();
            if (entity instanceof BodyPartEntity && (owner = ((BodyPartEntity)entity).getOwner()) != null && this.func_70638_az() != owner && owner.func_200600_R() == this.func_200600_R()) {
                attack = false;
            }
            if (entity != null && attack) {
                this.eatOrDamageEntity(entity, dmg);
            }
        }
        --this.attackTime;
    }

    @Override
    public double moveByTarget(LivingEntity target) {
        if (this.attackTime > 0) {
            this.func_70671_ap().func_75651_a((Entity)target, this.attackTime > this.getMaxAttackTime() ? 15.0f : 0.0f, 85.0f);
        } else {
            this.func_70671_ap().func_75651_a((Entity)target, 8.0f, 85.0f);
        }
        double strikeRange = this.getStrikeRange();
        if (this.attackTime <= 0 && this.func_70068_e((Entity)target) < strikeRange * strikeRange && this.field_70146_Z.nextInt(4) == 0) {
            double x = target.func_226277_ct_() - this.func_226277_ct_();
            double y = target.func_226278_cu_() - this.func_226278_cu_();
            double z = target.func_226281_cx_() - this.func_226281_cx_();
            double d = Math.sqrt(x * x + y * y + z * z);
            double scale = this.getMovementSpeed() / 0.8;
            this.func_213293_j(x / d * scale, y / d * scale, z / d * scale);
            this.attackTime = 16 + this.field_70146_Z.nextInt(5);
        }
        return this.attackTime > 0 ? 0.0 : this.getMovementSpeed() * 1.2;
    }

    @Override
    public boolean findNewPath() {
        return this.field_70146_Z.nextInt(45) == 0 || this.onLand() && this.field_70146_Z.nextInt(4) == 0;
    }

    @Override
    public boolean setRandomPath() {
        Vec3d vec3d = this.func_213303_ch().func_72441_c((6.0 + (double)this.field_70146_Z.nextFloat() * 6.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1), ((double)this.field_70146_Z.nextFloat() - 0.5) * 8.0 + this.addPathY(), (6.0 + (double)this.field_70146_Z.nextFloat() * 6.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1));
        if (this.onLand()) {
            vec3d = new Vec3d(this.func_226277_ct_() + (4.0 + (double)this.field_70146_Z.nextFloat() * 12.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1), vec3d.field_72448_b, this.func_226281_cx_() + (4.0 + (double)this.field_70146_Z.nextFloat() * 12.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1));
        }
        if (this.isClearPath(vec3d)) {
            this.targetVec = vec3d;
            return true;
        }
        return false;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Banner", this.hasBanner());
        compound.func_74757_a("Stripes", this.hasStripes());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setBanner(compound.func_74767_n("Banner"));
        this.setStripes(compound.func_74767_n("Stripes"));
    }
}

