/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.abyssaldepths.entity.fish;

import chumbanotz.abyssaldepths.entity.MultipartMobEntity;
import chumbanotz.abyssaldepths.entity.School;
import chumbanotz.abyssaldepths.entity.SchoolingMobEntity;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public abstract class AbstractSchoolFishEntity
extends SchoolingMobEntity {
    private static final DataParameter<Boolean> FROM_BUCKET = EntityDataManager.func_187226_a(AbstractSchoolFishEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> SCALE = EntityDataManager.func_187226_a(AbstractSchoolFishEntity.class, (IDataSerializer)DataSerializers.field_187193_c);

    protected AbstractSchoolFishEntity(EntityType<? extends AbstractSchoolFishEntity> type, World world) {
        super((EntityType<? extends SchoolingMobEntity>)type, world);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FROM_BUCKET, (Object)false);
        this.field_70180_af.func_187214_a(SCALE, (Object)Float.valueOf(1.0f));
    }

    private boolean isFromBucket() {
        return (Boolean)this.field_70180_af.func_187225_a(FROM_BUCKET);
    }

    public void setFromBucket(boolean fromBucket) {
        this.field_70180_af.func_187227_b(FROM_BUCKET, (Object)fromBucket);
    }

    public float func_213355_cm() {
        return ((Float)this.field_70180_af.func_187225_a(SCALE)).floatValue();
    }

    protected void setScale(float scale) {
        this.field_70180_af.func_187227_b(SCALE, (Object)Float.valueOf(scale));
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (SCALE.equals(key)) {
            this.func_213323_x_();
        }
    }

    @Override
    public School createSchool() {
        School school = new School(this);
        school.setMaxSize(6 + this.field_70146_Z.nextInt(6));
        school.setRadius(school.getMaxSize());
        return school;
    }

    @Override
    protected void moveCreature() {
        for (MultipartMobEntity multipartMobEntity : this.field_70170_p.func_217357_a(MultipartMobEntity.class, this.func_174813_aQ().func_186662_g(2.0))) {
            if (!(this.func_70068_e((Entity)multipartMobEntity) <= 4.0) || !EntityPredicate.field_221016_a.func_221015_a((LivingEntity)this, (LivingEntity)multipartMobEntity)) continue;
            this.fleeFromEntity = multipartMobEntity;
        }
        super.moveCreature();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!super.func_70097_a(source, amount)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity instanceof LivingEntity) {
            this.fleeFromEntity = (LivingEntity)entity;
        }
        return true;
    }

    protected abstract ItemStack getFishBucket();

    protected void setBucketData(ItemStack bucket) {
        CompoundNBT compoundnbt = bucket.func_196082_o();
        compoundnbt.func_74776_a("Scale", this.func_213355_cm());
        compoundnbt.func_218657_a("Color", (INBT)this.func_70049_a(new float[]{this.getRed(), this.getGreen(), this.getBlue()}));
        if (this.func_145818_k_()) {
            bucket.func_200302_a(this.func_200201_e());
        }
    }

    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        ItemStack bucket = this.getFishBucket();
        if (itemstack.func_77973_b() == Items.field_151131_as && !bucket.func_190926_b()) {
            this.func_184185_a(SoundEvents.field_203814_aa, 1.0f, 1.0f);
            itemstack.func_190918_g(1);
            this.setBucketData(bucket);
            if (!this.field_70170_p.field_72995_K) {
                CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)player, bucket);
            }
            if (itemstack.func_190926_b()) {
                player.func_184611_a(hand, bucket);
            } else if (!player.field_71071_by.func_70441_a(bucket)) {
                player.func_71019_a(bucket, false);
            }
            this.func_70106_y();
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (dataTag != null) {
            if (dataTag.func_74764_b("Scale")) {
                this.setScale(dataTag.func_74760_g("Scale"));
            }
            if (dataTag.func_74764_b("Color")) {
                ListNBT listNBT = dataTag.func_150295_c("Color", 5);
                this.setColor(listNBT.func_150308_e(0), listNBT.func_150308_e(1), listNBT.func_150308_e(2));
            }
            return spawnDataIn;
        }
        this.setScale(0.5f + this.field_70146_Z.nextFloat() * 0.6f);
        return spawnDataIn;
    }

    @Override
    public boolean getFleesFromPlayers() {
        return !this.isFromBucket();
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.isFromBucket() && !this.func_145818_k_();
    }

    public boolean func_213392_I() {
        return this.isFromBucket();
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_203813_aA;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_203816_ay;
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_203817_bZ;
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("FromBucket", this.isFromBucket());
        compound.func_74776_a("Scale", this.func_213355_cm());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setFromBucket(compound.func_74767_n("FromBucket"));
        if (compound.func_74764_b("Scale")) {
            this.setScale(compound.func_74760_g("Scale"));
        }
    }
}

