/*
 * Decompiled with CFR 0.152.
 */
package al132.chemlib;

import al132.chemlib.chemistry.ChemicalStack;
import al132.chemlib.items.CompoundItem;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class Utils {
    public static Optional<Item> getItem(String namespace, String path) {
        return Optional.ofNullable(ForgeRegistries.ITEMS.getValue(new ResourceLocation(namespace, path)));
    }

    public static Optional<Item> getChemItem(String name) {
        return Utils.getItem("chemlib", name);
    }

    public static String getAbbreviation(ChemicalStack component) {
        return Utils.getAbbreviation(Lists.newArrayList((Object[])new ChemicalStack[]{component}));
    }

    public static String getSubscript(String n) {
        int subscriptZeroCodepoint = 8320;
        StringBuilder builder = new StringBuilder();
        for (char c : n.toCharArray()) {
            builder.append(Character.toChars(8320 + Character.getNumericValue(c)));
        }
        return builder.toString();
    }

    public static String getSubscript(int n) {
        return Utils.getSubscript(Integer.toString(n));
    }

    public static String getAbbreviation(List<ChemicalStack> components) {
        StringBuilder builder = new StringBuilder();
        for (ChemicalStack component : components) {
            String abbreviation = component.chemical.getAbbreviation();
            if (component.chemical instanceof CompoundItem) {
                builder.append("(" + abbreviation + ")");
            } else {
                builder.append(abbreviation);
            }
            if (component.quantity <= 1) continue;
            builder.append(Utils.getSubscript(component.quantity));
        }
        return builder.toString();
    }
}

