/*
 * Decompiled with CFR 0.152.
 */
package al132.alib.tiles;

import al132.alib.tiles.ABaseTile;
import al132.alib.tiles.AutomationStackHandler;
import al132.alib.tiles.CustomStackHandler;
import al132.alib.tiles.InventoryTile;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public abstract class ABaseInventoryTile
extends ABaseTile
implements InventoryTile {
    private CustomStackHandler input;
    private CustomStackHandler output;
    private AutomationStackHandler automationInput;
    private AutomationStackHandler automationOutput;
    private CombinedInvWrapper combinedInv;
    protected LazyOptional<IItemHandler> inventoryHolder = LazyOptional.of(() -> this.combinedInv);

    public ABaseInventoryTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.input = this.initInput();
        this.output = this.initOutput();
        this.automationInput = this.initAutomationInput((IItemHandlerModifiable)this.input);
        this.automationOutput = this.initAutomationOutput((IItemHandlerModifiable)this.output);
        this.combinedInv = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.automationInput, this.automationOutput});
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.input.deserializeNBT(compound.func_74775_l("input"));
        this.output.deserializeNBT(compound.func_74775_l("output"));
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("input", (INBT)this.input.serializeNBT());
        compound.func_218657_a("output", (INBT)this.output.serializeNBT());
        return super.func_189515_b(compound);
    }

    @Override
    public LazyOptional<IItemHandler> getExternalInventory() {
        return this.inventoryHolder;
    }

    @Override
    public CombinedInvWrapper getAutomationInventory() {
        return this.combinedInv;
    }

    @Override
    public CustomStackHandler getInput() {
        return this.input;
    }

    @Override
    public CustomStackHandler getOutput() {
        return this.output;
    }
}

