/*
 * Decompiled with CFR 0.152.
 */
package al132.alchemistry;

import al132.alchemistry.AlchemistryData;
import al132.alchemistry.Config;
import al132.alchemistry.Ref;
import al132.alchemistry.network.NetworkHandler;
import al132.alchemistry.recipes.ModRecipes;
import al132.alchemistry.setup.ClientProxy;
import al132.alchemistry.setup.IProxy;
import al132.alchemistry.setup.ServerProxy;
import al132.alib.ModData;
import net.minecraft.block.Block;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="alchemistry")
public class Alchemistry {
    public static final Logger LOGGER = LogManager.getLogger();
    public static IProxy proxy = (IProxy)DistExecutor.runForDist(() -> () -> new ClientProxy(), () -> () -> new ServerProxy());
    public static ModData data = new AlchemistryData();

    public Alchemistry() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.COMMON_CONFIG);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
        Config.loadConfig(Config.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("alchemistry-common.toml"));
    }

    private void setup(FMLCommonSetupEvent event) {
        proxy.init();
        DeferredWorkQueue.runLater(() -> NetworkHandler.register());
    }

    private void doClientStuff(FMLClientSetupEvent event) {
    }

    @SubscribeEvent
    public void serverStarting(FMLServerStartingEvent e) {
        ModRecipes.init();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onTilesRegistry(RegistryEvent.Register<TileEntityType<?>> e) {
            data.registerTiles(e);
        }

        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> e) {
            Ref.initBlocks();
            Alchemistry.data.BLOCKS.forEach(arg_0 -> ((IForgeRegistry)e.getRegistry()).register(arg_0));
        }

        @SubscribeEvent
        public static void onContainerRegistry(RegistryEvent.Register<ContainerType<?>> e) {
            data.registerContainers(e);
        }

        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> e) {
            Ref.initItems();
            Alchemistry.data.ITEMS.forEach(arg_0 -> ((IForgeRegistry)e.getRegistry()).register(arg_0));
            Alchemistry.data.BLOCKS.forEach(x -> e.getRegistry().register(new BlockItem((Block)x, new Item.Properties().func_200916_a(Alchemistry.data.itemGroup)).setRegistryName(x.getRegistryName())));
        }

        @SubscribeEvent
        public static void onRecipeRegistry(RegistryEvent.Register<IRecipeSerializer<?>> e) {
        }
    }
}

