/*
 * Decompiled with CFR 0.152.
 */
package al132.alchemistry.blocks.combiner;

import al132.alchemistry.Config;
import al132.alchemistry.Ref;
import al132.alchemistry.blocks.AlchemistryBaseTile;
import al132.alchemistry.blocks.combiner.CombinerContainer;
import al132.alchemistry.recipes.CombinerRecipe;
import al132.alib.tiles.ABaseTile;
import al132.alib.tiles.CustomEnergyStorage;
import al132.alib.tiles.CustomStackHandler;
import al132.alib.tiles.EnergyTile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;

public class CombinerTile
extends AlchemistryBaseTile
implements EnergyTile {
    public static TileEntityType<CombinerTile> type;
    public CombinerRecipe currentRecipe = null;
    public boolean recipeIsLocked = false;
    int progressTicks = 0;
    public boolean paused = false;
    public CustomStackHandler clientRecipeTarget = new CustomStackHandler((ABaseTile)this, 1){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return false;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }
    };

    public CombinerTile() {
        super(Ref.combinerTile);
    }

    public void updateRecipe() {
        this.currentRecipe = CombinerRecipe.matchInputs((IItemHandler)this.getInput());
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack displayStack = ItemStack.field_190927_a;
        if (this.currentRecipe != null && this.currentRecipe.output != null) {
            displayStack = this.currentRecipe.output.getStack().func_77946_l();
        }
        if (this.recipeIsLocked) {
            this.clientRecipeTarget.setStackInSlot(0, displayStack);
        }
        if (!this.paused && this.canProcess()) {
            this.process();
        }
        this.markDirtyClient();
    }

    public boolean canProcess() {
        return !(this.currentRecipe == null || this.energy.getEnergyStored() < (Integer)Config.COMBINER_ENERGY_PER_TICK.get() || this.currentRecipe.output.func_190916_E() + this.getOutput().getStackInSlot(0).func_190916_E() > this.currentRecipe.output.func_77976_d() || !ItemStack.func_179545_c((ItemStack)this.getOutput().getStackInSlot(0), (ItemStack)this.currentRecipe.output) && !this.getOutput().getStackInSlot(0).func_190926_b() || !this.currentRecipe.matchesHandlerStacks(this.getInput()) || this.recipeIsLocked && !ItemStack.func_77989_b((ItemStack)CombinerRecipe.matchInputs((IItemHandler)this.getInput()).output, (ItemStack)this.currentRecipe.output));
    }

    public void process() {
        this.energy.extractEnergy(((Integer)Config.COMBINER_ENERGY_PER_TICK.get()).intValue(), false);
        if (this.progressTicks < (Integer)Config.COMBINER_TICKS_PER_OPERATION.get()) {
            ++this.progressTicks;
        } else {
            this.progressTicks = 0;
            if (this.currentRecipe != null) {
                this.getOutput().setOrIncrement(0, this.currentRecipe.output.func_77946_l());
            }
            if (this.currentRecipe != null && this.currentRecipe.inputs.size() == 9) {
                for (int index = 0; index < 9; ++index) {
                    if (this.currentRecipe == null) continue;
                    ItemStack stack = this.currentRecipe.inputs.get(index);
                    if (stack != null && !stack.func_190926_b()) {
                        this.getInput().decrementSlot(index, stack.func_190916_E());
                    }
                    if (this.getInput().getStackInSlot(index).func_77973_b() != Ref.slotFiller) continue;
                    this.getInput().decrementSlot(index, 1);
                }
            }
        }
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.recipeIsLocked = compound.func_74767_n("recipeIsLocked");
        this.progressTicks = compound.func_74762_e("progressTicks");
        this.paused = compound.func_74767_n("paused");
        if (this.recipeIsLocked) {
            this.currentRecipe = CombinerRecipe.matchOutput(ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("recipeTarget")));
            ItemStack temp = ItemStack.field_190927_a;
            if (this.currentRecipe != null) {
                temp = this.currentRecipe.output.func_77946_l();
            }
            this.clientRecipeTarget.setStackInSlot(0, temp);
        } else {
            this.updateRecipe();
            this.clientRecipeTarget.setStackInSlot(0, ItemStack.field_190927_a);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74757_a("recipeIsLocked", this.recipeIsLocked);
        compound.func_74768_a("progressTicks", this.progressTicks);
        compound.func_74757_a("paused", this.paused);
        compound.func_218657_a("recipeTarget", (INBT)this.clientRecipeTarget.getStackInSlot(0).serializeNBT());
        return super.func_189515_b(compound);
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInv, PlayerEntity player) {
        return new CombinerContainer(i, this.field_145850_b, this.field_174879_c, playerInv, player);
    }

    public CustomStackHandler initInput() {
        return new CustomStackHandler((ABaseTile)this, 9){

            @Nonnull
            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (!CombinerTile.this.recipeIsLocked) {
                    return super.isItemValid(slot, stack);
                }
                if (CombinerTile.this.recipeIsLocked && CombinerTile.this.currentRecipe != null && !CombinerTile.this.currentRecipe.inputs.isEmpty() && ItemStack.func_179545_c((ItemStack)stack, (ItemStack)CombinerTile.this.currentRecipe.inputs.get(slot))) {
                    return super.isItemValid(slot, stack);
                }
                return false;
            }

            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                if (!CombinerTile.this.recipeIsLocked) {
                    CombinerTile.this.updateRecipe();
                }
            }
        };
    }

    public CustomStackHandler initOutput() {
        return new CustomStackHandler((ABaseTile)this, 1){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return false;
            }
        };
    }

    public IEnergyStorage initEnergy() {
        return new CustomEnergyStorage(((Integer)Config.COMBINER_ENERGY_CAPACITY.get()).intValue());
    }

    public IEnergyStorage getEnergy() {
        return this.energy;
    }
}

