/*
 * Decompiled with CFR 0.152.
 */
package al132.alchemistry.network;

import al132.alchemistry.blocks.combiner.CombinerTile;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class CombinerButtonPkt {
    private BlockPos pos;
    private boolean lock;
    private boolean pause;

    public CombinerButtonPkt(BlockPos pos, boolean lock, boolean pause) {
        this.pos = pos;
        this.lock = lock;
        this.pause = pause;
    }

    public static void encode(CombinerButtonPkt pkt, PacketBuffer buf) {
        buf.func_179255_a(pkt.pos);
        buf.writeBoolean(pkt.lock);
        buf.writeBoolean(pkt.pause);
    }

    public static CombinerButtonPkt decode(PacketBuffer buf) {
        return new CombinerButtonPkt(buf.func_179259_c(), buf.readBoolean(), buf.readBoolean());
    }

    public static class Handler {
        public static void handle(CombinerButtonPkt message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity playerEntity = ((NetworkEvent.Context)ctx.get()).getSender();
                CombinerTile tile = (CombinerTile)playerEntity.field_70170_p.func_175625_s(message.pos);
                if (message.lock) {
                    boolean bl = tile.recipeIsLocked = !tile.recipeIsLocked;
                    if (!tile.recipeIsLocked) {
                        tile.currentRecipe = null;
                    }
                } else if (message.pause) {
                    boolean bl = tile.paused = !tile.paused;
                }
                if (!tile.recipeIsLocked) {
                    tile.clientRecipeTarget.setStackInSlot(0, ItemStack.field_190927_a);
                }
                tile.markDirtyClient();
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

