/*
 * Decompiled with CFR 0.152.
 */
package al132.alchemistry.network;

import al132.alchemistry.blocks.combiner.CombinerTile;
import al132.alchemistry.recipes.CombinerRecipe;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class CombinerTransferPkt {
    private ItemStack outputStack;
    private BlockPos pos;

    public CombinerTransferPkt(ItemStack stack, BlockPos pos) {
        this.outputStack = stack;
        this.pos = pos;
    }

    public static void encode(CombinerTransferPkt pkt, PacketBuffer buf) {
        buf.func_150788_a(pkt.outputStack);
        buf.func_179255_a(pkt.pos);
    }

    public static CombinerTransferPkt decode(PacketBuffer buf) {
        return new CombinerTransferPkt(buf.func_150791_c(), buf.func_179259_c());
    }

    public static class Handler {
        public static void handle(CombinerTransferPkt message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity playerEntity = ((NetworkEvent.Context)ctx.get()).getSender();
                CombinerTile tile = (CombinerTile)playerEntity.field_70170_p.func_175625_s(message.pos);
                ItemStack output = message.outputStack;
                if (!output.func_190926_b()) {
                    tile.clientRecipeTarget.setStackInSlot(0, output.func_77946_l());
                    tile.recipeIsLocked = true;
                    tile.currentRecipe = CombinerRecipe.matchOutput(output.func_77946_l());
                }
                tile.markDirtyClient();
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

