/*
 * Decompiled with CFR 0.152.
 */
package al132.alchemistry.recipes;

import al132.alchemistry.Alchemistry;
import al132.alchemistry.recipes.ModRecipes;
import al132.alchemistry.recipes.ProbabilitySet;
import com.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;

public class DissolverRecipe {
    public Ingredient input;
    public boolean reversible = false;
    public ProbabilitySet outputs;
    public NonNullList<ItemStack> inputs;

    public DissolverRecipe(Builder builder) {
        this(builder.input, builder.outputs);
        this.reversible = builder.reversible;
    }

    public DissolverRecipe(Ingredient input, ProbabilitySet outputs) {
        this.input = input;
        this.outputs = outputs;
        this.inputs = NonNullList.func_191196_a();
        if (input != null) {
            this.inputs.addAll((Collection)Lists.newArrayList((Object[])((Object[])input.func_193365_a().clone())));
        }
    }

    public void setReversible(boolean reversible) {
        this.reversible = reversible;
    }

    public DissolverRecipe copy() {
        return new DissolverRecipe(this.input, this.outputs);
    }

    @Nullable
    public static DissolverRecipe match(ItemStack input, boolean quantitySensitive) {
        for (DissolverRecipe recipe : ModRecipes.dissolverRecipes) {
            for (ItemStack recipeStack : recipe.inputs) {
                if (!ItemStack.func_179545_c((ItemStack)recipeStack, (ItemStack)input)) continue;
                if (quantitySensitive && input.func_190916_E() >= recipeStack.func_190916_E()) {
                    return recipe.copy();
                }
                if (quantitySensitive) continue;
                return recipe.copy();
            }
        }
        return null;
    }

    public static class Builder {
        private Ingredient input;
        private ProbabilitySet outputs;
        private boolean reversible = false;

        public Builder outputs(ProbabilitySet set) {
            this.outputs = set;
            return this;
        }

        public Builder input(ItemStack input) {
            this.input = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{input});
            return this;
        }

        public Builder input(Item input) {
            this.input = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{input});
            return this;
        }

        public Builder setReversible(boolean value) {
            this.reversible = value;
            return this;
        }

        public <T> Builder input(Tag<T> tag) {
            Object[] temp = tag.func_199885_a().toArray();
            if (temp.length > 0) {
                this.input = temp[0] instanceof Item ? Ingredient.func_199805_a(tag) : Ingredient.func_193369_a((ItemStack[])((ItemStack[])tag.func_199885_a().stream().map(ItemStack::new).toArray(ItemStack[]::new)));
                return this;
            }
            throw new RuntimeException("Invalid tag[" + tag.func_199886_b() + "] for dissolver recipe input");
        }

        public Builder input(Ingredient input) {
            this.input = input;
            return this;
        }

        public void build() {
            String outs;
            String ins = this.input == null ? "null" : this.input.toString();
            String string = outs = this.outputs == null ? "null" : this.outputs.toString();
            if (this.input != null && this.outputs != null) {
                ModRecipes.dissolverRecipes.add(new DissolverRecipe(this));
            } else {
                Alchemistry.LOGGER.warn("Invalid dissolver recipe - input[" + ins + "], outputs[" + outs + "]");
            }
        }
    }
}

