/*
 * Decompiled with CFR 0.152.
 */
package al132.alchemistry.recipes;

import al132.alchemistry.Ref;
import al132.alchemistry.recipes.AtomizerRecipe;
import al132.alchemistry.recipes.CombinerRecipe;
import al132.alchemistry.recipes.DissolverRecipe;
import al132.alchemistry.recipes.DissolverTagData;
import al132.alchemistry.recipes.EvaporatorRecipe;
import al132.alchemistry.recipes.FissionRecipe;
import al132.alchemistry.recipes.LiquifierRecipe;
import al132.alchemistry.recipes.ProbabilitySet;
import al132.alchemistry.utils.StringUtils;
import al132.chemlib.chemistry.CompoundRegistry;
import al132.chemlib.chemistry.ElementRegistry;
import al132.chemlib.items.CompoundItem;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidStack;

public class ModRecipes {
    public static List<DissolverRecipe> dissolverRecipes = new ArrayList<DissolverRecipe>();
    public static List<CombinerRecipe> combinerRecipes = new ArrayList<CombinerRecipe>();
    public static List<EvaporatorRecipe> evaporatorRecipes = new ArrayList<EvaporatorRecipe>();
    public static List<AtomizerRecipe> atomizerRecipes = new ArrayList<AtomizerRecipe>();
    public static List<LiquifierRecipe> liquifierRecipes = new ArrayList<LiquifierRecipe>();
    public static List<FissionRecipe> fissionRecipes = new ArrayList<FissionRecipe>();
    public static List<DissolverTagData> metalTagData = new ArrayList<DissolverTagData>();
    public static List<String> metals = new ArrayList<String>();
    public static final String heathenSpelling = "aluminium";

    public static void init() {
        metals.add(heathenSpelling);
        metals.addAll(ElementRegistry.elements.values().stream().map(it -> it.internalName).collect(Collectors.toList()));
        metalTagData.add(new DissolverTagData("ingots", 16, metals));
        metalTagData.add(new DissolverTagData("ores", 32, metals));
        metalTagData.add(new DissolverTagData("dusts", 16, metals));
        metalTagData.add(new DissolverTagData("storage_blocks", 144, metals));
        metalTagData.add(new DissolverTagData("nuggets", 1, metals));
        metalTagData.add(new DissolverTagData("plates", 16, metals));
        ModRecipes.initEvaporatorRecipes();
        ModRecipes.initDissolverRecipes();
        ModRecipes.initCombinerRecipes();
        ModRecipes.initAtomizerRecipes();
        ModRecipes.initLiquifierRecipes();
        ModRecipes.initFissionRecipes();
    }

    private static void initEvaporatorRecipes() {
        evaporatorRecipes.add(new EvaporatorRecipe(new FluidStack((Fluid)Fluids.field_204546_a, 125), new ItemStack((IItemProvider)Ref.mineralSalt)));
        evaporatorRecipes.add(new EvaporatorRecipe(new FluidStack((Fluid)Fluids.field_204547_b, 1000), new ItemStack((IItemProvider)Blocks.field_196814_hQ)));
    }

    private static void initDissolverRecipes() {
        int multiplier;
        int rolls;
        ModRecipes.dissolver().input(ItemTags.field_200038_h).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("cellulose")).build()).build();
        ModRecipes.dissolver().input(ItemTags.field_199905_b).outputs(ModRecipes.set().relative(false).addGroup(25.0, StringUtils.toStack("cellulose")).build()).build();
        ModRecipes.dissolver().input(ItemTags.field_206963_E).outputs(ModRecipes.set().relative(false).addGroup(5.0, StringUtils.toStack("cellulose")).build()).build();
        ModRecipes.dissolver().input(Tags.Items.COBBLESTONE).outputs(ModRecipes.set().addGroup(700.0, ItemStack.field_190927_a).addGroup(2.0, StringUtils.toStack("aluminum")).addGroup(4.0, StringUtils.toStack("iron")).addGroup(1.5, StringUtils.toStack("gold")).addGroup(10.0, StringUtils.toStack("silicon_dioxide")).addGroup(1.0, StringUtils.toStack("dysprosium")).addGroup(1.5, StringUtils.toStack("zirconium")).addGroup(1.0, StringUtils.toStack("nickel")).addGroup(1.0, StringUtils.toStack("gallium")).addGroup(1.0, StringUtils.toStack("tungsten")).build()).build();
        Lists.newArrayList((Object[])new Item[]{Items.field_221575_c, Items.field_221576_d}).forEach(item -> ModRecipes.dissolver().input((Item)item).outputs(ModRecipes.set().addGroup(5.0, StringUtils.toStack("aluminum_oxide")).addGroup(2.0, StringUtils.toStack("iron")).addGroup(2.0, StringUtils.toStack("potassium_chloride")).addGroup(10.0, StringUtils.toStack("silicon_dioxide")).addGroup(1.0, StringUtils.toStack("technetium")).addGroup(1.5, StringUtils.toStack("manganese")).addGroup(1.5, StringUtils.toStack("radium")).build()).build());
        Lists.newArrayList((Object[])new Item[]{Items.field_221577_e, Items.field_221578_f}).forEach(item -> ModRecipes.dissolver().input((Item)item).outputs(ModRecipes.set().addGroup(4.0, StringUtils.toStack("aluminum_oxide")).addGroup(2.0, StringUtils.toStack("iron")).addGroup(4.0, StringUtils.toStack("potassium_chloride")).addGroup(10.0, StringUtils.toStack("silicon_dioxide")).addGroup(1.5, StringUtils.toStack("indium")).addGroup(2.0, StringUtils.toStack("manganese")).addGroup(2.0, StringUtils.toStack("osmium")).addGroup(3.0, StringUtils.toStack("tin")).build()).build());
        ModRecipes.dissolver().input(Items.field_221958_gk).outputs(ModRecipes.set().rolls(2).addGroup(10.0, StringUtils.toStack("manganese", 2)).addGroup(5.0, StringUtils.toStack("aluminum_oxide")).addGroup(20.0, StringUtils.toStack("magnesium_oxide")).addGroup(2.0, StringUtils.toStack("potassium_chloride")).addGroup(10.0, StringUtils.toStack("silicon_dioxide", 2)).addGroup(20.0, StringUtils.toStack("sulfur", 2)).addGroup(10.0, StringUtils.toStack("iron_oxide")).addGroup(8.0, StringUtils.toStack("lead", 2)).addGroup(4.0, StringUtils.toStack("fluorine")).addGroup(4.0, StringUtils.toStack("bromine")).build()).build();
        Lists.newArrayList((Object[])new Item[]{Items.field_221579_g, Items.field_221580_h}).forEach(item -> ModRecipes.dissolver().input((Item)item).outputs(ModRecipes.set().addGroup(4.0, StringUtils.toStack("aluminum_oxide")).addGroup(3.0, StringUtils.toStack("iron")).addGroup(4.0, StringUtils.toStack("potassium_chloride")).addGroup(10.0, StringUtils.toStack("silicon_dioxide")).addGroup(2.0, StringUtils.toStack("platinum")).addGroup(4.0, StringUtils.toStack("calcium")).build()).build());
        ModRecipes.dissolver().input(Items.field_221574_b).outputs(ModRecipes.set().addGroup(20.0, ItemStack.field_190927_a).addGroup(2.0, StringUtils.toStack("aluminum")).addGroup(4.0, StringUtils.toStack("iron")).addGroup(1.5, StringUtils.toStack("gold")).addGroup(20.0, StringUtils.toStack("silicon_dioxide")).addGroup(0.5, StringUtils.toStack("dysprosium")).addGroup(1.25, StringUtils.toStack("zirconium")).addGroup(1.0, StringUtils.toStack("tungsten")).addGroup(1.0, StringUtils.toStack("nickel")).addGroup(1.0, StringUtils.toStack("gallium")).build()).build();
        ModRecipes.dissolver().input(Tags.Items.CHESTS_WOODEN).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("cellulose", 2)).build()).build();
        ModRecipes.dissolver().input(Items.field_221734_cc).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("cellulose")).build()).build();
        ModRecipes.dissolver().input(Items.field_221672_ax).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("protein", 2)).build()).build();
        ModRecipes.dissolver().input(Items.field_221916_fp).outputs(ModRecipes.set().relative(false).addGroup(25.0, StringUtils.toStack("cellulose")).build()).build();
        ModRecipes.dissolver().input(Items.field_151145_ak).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("silicon_dioxide", 3)).build()).build();
        ModRecipes.dissolver().input(Items.field_196130_bo).outputs(ModRecipes.set().relative(false).addGroup(100.0, StringUtils.toStack("caffeine")).addGroup(50.0, StringUtils.toStack("cellulose")).build()).build();
        ModRecipes.dissolver().input(Items.field_151034_e).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("sucrose"), StringUtils.toStack("cellulose")).build()).build();
        ModRecipes.dissolver().input(Items.field_221553_F).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("carbon", 32), StringUtils.toStack("sulfur", 8)).build()).build();
        ModRecipes.dissolver().input(Items.field_221896_ff).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("carbon", 72)).build()).build();
        ModRecipes.dissolver().input(Items.field_151044_h).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("carbon", 8)).build()).build();
        ModRecipes.dissolver().input(Items.field_196155_l).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("carbon", 8)).build()).build();
        ModRecipes.dissolver().input(ItemTags.field_202899_i).outputs(ModRecipes.set().relative(false).addGroup(12.0, StringUtils.toStack("cellulose")).build()).build();
        ModRecipes.dissolver().input(Tags.Items.SLIMEBALLS).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("protein", 2), StringUtils.toStack("sucrose", 2)).build()).setReversible(true).build();
        ModRecipes.dissolver().input(Items.field_221904_fj).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("protein", 18), StringUtils.toStack("sucrose", 18)).build()).build();
        ModRecipes.dissolver().input(Items.field_151055_y).outputs(ModRecipes.set().relative(false).addGroup(10.0, StringUtils.toStack("cellulose")).build()).build();
        ModRecipes.dissolver().input(Items.field_151079_bi).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("silicon", 16), StringUtils.toStack("mercury", 16), StringUtils.toStack("neodymium", 16)).build()).setReversible(true).build();
        ModRecipes.dissolver().input(Items.field_151014_N).outputs(ModRecipes.set().relative(false).addGroup(10.0, StringUtils.toStack("cellulose")).build()).build();
        ModRecipes.dissolver().input(Items.field_221691_cH).outputs(ModRecipes.set().addGroup(15.0, ItemStack.field_190927_a).addGroup(2.0, StringUtils.toStack("zinc_oxide")).addGroup(1.0, StringUtils.toStack("gold")).addGroup(1.0, StringUtils.toStack("phosphorus")).addGroup(3.0, StringUtils.toStack("sulfur")).addGroup(1.0, StringUtils.toStack("germanium")).addGroup(4.0, StringUtils.toStack("silicon")).build()).build();
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_196154_dH, Items.field_221818_ds})) {
            rolls = 1;
            if (item2 == Items.field_221818_ds) {
                rolls = 4;
            }
            ModRecipes.dissolver().input(item2).outputs(ModRecipes.set().rolls(rolls).addGroup(5.0, ItemStack.field_190927_a).addGroup(2.0, StringUtils.toStack("zinc_oxide")).addGroup(1.0, StringUtils.toStack("gold")).addGroup(1.0, StringUtils.toStack("phosphorus")).addGroup(4.0, StringUtils.toStack("sulfur")).addGroup(1.0, StringUtils.toStack("germanium")).addGroup(4.0, StringUtils.toStack("silicon")).build()).build();
        }
        ModRecipes.dissolver().input(Items.field_151070_bp).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("beta_carotene", 2), StringUtils.toStack("protein", 2)).build()).build();
        ModRecipes.dissolver().input(Items.field_151138_bX).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("iron", 64)).build()).build();
        ModRecipes.dissolver().input(Items.field_151136_bY).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("gold", 64)).build()).build();
        ModRecipes.dissolver().input(Items.field_151125_bZ).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("carbon", 2048)).build()).build();
        ModRecipes.dissolver().input(ItemTags.field_199904_a).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("protein"), StringUtils.toStack("triglyceride")).build()).build();
        ModRecipes.dissolver().input(ItemTags.field_200035_e).outputs(ModRecipes.set().relative(false).addGroup(66.66666666666666, StringUtils.toStack("protein"), StringUtils.toStack("triglyceride")).build()).build();
        ModRecipes.dissolver().input(Items.field_221844_ef).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("iron", 496)).build()).build();
        ModRecipes.dissolver().input(Items.field_222013_iM).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("iron", 32)).build()).build();
        ModRecipes.dissolver().input(Items.field_221805_eM).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("iron", 64)).build()).build();
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_151166_bC, Items.field_221733_dC, Items.field_221739_dF})) {
            multiplier = 1;
            boolean reversible = false;
            if (item2 == Items.field_151166_bC) {
                reversible = true;
            } else if (item2 == Items.field_221733_dC) {
                multiplier = 2;
            } else if (item2 == Items.field_221739_dF) {
                multiplier = 9;
            }
            ModRecipes.dissolver().input(item2).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("beryl", 8 * multiplier), StringUtils.toStack("chromium", 8 * multiplier), StringUtils.toStack("vanadium", 4 * multiplier)).build()).setReversible(reversible).build();
        }
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_151045_i, Items.field_221730_ca, Items.field_221732_cb})) {
            multiplier = 1;
            if (item2 == Items.field_221730_ca) {
                multiplier = 2;
            } else if (item2 == Items.field_221732_cb) {
                multiplier = 9;
            }
            ModRecipes.dissolver().input(item2).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("carbon", 512 * multiplier)).build()).build();
        }
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_221828_dx, Items.field_221830_dy})) {
            ModRecipes.dissolver().input(item2).outputs(ModRecipes.set().addGroup(50.0, StringUtils.toStack("mercury")).addGroup(5.0, StringUtils.toStack("neodymium")).addGroup(250.0, StringUtils.toStack("silicon_dioxide")).addGroup(50.0, StringUtils.toStack("lithium")).addGroup(2.0, StringUtils.toStack("thorium")).build()).build();
        }
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_221772_cv, Items.field_221770_cu})) {
            ModRecipes.dissolver().input(item2).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("water", 16)).build()).build();
        }
        ModRecipes.dissolver().input(ItemTags.field_219774_K).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("polyvinyl_chloride", 64), StringUtils.toStack("lead", 16), StringUtils.toStack("cadmium", 16)).build()).build();
        ModRecipes.dissolver().input(Items.field_221778_cy).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("carbon", 512), StringUtils.toStack("cellulose", 2)).build()).build();
        ModRecipes.dissolver().input(Tags.Blocks.DIRT).outputs(ModRecipes.set().addGroup(30.0, StringUtils.toStack("water")).addGroup(50.0, StringUtils.toStack("silicon_dioxide")).addGroup(10.0, StringUtils.toStack("cellulose")).addGroup(10.0, StringUtils.toStack("kaolinite")).build()).build();
        ModRecipes.dissolver().input(Items.field_221581_i).outputs(ModRecipes.set().addGroup(30.0, StringUtils.toStack("water")).addGroup(50.0, StringUtils.toStack("silicon_dioxide")).addGroup(10.0, StringUtils.toStack("cellulose")).addGroup(10.0, StringUtils.toStack("kaolinite")).build()).build();
        ModRecipes.dissolver().input(Tags.Blocks.GLASS).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("silicon_dioxide", 4)).build()).build();
        ModRecipes.dissolver().input(ItemTags.field_200037_g).outputs(ModRecipes.set().relative(false).addGroup(25.0, StringUtils.toStack("cellulose", 1)).build()).build();
        ModRecipes.dissolver().input(Items.field_221796_dh).outputs(ModRecipes.set().relative(false).addGroup(25.0, StringUtils.toStack("cellulose", 1)).build()).build();
        ModRecipes.dissolver().input(Items.field_221816_dr).outputs(ModRecipes.set().relative(false).addGroup(25.0, StringUtils.toStack("cellulose", 1)).build()).build();
        ModRecipes.dissolver().input(Items.field_221687_cF).outputs(ModRecipes.set().relative(false).addGroup(50.0, StringUtils.toStack("cucurbitacin", 1)).build()).build();
        ModRecipes.dissolver().input(Items.field_151128_bU).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("barium", 16), StringUtils.toStack("silicon_dioxide", 32)).build()).setReversible(true).build();
        ModRecipes.dissolver().input(Items.field_221860_en).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("barium", 32), StringUtils.toStack("silicon_dioxide", 64)).build()).build();
        ModRecipes.dissolver().input(Tags.Blocks.STORAGE_BLOCKS_QUARTZ).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("barium", 64), StringUtils.toStack("silicon_dioxide", 128)).build()).build();
        ModRecipes.dissolver().input(Items.field_221692_bh).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("cellulose"), StringUtils.toStack("psilocybin")).build()).setReversible(true).build();
        ModRecipes.dissolver().input(Items.field_221694_bi).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("psilocybin"), StringUtils.toStack("cellulose")).build()).setReversible(true).build();
        ModRecipes.dissolver().input(Items.field_221693_cI).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("thulium"), StringUtils.toStack("silicon_dioxide", 4)).build()).setReversible(true).build();
        ModRecipes.dissolver().input(Items.field_222065_kN).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("sucrose")).build()).build();
        ModRecipes.dissolver().input(Items.field_221548_A).outputs(ModRecipes.set().relative(false).addGroup(100.0, StringUtils.toStack("silicon_dioxide", 4)).addGroup(1.0, StringUtils.toStack("gold")).build()).build();
        ModRecipes.dissolver().input(Items.field_221549_B).outputs(ModRecipes.set().relative(false).addGroup(100.0, StringUtils.toStack("silicon_dioxide", 4)).addGroup(10.0, StringUtils.toStack("iron_oxide")).build()).build();
        ModRecipes.dissolver().input(Items.field_221946_ge).outputs(ModRecipes.set().rolls(4).relative(false).addGroup(100.0, StringUtils.toStack("silicon_dioxide", 4)).addGroup(10.0, StringUtils.toStack("iron_oxide")).build()).build();
        ModRecipes.dissolver().input(Items.field_151102_aT).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("sucrose")).build()).build();
        ModRecipes.dissolver().input(Items.field_151016_H).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("potassium_nitrate", 2), StringUtils.toStack("sulfur", 8), StringUtils.toStack("carbon", 8)).build()).setReversible(true).build();
        ModRecipes.dissolver().input(Items.field_151065_br).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("germanium", 8), StringUtils.toStack("carbon", 8), StringUtils.toStack("sulfur", 8)).build()).setReversible(true).build();
        ModRecipes.dissolver().input(Items.field_151075_bm).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("cellulose"), StringUtils.toStack("germanium", 4), StringUtils.toStack("selenium", 4)).build()).setReversible(true).build();
        ModRecipes.dissolver().input(Items.field_221960_gl).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("cellulose", 9), StringUtils.toStack("germanium", 36), StringUtils.toStack("selenium", 36)).build()).build();
        ModRecipes.dissolver().input(Items.field_151114_aO).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("phosphorus", 4)).build()).setReversible(true).build();
        ModRecipes.dissolver().input(Items.field_151114_aO).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("phosphorus", 16)).build()).build();
        ModRecipes.dissolver().input(Items.field_221790_de).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("iron", 6)).build()).build();
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_196128_bn, Items.field_221654_ao, Items.field_221652_an})) {
            multiplier = 1;
            if (item2 == Items.field_221654_ao) {
                multiplier = 9;
            } else if (item2 == Items.field_221652_an) {
                multiplier = 4;
            }
            ModRecipes.dissolver().input(item2).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("sodium", 6 * multiplier), StringUtils.toStack("calcium", 2 * multiplier), StringUtils.toStack("aluminum", 6 * multiplier), StringUtils.toStack("silicon", 6 * multiplier), StringUtils.toStack("oxygen", 24 * multiplier), StringUtils.toStack("sulfur", 2 * multiplier)).build()).setReversible(true).build();
        }
        ModRecipes.dissolver().input(Items.field_151007_F).outputs(ModRecipes.set().relative(false).addGroup(50.0, StringUtils.toStack("protein")).build()).build();
        ModRecipes.dissolver().input((Item)Ref.condensedMilk).outputs(ModRecipes.set().relative(false).addGroup(40.0, StringUtils.toStack("calcium", 4)).addGroup(20.0, StringUtils.toStack("protein")).addGroup(20.0, StringUtils.toStack("sucrose")).build()).build();
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_151015_O, Items.field_221807_eN})) {
            rolls = 1;
            if (item2 == Items.field_221807_eN) {
                rolls = 9;
            }
            ModRecipes.dissolver().input(item2).outputs(ModRecipes.set().relative(false).rolls(rolls).addGroup(5.0, StringUtils.toStack("starch")).addGroup(25.0, StringUtils.toStack("cellulose")).build()).build();
        }
        ModRecipes.dissolver().input(Items.field_221794_dg).outputs(ModRecipes.set().relative(false).addGroup(50.0, StringUtils.toStack("cucurbitacin")).addGroup(1.0, StringUtils.toStack("water", 4), StringUtils.toStack("sucrose", 2)).build()).build();
        ModRecipes.dissolver().input(Items.field_221774_cw).outputs(ModRecipes.set().relative(false).addGroup(100.0, StringUtils.toStack("cellulose")).addGroup(50.0, StringUtils.toStack("mescaline")).build()).setReversible(true).build();
        ModRecipes.dissolver().input(Items.field_221550_C).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("silicon_dioxide")).build()).build();
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_151174_bG, Items.field_151168_bH})) {
            ModRecipes.dissolver().input(item2).outputs(ModRecipes.set().relative(false).addGroup(10.0, StringUtils.toStack("starch")).addGroup(25.0, StringUtils.toStack("potassium", 5)).build()).build();
        }
        ModRecipes.dissolver().input(Items.field_151137_ax).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("iron_oxide"), StringUtils.toStack("strontium_carbonate")).build()).setReversible(true).build();
        ModRecipes.dissolver().input(Items.field_221762_cq).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("iron_oxide", 4), StringUtils.toStack("strontium_carbonate", 4)).build()).build();
        ModRecipes.dissolver().input(Items.field_221858_em).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("iron_oxide", 9), StringUtils.toStack("strontium_carbonate", 9)).build()).build();
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_151082_bd, Items.field_151157_am, Items.field_179561_bm, Items.field_151157_am, Items.field_151083_be, Items.field_179557_bn, Items.field_151076_bf, Items.field_151077_bg, Items.field_179558_bo, Items.field_179559_bp})) {
            ModRecipes.dissolver().input(item2).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("protein", 4)).build()).build();
        }
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_196086_aW, Items.field_196102_ba, Items.field_196088_aY})) {
            ModRecipes.dissolver().input(item2).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("protein", 4), StringUtils.toStack("selenium", 2)).build()).build();
        }
        for (Item item2 : Lists.newArrayList((Object[])new Item[]{Items.field_196087_aX, Items.field_196104_bb})) {
            ModRecipes.dissolver().input(item2).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("protein", 4), StringUtils.toStack("selenium", 4)).build()).build();
        }
        ModRecipes.dissolver().input(Items.field_196089_aZ).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("protein", 4), StringUtils.toStack("potassium_cyanide", 4)).build()).build();
        ModRecipes.dissolver().input(Items.field_221646_ak).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("kaolinite", 8), StringUtils.toStack("calcium_carbonate", 8)).build()).setReversible(true).build();
        ModRecipes.dissolver().input(Items.field_151116_aA).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("protein", 3)).build()).build();
        ModRecipes.dissolver().input(Items.field_151078_bh).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("protein", 3)).build()).build();
        ModRecipes.dissolver().input(Items.field_151008_G).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("protein", 2)).build()).build();
        ModRecipes.dissolver().input(Items.field_196106_bc).outputs(ModRecipes.set().relative(false).addGroup(50.0, StringUtils.toStack("hydroxylapatite")).build()).build();
        ModRecipes.dissolver().input(Items.field_221964_gn).outputs(ModRecipes.set().rolls(9).relative(false).addGroup(50.0, StringUtils.toStack("hydroxylapatite")).build()).build();
        ModRecipes.dissolver().input(Items.field_151110_aK).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("calcium_carbonate", 8), StringUtils.toStack("protein", 2)).build()).setReversible(true).build();
        ModRecipes.dissolver().input((Item)Ref.mineralSalt).outputs(ModRecipes.set().addGroup(60.0, StringUtils.toStack("sodium_chloride")).addGroup(5.0, StringUtils.toStack("lithium")).addGroup(10.0, StringUtils.toStack("potassium_chloride")).addGroup(10.0, StringUtils.toStack("magnesium")).addGroup(5.0, StringUtils.toStack("iron")).addGroup(4.0, StringUtils.toStack("copper")).addGroup(2.0, StringUtils.toStack("zinc")).build()).build();
        ModRecipes.dissolver().input(Items.field_151172_bF).outputs(ModRecipes.set().relative(false).addGroup(20.0, StringUtils.toStack("beta_carotene")).build()).build();
        ModRecipes.dissolver().input(Tags.Items.DYES_RED).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("mercury_sulfide", 4)).build()).setReversible(true).build();
        ModRecipes.dissolver().input(Tags.Items.DYES_PINK).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("arsenic_sulfide", 4)).build()).setReversible(true).build();
        ModRecipes.dissolver().input(Tags.Items.DYES_GREEN).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("nickel_chloride", 4)).build()).setReversible(true).build();
        ModRecipes.dissolver().input(Tags.Items.DYES_LIME).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("cadmium_sulfide", 2), StringUtils.toStack("chromium_oxide", 2)).build()).setReversible(true).build();
        ModRecipes.dissolver().input(Tags.Items.DYES_PURPLE).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("potassium_permanganate", 4)).build()).setReversible(true).build();
        ModRecipes.dissolver().input(Tags.Items.DYES_YELLOW).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("lead_iodide", 4)).build()).setReversible(true).build();
        ModRecipes.dissolver().input(Tags.Items.DYES_ORANGE).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("potassium_dichromate", 4)).build()).setReversible(true).build();
        ModRecipes.dissolver().input(Tags.Items.DYES_BLACK).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("titanium_oxide", 4)).build()).setReversible(true).build();
        ModRecipes.dissolver().input(Tags.Items.DYES_GRAY).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("barium_sulfate", 4)).build()).setReversible(true).build();
        ModRecipes.dissolver().input(Tags.Items.DYES_MAGENTA).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("han_purple", 4)).build()).setReversible(true).build();
        ModRecipes.dissolver().input(Tags.Items.DYES_LIGHT_BLUE).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("cobalt_aluminate", 2), StringUtils.toStack("antimony_trioxide", 2)).build()).setReversible(true).build();
        ModRecipes.dissolver().input(Tags.Items.DYES_LIGHT_GRAY).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("magnesium_sulfate", 4)).build()).setReversible(true).build();
        ModRecipes.dissolver().input(Tags.Items.DYES_CYAN).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("copper_chloride", 4)).build()).setReversible(true).build();
        ModRecipes.dissolver().input(Items.field_196183_dw).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("hydroxylapatite", 8), StringUtils.toStack("mendelevium", 32)).build()).build();
        Lists.newArrayList((Object[])new Item[]{Items.field_221665_bU, Items.field_221667_bV}).forEach(item -> ModRecipes.dissolver().input((Item)item).outputs(ModRecipes.set().relative(false).addGroup(100.0, StringUtils.toStack("silicon_dioxide", 4)).addGroup(50.0, StringUtils.toStack("lutetium")).build()).build());
        ModRecipes.dissolver().input(Items.field_151119_aD).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("kaolinite", 1)).build()).build();
        ModRecipes.dissolver().input(Items.field_221776_cx).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("kaolinite", 4)).build()).build();
        ModRecipes.dissolver().input(Items.field_185164_cV).outputs(ModRecipes.set().relative(false).addGroup(100.0, StringUtils.toStack("sucrose")).addGroup(50.0, StringUtils.toStack("iron_oxide")).build()).build();
        ModRecipes.dissolver().input(Items.field_151103_aS).outputs(ModRecipes.set().relative(false).addGroup(50.0, StringUtils.toStack("hydroxylapatite", 3)).build()).setReversible(true).build();
        ModRecipes.dissolver().input(Items.field_221655_bP).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack("magnesium_oxide", 8), StringUtils.toStack("potassium_chloride", 8), StringUtils.toStack("aluminum_oxide", 8), StringUtils.toStack("silicon_dioxide", 24)).build()).setReversible(true).build();
        for (CompoundItem compound : CompoundRegistry.compounds) {
            ModRecipes.dissolver().input((Item)compound).outputs(ModRecipes.set().addGroup(1.0, compound.getComponentStacks().toArray(new ItemStack[0])).build()).build();
        }
        for (DissolverTagData data : metalTagData) {
            for (String element : metals) {
                Tag<Item> tag = ModRecipes.tag(data.prefix + "/" + element);
                if (tag.func_199885_a().isEmpty()) continue;
                ModRecipes.dissolver().input(tag).outputs(ModRecipes.set().addGroup(1.0, StringUtils.toStack(element, data.quantity)).build()).build();
            }
        }
    }

    private static Tag<Item> tag(String name) {
        return new ItemTags.Wrapper(new ResourceLocation("forge", name));
    }

    private static void initCombinerRecipes() {
        ModRecipes.combiner(Items.field_196155_l, Lists.newArrayList((Object[])new Object[]{null, null, StringUtils.toStack("carbon", 8)}));
        ModRecipes.combiner(Items.field_151044_h, Lists.newArrayList((Object[])new Object[]{null, StringUtils.toStack("carbon", 8)}));
        ModRecipes.combiner(Items.field_221695_cJ, Lists.newArrayList((Object[])new Object[]{null, StringUtils.toStack("phosphorus", 16)}));
        ModRecipes.combiner(Items.field_151045_i, Lists.newArrayList((Object[])new Object[]{StringUtils.toStack("carbon", 64), StringUtils.toStack("carbon", 64), StringUtils.toStack("carbon", 64), StringUtils.toStack("carbon", 64), null, StringUtils.toStack("carbon", 64), StringUtils.toStack("carbon", 64), StringUtils.toStack("carbon", 64), StringUtils.toStack("carbon", 64)}));
        ModRecipes.combiner(Items.field_221548_A, Lists.newArrayList((Object[])new Object[]{null, null, null, null, null, null, null, null, StringUtils.toStack("silicon_dioxide", 4)}));
        ModRecipes.combiner(Items.field_221585_m, 2, Lists.newArrayList((Object[])new Object[]{StringUtils.toStack("silicon_dioxide")}));
        ModRecipes.combiner(Items.field_221574_b, Lists.newArrayList((Object[])new Object[]{null, StringUtils.toStack("silicon_dioxide")}));
        ModRecipes.combiner(Items.field_221776_cx, Lists.newArrayList((Object[])new Object[]{null, StringUtils.toStack("kaolinite", 4)}));
        ModRecipes.combiner(Items.field_221582_j, 4, Lists.newArrayList((Object[])new Object[]{StringUtils.toStack("water"), StringUtils.toStack("cellulose"), StringUtils.toStack("kaolinite")}));
        ModRecipes.combiner(Items.field_221814_dq, 4, Lists.newArrayList((Object[])new Object[]{null, null, null, null, null, StringUtils.toStack("psilocybin"), StringUtils.toStack("water"), StringUtils.toStack("cellulose"), StringUtils.toStack("kaolinite")}));
        ModRecipes.combiner(Items.field_151008_G, Lists.newArrayList((Object[])new Object[]{null, null, null, null, null, StringUtils.toStack("protein", 2)}));
        ModRecipes.combiner(Items.field_151070_bp, Lists.newArrayList((Object[])new Object[]{null, StringUtils.toStack("beta_carotene", 2), StringUtils.toStack("protein", 2)}));
        ModRecipes.combiner(Items.field_221646_ak, Lists.newArrayList((Object[])new Object[]{null, StringUtils.toStack("calcium_carbonate", 8), StringUtils.toStack("kaolinite", 8)}));
        ModRecipes.combiner(Items.field_221674_ay, 4, Lists.newArrayList((Object[])new Object[]{null, null, null, StringUtils.toStack("water"), StringUtils.toStack("cellulose"), StringUtils.toStack("kaolinite")}));
        ModRecipes.combiner(Items.field_221550_C, Lists.newArrayList((Object[])new Object[]{null, null, StringUtils.toStack("silicon_dioxide")}));
        ModRecipes.combiner(Items.field_151131_as, Lists.newArrayList((Object[])new Object[]{null, null, null, null, StringUtils.toStack("water", 16), null, null, Items.field_151133_ar, null}));
        ModRecipes.combiner(Items.field_151117_aB, Lists.newArrayList((Object[])new Object[]{null, null, null, StringUtils.toStack("protein", 2), StringUtils.toStack("water", 16), StringUtils.toStack("sucrose"), null, Items.field_151133_ar, null}));
        ModRecipes.combiner(Items.field_221858_em, Lists.newArrayList((Object[])new Object[]{null, null, null, StringUtils.toStack("iron_oxide", 9), StringUtils.toStack("strontium_carbonate", 9)}));
        ModRecipes.combiner(Items.field_151007_F, 4, Lists.newArrayList((Object[])new Object[]{null, StringUtils.toStack("protein", 2)}));
        ModRecipes.combiner(Items.field_221603_aE, Lists.newArrayList((Object[])new Object[]{null, null, null, null, null, null, StringUtils.toStack("protein"), StringUtils.toStack("triglyceride")}));
        ModRecipes.combiner(Items.field_151172_bF, Lists.newArrayList((Object[])new Object[]{null, null, null, StringUtils.toStack("cellulose"), StringUtils.toStack("beta_carotene")}));
        ModRecipes.combiner(Items.field_222065_kN, Lists.newArrayList((Object[])new Object[]{null, null, null, StringUtils.toStack("cellulose"), StringUtils.toStack("sucrose")}));
        ModRecipes.combiner(Items.field_221575_c, Lists.newArrayList((Object[])new Object[]{null, null, null, StringUtils.toStack("silicon_dioxide")}));
        ModRecipes.combiner(Items.field_221577_e, Lists.newArrayList((Object[])new Object[]{null, null, null, null, StringUtils.toStack("silicon_dioxide")}));
        ModRecipes.combiner(Items.field_221579_g, Lists.newArrayList((Object[])new Object[]{null, null, null, null, null, StringUtils.toStack("silicon_dioxide")}));
        ModRecipes.combiner(Items.field_151145_ak, Lists.newArrayList((Object[])new Object[]{null, null, null, null, null, null, null, StringUtils.toStack("silicon_dioxide", 3)}));
        ModRecipes.combiner(Items.field_151174_bG, Lists.newArrayList((Object[])new Object[]{StringUtils.toStack("starch"), StringUtils.toStack("potassium", 4)}));
        ModRecipes.combiner(Items.field_151034_e, Lists.newArrayList((Object[])new Object[]{null, StringUtils.toStack("cellulose"), null, null, StringUtils.toStack("sucrose")}));
        ModRecipes.combiner(Items.field_151014_N, Lists.newArrayList((Object[])new Object[]{null, StringUtils.toStack("triglyceride"), null, StringUtils.toStack("sucrose")}));
        ModRecipes.combiner(Items.field_151080_bb, Lists.newArrayList((Object[])new Object[]{null, StringUtils.toStack("triglyceride"), null, null, StringUtils.toStack("sucrose")}));
        ModRecipes.combiner(Items.field_151081_bc, Lists.newArrayList((Object[])new Object[]{null, StringUtils.toStack("triglyceride"), null, null, null, StringUtils.toStack("sucrose")}));
        ModRecipes.combiner(Items.field_185163_cU, Lists.newArrayList((Object[])new Object[]{null, StringUtils.toStack("triglyceride"), null, null, null, null, StringUtils.toStack("sucrose"), StringUtils.toStack("iron_oxide")}));
        ModRecipes.combiner(Items.field_185164_cV, Lists.newArrayList((Object[])new Object[]{null, StringUtils.toStack("sucrose"), StringUtils.toStack("iron_oxide")}));
        ModRecipes.combiner(Items.field_221592_t, Lists.newArrayList((Object[])new Object[]{StringUtils.toStack("oxygen"), StringUtils.toStack("cellulose", 2)}));
        ModRecipes.combiner(Items.field_221593_u, Lists.newArrayList((Object[])new Object[]{null, StringUtils.toStack("oxygen"), StringUtils.toStack("cellulose", 2)}));
        ModRecipes.combiner(Items.field_221595_w, Lists.newArrayList((Object[])new Object[]{null, null, StringUtils.toStack("oxygen"), StringUtils.toStack("cellulose", 2)}));
        ModRecipes.combiner(Items.field_221596_x, Lists.newArrayList((Object[])new Object[]{null, null, null, StringUtils.toStack("oxygen"), StringUtils.toStack("cellulose", 2)}));
        ModRecipes.combiner(Items.field_221597_y, Lists.newArrayList((Object[])new Object[]{null, null, null, null, StringUtils.toStack("oxygen"), StringUtils.toStack("cellulose", 2)}));
        ModRecipes.combiner(Items.field_221594_v, Lists.newArrayList((Object[])new Object[]{null, null, null, null, null, StringUtils.toStack("oxygen"), StringUtils.toStack("cellulose", 2)}));
        ModRecipes.combiner(Items.field_221554_G, Lists.newArrayList((Object[])new Object[]{StringUtils.toStack("cellulose")}));
        ModRecipes.combiner(Items.field_221555_H, Lists.newArrayList((Object[])new Object[]{null, StringUtils.toStack("cellulose")}));
        ModRecipes.combiner(Items.field_221557_J, Lists.newArrayList((Object[])new Object[]{null, null, StringUtils.toStack("cellulose")}));
        ModRecipes.combiner(Items.field_221558_K, Lists.newArrayList((Object[])new Object[]{null, null, null, StringUtils.toStack("cellulose")}));
        ModRecipes.combiner(Items.field_221559_L, Lists.newArrayList((Object[])new Object[]{null, null, null, null, StringUtils.toStack("cellulose")}));
        ModRecipes.combiner(Items.field_221556_I, Lists.newArrayList((Object[])new Object[]{null, null, null, null, null, StringUtils.toStack("cellulose")}));
        ModRecipes.combiner(Items.field_151126_ay, Lists.newArrayList((Object[])new Object[]{null, null, null, null, null, null, StringUtils.toStack("water", 4)}));
        ModRecipes.combiner(Items.field_221768_ct, Lists.newArrayList((Object[])new Object[]{null, null, null, null, null, null, null, StringUtils.toStack("water", 16)}));
        ModRecipes.combiner(Items.field_221770_cu, Lists.newArrayList((Object[])new Object[]{null, null, null, null, null, null, null, null, StringUtils.toStack("water", 16)}));
        ModRecipes.combiner(Items.field_196106_bc, 3, Lists.newArrayList((Object[])new Object[]{null, null, StringUtils.toStack("hydroxylapatite", 2)}));
        ModRecipes.combiner(Items.field_151116_aA, Lists.newArrayList((Object[])new Object[]{null, null, null, null, StringUtils.toStack("protein", 3)}));
        ModRecipes.combiner(Items.field_151078_bh, Lists.newArrayList((Object[])new Object[]{null, null, null, null, null, null, null, StringUtils.toStack("protein", 3)}));
        ModRecipes.combiner(Items.field_151156_bN, Lists.newArrayList((Object[])new Object[]{StringUtils.toStack("lutetium", 64), StringUtils.toStack("hydrogen", 64), StringUtils.toStack("titanium", 64), StringUtils.toStack("hydrogen", 64), StringUtils.toStack("hydrogen", 64), StringUtils.toStack("hydrogen", 64), StringUtils.toStack("dysprosium", 64), StringUtils.toStack("hydrogen", 64), StringUtils.toStack("mendelevium", 64)}));
        for (DissolverRecipe recipe : dissolverRecipes) {
            if (!recipe.reversible) continue;
            List<Object> outputs = recipe.outputs.toStackList().stream().map(ItemStack::func_77946_l).collect(Collectors.toList());
            combinerRecipes.add(new CombinerRecipe(recipe.input.func_193365_a()[0].func_77946_l(), outputs));
        }
        for (CompoundItem compound : CompoundRegistry.compounds) {
            ArrayList<Object> inputs = new ArrayList<Object>();
            for (int i = 0; i < compound.shiftedSlots; ++i) {
                inputs.add(ItemStack.field_190927_a);
            }
            for (ItemStack component : compound.getComponentStacks()) {
                inputs.add(component.func_77946_l());
            }
            combinerRecipes.add(new CombinerRecipe(new ItemStack((IItemProvider)compound), inputs));
        }
        for (String metal : metals) {
            Tag<Item> tag = ModRecipes.tag("ingots/" + metal);
            if (tag.func_199885_a().isEmpty()) continue;
            combinerRecipes.add(new CombinerRecipe(new ItemStack((IItemProvider)tag.func_199885_a().iterator().next()), Lists.newArrayList((Object[])new Object[]{StringUtils.toStack(metal, 16)})));
        }
    }

    private static void initAtomizerRecipes() {
        atomizerRecipes.add(new AtomizerRecipe(true, new FluidStack((Fluid)Fluids.field_204546_a, 500), StringUtils.toStack("water", 8)));
    }

    private static void initLiquifierRecipes() {
        for (AtomizerRecipe recipe : atomizerRecipes) {
            liquifierRecipes.add(new LiquifierRecipe(recipe.output, recipe.input));
        }
    }

    private static void initFissionRecipes() {
        for (int i = 2; i <= 118; ++i) {
            int output2;
            int output1 = i % 2 == 0 ? i / 2 : i / 2 + 1;
            int n = output2 = i % 2 == 0 ? 0 : i / 2;
            if (ElementRegistry.elements.get((Object)output1) == null || output2 != 0 && ElementRegistry.elements.get((Object)output2) == null) continue;
            fissionRecipes.add(new FissionRecipe(i, output1, output2));
        }
    }

    public static DissolverRecipe.Builder dissolver() {
        return new DissolverRecipe.Builder();
    }

    public static void combiner(Item output, List<Object> inputs) {
        ModRecipes.combiner(output, 1, inputs);
    }

    public static void combiner(Item output, int quantity, List<Object> inputs) {
        combinerRecipes.add(new CombinerRecipe(new ItemStack((IItemProvider)output, quantity), inputs));
    }

    public static ProbabilitySet.Builder set() {
        return new ProbabilitySet.Builder();
    }
}

