/*
 * Decompiled with CFR 0.152.
 */
package al132.alchemistry.recipes;

import al132.alchemistry.Ref;
import al132.alchemistry.recipes.ModRecipes;
import al132.alchemistry.utils.IItemHandlerUtils;
import al132.alchemistry.utils.StackUtils;
import al132.alib.tiles.CustomStackHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.items.IItemHandler;

public class CombinerRecipe {
    private final Ingredient output;
    public final List<ItemStack> inputs = new ArrayList<ItemStack>();
    public final Set<Integer> nonEmptyIndices = new HashSet<Integer>();

    public CombinerRecipe(Ingredient output, List<Object> inObjs) {
        this.output = output;
        for (int i = 0; i < 9; ++i) {
            Object temp = inObjs.size() > i ? inObjs.get(i) : null;
            if (temp instanceof ItemStack) {
                this.inputs.add(((ItemStack)temp).func_77946_l());
            } else if (temp instanceof Item) {
                this.inputs.add(new ItemStack((IItemProvider)((Item)temp)));
            } else if (temp instanceof Block) {
                this.inputs.add(new ItemStack((IItemProvider)((Block)temp)));
            } else {
                this.inputs.add(ItemStack.field_190927_a);
            }
            if (this.inputs.get(i).func_190926_b()) continue;
            this.nonEmptyIndices.add(i);
        }
        assert (this.inputs.size() == 9);
    }

    public ItemStack getOutput() {
        return this.output.func_193365_a()[0];
    }

    public List<ItemStack> getEmptyStrippedInputs() {
        return this.inputs.stream().filter(x -> !x.func_190926_b()).collect(Collectors.toList());
    }

    public static CombinerRecipe matchInputs(IItemHandler handler) {
        return CombinerRecipe.matchInputs(IItemHandlerUtils.toStackList(handler));
    }

    private static CombinerRecipe matchInputs(List<ItemStack> inputStacks) {
        block0: for (CombinerRecipe recipe : ModRecipes.combinerRecipes) {
            boolean matchingStacks = false;
            for (int index = 0; index < recipe.inputs.size(); ++index) {
                ItemStack recipeStack = recipe.inputs.get(index);
                ItemStack inputStack = inputStacks.get(index);
                if ((inputStack.func_77973_b() != Ref.slotFiller && !inputStack.func_190926_b() || !recipeStack.func_190926_b()) && (!StackUtils.areStacksEqualIgnoreQuantity(inputStack, recipeStack) || inputStack.func_190916_E() < recipeStack.func_190916_E() || inputStack.func_190926_b() || recipeStack.func_190926_b())) continue block0;
            }
            return recipe;
        }
        return null;
    }

    public boolean matchesHandlerStacks(CustomStackHandler handler) {
        int matchingStacks = 0;
        for (int index = 0; index < this.inputs.size(); ++index) {
            ItemStack recipeStack = this.inputs.get(index);
            ItemStack handlerStack = handler.getStackInSlot(index);
            if ((handlerStack.func_77973_b() == Ref.slotFiller || handlerStack.func_190926_b()) && recipeStack.func_190926_b()) {
                ++matchingStacks;
                continue;
            }
            if (handlerStack.func_190926_b() || recipeStack.func_190926_b() || !StackUtils.areStacksEqualIgnoreQuantity(handlerStack, recipeStack) || handlerStack.func_190916_E() < recipeStack.func_190916_E()) continue;
            ++matchingStacks;
        }
        return matchingStacks == 9;
    }

    public static CombinerRecipe matchOutput(ItemStack stack) {
        return ModRecipes.combinerRecipes.stream().filter(it -> it.getOutput().func_77973_b() == stack.func_77973_b()).filter(it -> ItemStack.func_77989_b((ItemStack)it.getOutput(), (ItemStack)stack)).findFirst().orElse(null);
    }
}

