/*
 * Decompiled with CFR 0.152.
 */
package al132.alib.tiles;

import al132.alib.tiles.CustomEnergyStorage;
import al132.alib.tiles.EnergyTile;
import al132.alib.tiles.FluidTile;
import al132.alib.tiles.InventoryTile;
import al132.alib.utils.Utils;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class ABaseTile
extends TileEntity
implements INamedContainerProvider {
    public IEnergyStorage energy;
    public LazyOptional<IEnergyStorage> energyHolder;

    public ABaseTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        if (this instanceof EnergyTile) {
            this.energy = ((EnergyTile)((Object)this)).initEnergy();
            this.energyHolder = LazyOptional.of(() -> this.energy);
        }
    }

    public boolean onBlockActivated(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand) {
        AtomicBoolean didInteract = new AtomicBoolean(false);
        if (this instanceof FluidTile) {
            ItemStack heldItem = player.func_184586_b(hand);
            heldItem.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(x -> {
                didInteract.set(FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (World)world, (BlockPos)pos, null));
                this.func_70296_d();
            });
        }
        return didInteract.get();
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (this instanceof EnergyTile) {
            int max = ((EnergyTile)((Object)this)).getEnergy().getMaxEnergyStored();
            this.energy = ((EnergyTile)((Object)this)).initEnergy();
            if (this.energy instanceof CustomEnergyStorage) {
                ((CustomEnergyStorage)this.energy).receiveEnergyInternal(compound.func_74762_e("energy"), false);
            } else {
                this.energy.receiveEnergy(compound.func_74762_e("energy"), false);
            }
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        if (this instanceof EnergyTile) {
            compound.func_74768_a("energy", this.energy.getEnergyStored());
        }
        return super.func_189515_b(compound);
    }

    public void markDirtyGUI() {
        this.func_70296_d();
        if (this.field_145850_b != null) {
            BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 6);
        }
    }

    public void markDirtyClient() {
        this.func_70296_d();
        if (this.field_145850_b != null) {
            BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT updateTag = super.func_189517_E_();
        this.func_189515_b(updateTag);
        return updateTag;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbtTag = new CompoundNBT();
        this.func_189515_b(nbtTag);
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_230337_a_(null, packet.func_148857_g());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY && this instanceof EnergyTile) {
            return this.energyHolder.cast();
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this instanceof InventoryTile) {
            return ((InventoryTile)((Object)this)).getExternalInventory().cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this instanceof FluidTile) {
            return ((FluidTile)((Object)this)).getFluidHandler().cast();
        }
        return super.getCapability(cap, side);
    }

    public ITextComponent func_145748_c_() {
        String regName = this.func_200662_C().getRegistryName().func_110623_a().replaceAll("_", " ");
        return new StringTextComponent(Utils.capitalizeAllWords(regName));
    }
}

