/*
 * Decompiled with CFR 0.152.
 */
package al132.alchemistry.blocks.dissolver;

import al132.alchemistry.Config;
import al132.alchemistry.Ref;
import al132.alchemistry.blocks.AlchemistryBaseTile;
import al132.alchemistry.blocks.dissolver.DissolverContainer;
import al132.alchemistry.recipes.DissolverRecipe;
import al132.alchemistry.utils.StackUtils;
import al132.alib.tiles.ABaseTile;
import al132.alib.tiles.CustomEnergyStorage;
import al132.alib.tiles.CustomStackHandler;
import al132.alib.tiles.EnergyTile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.NonNullList;
import net.minecraftforge.energy.IEnergyStorage;

public class DissolverTile
extends AlchemistryBaseTile
implements EnergyTile {
    private boolean outputSuccessful = true;
    private ItemStack outputThisTick = ItemStack.field_190927_a;
    private DissolverRecipe currentRecipe = null;
    private NonNullList<ItemStack> outputBuffer = NonNullList.func_191196_a();

    public DissolverTile() {
        super(Ref.dissolverTile);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!(this.getInput().getStackInSlot(0).func_190926_b() && this.outputBuffer.isEmpty() || !this.canProcess())) {
            this.process();
        }
    }

    public boolean canProcess() {
        return this.energy.getEnergyStored() >= (Integer)Config.DISSOLVER_ENERGY_PER_TICK.get() && (this.currentRecipe != null || !this.outputBuffer.isEmpty());
    }

    public void process() {
        int i;
        if (this.outputBuffer.isEmpty()) {
            this.outputBuffer = this.currentRecipe.outputs.calculateOutput();
            this.getInput().decrementSlot(0, this.currentRecipe.getInput().func_193365_a()[0].func_190916_E());
        }
        if (this.outputSuccessful) {
            this.outputThisTick = this.outputBuffer.size() > 0 ? ((ItemStack)this.outputBuffer.get(0)).func_77979_a(((Integer)Config.DISSOLVER_SPEED.get()).intValue()) : ItemStack.field_190927_a;
            if (this.outputBuffer.size() > 0 && ((ItemStack)this.outputBuffer.get(0)).func_190926_b()) {
                this.outputBuffer.remove(0);
            }
            this.outputSuccessful = false;
        }
        for (i = 0; i < this.getOutput().getSlots(); ++i) {
            if (!StackUtils.canStacksMerge(this.outputThisTick, this.getOutput().getStackInSlot(i), false)) continue;
            this.getOutput().setOrIncrement(i, this.outputThisTick);
            this.outputSuccessful = true;
            break;
        }
        if (!this.outputSuccessful) {
            for (i = 0; i < this.getOutput().getSlots(); ++i) {
                if (!StackUtils.canStacksMerge(this.outputThisTick, this.getOutput().getStackInSlot(i), true)) continue;
                this.getOutput().setOrIncrement(i, this.outputThisTick);
                this.outputSuccessful = true;
                break;
            }
        }
        if (this.outputSuccessful) {
            this.energy.extractEnergy(((Integer)Config.DISSOLVER_ENERGY_PER_TICK.get()).intValue(), false);
            this.outputThisTick = ItemStack.field_190927_a;
        }
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInv, PlayerEntity player) {
        return new DissolverContainer(i, this.field_145850_b, this.field_174879_c, playerInv, player);
    }

    public CustomStackHandler initInput() {
        return new CustomStackHandler((ABaseTile)this, 1){

            @Nonnull
            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (!this.getStackInSlot(slot).func_190926_b()) {
                    return super.isItemValid(slot, stack);
                }
                if (DissolverRecipe.match(stack, false) != null) {
                    return super.isItemValid(slot, stack);
                }
                return false;
            }

            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                DissolverTile.this.updateRecipe();
                DissolverTile.this.markDirtyGUI();
            }
        };
    }

    public CustomStackHandler initOutput() {
        return new CustomStackHandler((ABaseTile)this, 10){

            @Nonnull
            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return false;
            }
        };
    }

    public void updateRecipe() {
        this.currentRecipe = DissolverRecipe.match(this.getInput().getStackInSlot(0), true);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.outputSuccessful = compound.func_74767_n("OutputSuccessful");
        ItemStackHelper.func_191283_b((CompoundNBT)compound.func_74775_l("OutputBuffer"), this.outputBuffer);
        this.updateRecipe();
        this.markDirtyGUI();
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("OutputSuccessful", this.outputSuccessful);
        compound.func_218657_a("OutputBuffer", (INBT)ItemStackHelper.func_191282_a((CompoundNBT)new CompoundNBT(), this.outputBuffer));
        return compound;
    }

    public IEnergyStorage initEnergy() {
        return new CustomEnergyStorage((Integer)Config.DISSOLVER_ENERGY_CAPACITY.get()){

            public void onEnergyChanged() {
                DissolverTile.this.markDirtyGUI();
            }
        };
    }

    public IEnergyStorage getEnergy() {
        return this.energy;
    }
}

