/*
 * Decompiled with CFR 0.152.
 */
package al132.alchemistry.blocks.evaporator;

import al132.alchemistry.Config;
import al132.alchemistry.Ref;
import al132.alchemistry.blocks.AlchemistryBaseTile;
import al132.alchemistry.blocks.evaporator.EvaporatorContainer;
import al132.alchemistry.recipes.EvaporatorRecipe;
import al132.alchemistry.recipes.ModRecipes;
import al132.alib.tiles.ABaseTile;
import al132.alib.tiles.CustomStackHandler;
import al132.alib.tiles.FluidTile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class EvaporatorTile
extends AlchemistryBaseTile
implements FluidTile {
    public int progressTicks = 0;
    private int calculatedProcessingTime = 0;
    private EvaporatorRecipe currentRecipe = null;
    protected FluidTank fluidTank;
    protected LazyOptional<IFluidHandler> fluidHolder = LazyOptional.of(() -> this.fluidTank);

    public EvaporatorTile() {
        super(Ref.evaporatorTile);
        this.fluidTank = new FluidTank(10000, stack -> true){

            protected void onContentsChanged() {
                super.onContentsChanged();
                EvaporatorTile.this.markDirtyClient();
            }
        };
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.fluidTank.getFluidAmount() > 0) {
            this.currentRecipe = ModRecipes.evaporatorRecipes.stream().filter(recipe -> this.fluidTank.getFluid().containsFluid(recipe.input)).findFirst().orElse(null);
        }
        if (this.canProcess()) {
            this.process();
        }
        this.markDirtyClient();
    }

    public boolean canProcess() {
        if (this.currentRecipe != null) {
            ItemStack recipeOutput = this.currentRecipe.output;
            return this.fluidTank.getFluidAmount() >= this.currentRecipe.input.getAmount() && this.getOutput().getStackInSlot(0).func_190916_E() + recipeOutput.func_190916_E() <= recipeOutput.func_77976_d();
        }
        return false;
    }

    public void process() {
        if (this.progressTicks % 5 == 0) {
            this.calculatedProcessingTime = this.calculateProcessingTime();
        }
        if (this.progressTicks < this.calculatedProcessingTime) {
            ++this.progressTicks;
        } else {
            this.progressTicks = 0;
            this.fluidTank.drain(this.currentRecipe.input.getAmount(), IFluidHandler.FluidAction.EXECUTE);
            this.getOutput().setOrIncrement(0, this.currentRecipe.output.func_77946_l());
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.progressTicks = compound.func_74762_e("progressTicks");
        this.fluidTank.readFromNBT(compound.func_74775_l("fluidTank"));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("progressTicks", this.progressTicks);
        compound.func_218657_a("fluidTank", (INBT)this.fluidTank.writeToNBT(new CompoundNBT()));
        return super.func_189515_b(compound);
    }

    public int calculateProcessingTime() {
        int temp = (Integer)Config.EVAPORATOR_TICKS_PER_OPERATION.get();
        return temp;
    }

    public CustomStackHandler initInput() {
        return new CustomStackHandler((ABaseTile)this, 0);
    }

    public CustomStackHandler initOutput() {
        return new CustomStackHandler((ABaseTile)this, 1){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return false;
            }
        };
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInv, PlayerEntity player) {
        return new EvaporatorContainer(i, this.field_145850_b, this.field_174879_c, playerInv, player);
    }

    public LazyOptional<IFluidHandler> getFluidHandler() {
        return this.fluidHolder;
    }
}

