/*
 * Decompiled with CFR 0.152.
 */
package al132.alchemistry.blocks.fission;

import al132.alchemistry.Config;
import al132.alchemistry.Ref;
import al132.alchemistry.blocks.AlchemistryBaseTile;
import al132.alchemistry.blocks.PowerStatus;
import al132.alchemistry.blocks.fission.FissionContainer;
import al132.alchemistry.blocks.fission.FissionControllerBlock;
import al132.alib.tiles.ABaseTile;
import al132.alib.tiles.CustomEnergyStorage;
import al132.alib.tiles.CustomStackHandler;
import al132.alib.tiles.EnergyTile;
import al132.chemlib.chemistry.ElementRegistry;
import al132.chemlib.items.ElementItem;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class FissionTile
extends AlchemistryBaseTile
implements EnergyTile {
    int progressTicks = 0;
    ItemStack recipeOutput1 = ItemStack.field_190927_a;
    ItemStack recipeOutput2 = ItemStack.field_190927_a;
    boolean isValidMultiblock = false;
    int checkMultiblockTicks = 0;

    public FissionTile() {
        super(Ref.fissionTile);
    }

    public ItemStack getInputStack() {
        return this.getInput().getStackInSlot(0);
    }

    private void refreshRecipe() {
        if (!this.getInputStack().func_190926_b() && this.getInputStack().func_77973_b() instanceof ElementItem) {
            int atomicNumber = ((ElementItem)this.getInputStack().func_77973_b()).atomicNumber;
            if (atomicNumber != 0) {
                if (atomicNumber % 2 == 0) {
                    if (ElementRegistry.elements.containsKey((Object)(atomicNumber / 2)) && ElementRegistry.elements.get((Object)(atomicNumber / 2)) != null) {
                        this.recipeOutput1 = new ItemStack((IItemProvider)ElementRegistry.elements.get((Object)(atomicNumber / 2)), 2);
                        this.recipeOutput2 = ItemStack.field_190927_a;
                    }
                } else if (ElementRegistry.elements.containsKey((Object)(atomicNumber / 2)) && ElementRegistry.elements.containsKey((Object)(atomicNumber / 2 + 1))) {
                    this.recipeOutput1 = new ItemStack((IItemProvider)ElementRegistry.elements.get((Object)(atomicNumber / 2 + 1)));
                    this.recipeOutput2 = new ItemStack((IItemProvider)ElementRegistry.elements.get((Object)(atomicNumber / 2)));
                }
            }
        } else {
            this.recipeOutput1 = ItemStack.field_190927_a;
            this.recipeOutput2 = ItemStack.field_190927_a;
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            BlockState state;
            boolean isActive = !this.getInputStack().func_190926_b();
            ++this.checkMultiblockTicks;
            if (this.checkMultiblockTicks >= 20) {
                this.updateMultiblock();
                this.checkMultiblockTicks = 0;
            }
            if ((state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c() != Ref.fissionController) {
                return;
            }
            PowerStatus currentStatus = (PowerStatus)((Object)state.func_177229_b(FissionControllerBlock.STATUS));
            if (this.isValidMultiblock) {
                if (isActive) {
                    if (currentStatus != PowerStatus.ON) {
                        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a(FissionControllerBlock.STATUS, (Comparable)((Object)PowerStatus.ON)));
                    }
                } else if (currentStatus != PowerStatus.STANDBY) {
                    this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a(FissionControllerBlock.STATUS, (Comparable)((Object)PowerStatus.STANDBY)));
                }
            } else if (currentStatus != PowerStatus.OFF) {
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a(FissionControllerBlock.STATUS, (Comparable)((Object)PowerStatus.OFF)));
            }
            if (this.canProcess()) {
                this.process();
            }
            this.markDirtyClient();
        }
    }

    public boolean canProcess() {
        ItemStack output0 = this.getOutput().getStackInSlot(0);
        ItemStack output1 = this.getOutput().getStackInSlot(1);
        return !(!this.isValidMultiblock || this.recipeOutput1.func_190926_b() || !ItemStack.func_179545_c((ItemStack)output0, (ItemStack)this.recipeOutput1) && !output0.func_190926_b() || !ItemStack.func_179545_c((ItemStack)output1, (ItemStack)this.recipeOutput2) && !output1.func_190926_b() || output0.func_190916_E() + this.recipeOutput1.func_190916_E() > this.recipeOutput1.func_77976_d() || output1.func_190916_E() + this.recipeOutput2.func_190916_E() > this.recipeOutput2.func_77976_d() || this.energy.getEnergyStored() < (Integer)Config.FISSION_ENERGY_PER_TICK.get());
    }

    public void process() {
        if (this.progressTicks < (Integer)Config.FISSION_TICKS_PER_OPERATION.get()) {
            ++this.progressTicks;
        } else {
            this.progressTicks = 0;
            this.getOutput().setOrIncrement(0, this.recipeOutput1.func_77946_l());
            if (!this.recipeOutput2.func_190926_b()) {
                this.getOutput().setOrIncrement(1, this.recipeOutput2.func_77946_l());
            }
            this.getInput().decrementSlot(0, 1);
        }
        this.energy.extractEnergy(((Integer)Config.FISSION_ENERGY_PER_TICK.get()).intValue(), false);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.progressTicks = compound.func_74762_e("progressTicks");
        this.refreshRecipe();
        this.updateMultiblock();
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("progressTicks", this.progressTicks);
        return super.func_189515_b(compound);
    }

    public void updateMultiblock() {
        this.isValidMultiblock = this.validateMultiblock();
    }

    private boolean containsCasing(BlockPos pos) {
        return this.field_145850_b.func_180495_p(pos).func_177230_c() == Ref.fissionCasing;
    }

    private boolean containsCore(BlockPos pos) {
        return this.field_145850_b.func_180495_p(pos).func_177230_c() == Ref.fissionCore;
    }

    private boolean containsFissionPart(BlockPos pos) {
        Block block = this.field_145850_b.func_180495_p(pos).func_177230_c();
        return block == Ref.fissionCasing || block == Ref.fissionCore || block == Ref.fissionController;
    }

    public boolean validateMultiblock() {
        Direction multiblockDirection = ((Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)FissionControllerBlock.FACING)).func_176734_d();
        if (multiblockDirection == null) {
            return false;
        }
        BiFunction<BlockPos, Integer, BlockPos> offsetUp = (pos, amt) -> pos.func_177967_a(Direction.UP, amt.intValue());
        BiFunction<BlockPos, Integer, BlockPos> offsetLeft = (pos, amt) -> pos.func_177967_a(multiblockDirection.func_176746_e(), amt.intValue());
        BiFunction<BlockPos, Integer, BlockPos> offsetRight = (pos, amt) -> pos.func_177967_a(multiblockDirection.func_176746_e(), -1 * amt);
        BiFunction<BlockPos, Integer, BlockPos> offsetBack = (pos, amt) -> pos.func_177967_a(multiblockDirection, amt.intValue());
        BiFunction<BlockPos, Integer, BlockPos> offsetDown = (pos, amt) -> pos.func_177967_a(Direction.DOWN, amt.intValue());
        BlockPos coreBottom = offsetBack.apply(this.field_174879_c, 3);
        coreBottom = offsetUp.apply(coreBottom, 1);
        BlockPos coreTop = offsetUp.apply(coreBottom, 2);
        boolean coreMatches = BlockPos.func_218281_b((BlockPos)coreBottom, (BlockPos)coreTop).allMatch(this::containsCore);
        BlockPos outsideCorner1 = offsetLeft.apply(this.field_174879_c, 3);
        BlockPos outsideCorner1Final = outsideCorner1 = offsetDown.apply(outsideCorner1, 1);
        BlockPos outsideCorner2 = offsetRight.apply(outsideCorner1, 6);
        outsideCorner2 = offsetUp.apply(outsideCorner2, 6);
        outsideCorner2 = offsetBack.apply(outsideCorner2, 6);
        long borderingParts = BlockPos.func_218281_b((BlockPos)outsideCorner1, (BlockPos)outsideCorner2).filter(it -> {
            int sharedAxes = 0;
            if (it.func_177958_n() == outsideCorner1Final.func_177958_n() || it.func_177958_n() == outsideCorner1Final.func_177958_n()) {
                ++sharedAxes;
            }
            if (it.func_177956_o() == outsideCorner1Final.func_177956_o() || it.func_177956_o() == outsideCorner1Final.func_177956_o()) {
                ++sharedAxes;
            }
            if (it.func_177952_p() == outsideCorner1Final.func_177952_p() || it.func_177952_p() == outsideCorner1Final.func_177952_p()) {
                ++sharedAxes;
            }
            return sharedAxes >= 1;
        }).filter(it -> !it.equals((Object)this.field_174879_c)).filter(this::containsFissionPart).count();
        BlockPos casingCorner1 = offsetLeft.apply(this.field_174879_c, 2);
        BlockPos casingCorner1Final = casingCorner1 = offsetBack.apply(casingCorner1, 1);
        BlockPos casingCorner2 = offsetRight.apply(casingCorner1, 4);
        casingCorner2 = offsetBack.apply(casingCorner2, 4);
        BlockPos casingCorner2Final = casingCorner2 = offsetUp.apply(casingCorner2, 4);
        boolean casingMatches = BlockPos.func_218281_b((BlockPos)casingCorner1, (BlockPos)casingCorner2).filter(it -> {
            int sharedAxes = 0;
            if (it.func_177958_n() == casingCorner1Final.func_177958_n() || it.func_177958_n() == casingCorner2Final.func_177958_n()) {
                ++sharedAxes;
            }
            if (it.func_177956_o() == casingCorner1Final.func_177956_o() || it.func_177956_o() == casingCorner2Final.func_177956_o()) {
                ++sharedAxes;
            }
            if (it.func_177952_p() == casingCorner1Final.func_177952_p() || it.func_177952_p() == casingCorner2Final.func_177952_p()) {
                ++sharedAxes;
            }
            return sharedAxes >= 1;
        }).allMatch(this::containsCasing);
        return casingMatches && coreMatches && borderingParts == 0L;
    }

    public CustomStackHandler initInput() {
        return new CustomStackHandler((ABaseTile)this, 1){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.func_77973_b() instanceof ElementItem;
            }

            public void onContentsChanged(int slot) {
                ((FissionTile)this.tile).refreshRecipe();
                super.onContentsChanged(slot);
            }
        };
    }

    public CustomStackHandler initOutput() {
        return new CustomStackHandler((ABaseTile)this, 2){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return false;
            }
        };
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInv, PlayerEntity player) {
        return new FissionContainer(i, this.field_145850_b, this.field_174879_c, playerInv, player);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.isValidMultiblock) {
            return super.getCapability(cap, side);
        }
        return LazyOptional.empty();
    }

    public IEnergyStorage initEnergy() {
        return new CustomEnergyStorage(((Integer)Config.FISSION_ENERGY_CAPACITY.get()).intValue());
    }

    public IEnergyStorage getEnergy() {
        return this.energy;
    }
}

