/*
 * Decompiled with CFR 0.152.
 */
package al132.alchemistry.blocks.liquifier;

import al132.alchemistry.Config;
import al132.alchemistry.Ref;
import al132.alchemistry.blocks.AlchemistryBaseTile;
import al132.alchemistry.blocks.liquifier.LiquifierContainer;
import al132.alchemistry.recipes.LiquifierRecipe;
import al132.alchemistry.recipes.ModRecipes;
import al132.alib.tiles.ABaseTile;
import al132.alib.tiles.CustomEnergyStorage;
import al132.alib.tiles.CustomStackHandler;
import al132.alib.tiles.EnergyTile;
import al132.alib.tiles.FluidTile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class LiquifierTile
extends AlchemistryBaseTile
implements EnergyTile,
FluidTile {
    public FluidTank outputTank = new FluidTank(10000);
    private LiquifierRecipe currentRecipe = null;
    public int progressTicks = 0;

    public LiquifierTile() {
        super(Ref.liquifierTile);
    }

    private void updateRecipe() {
        ItemStack inputStack = this.getInput().getStackInSlot(0);
        if (!(inputStack.func_190926_b() || this.currentRecipe != null && ItemStack.func_77989_b((ItemStack)this.currentRecipe.input, (ItemStack)inputStack))) {
            this.currentRecipe = ModRecipes.liquifierRecipes.stream().filter(it -> ItemStack.func_179545_c((ItemStack)it.input, (ItemStack)inputStack)).findFirst().orElse(null);
        }
        if (inputStack.func_190926_b()) {
            this.currentRecipe = null;
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (!this.getInput().getStackInSlot(0).func_190926_b()) {
                this.updateRecipe();
                if (this.canProcess()) {
                    this.process();
                }
            }
            this.markDirtyGUIEvery(5);
        }
    }

    public boolean canProcess() {
        if (this.currentRecipe != null) {
            FluidStack recipeOutput = this.currentRecipe.output;
            return this.outputTank.getCapacity() >= this.outputTank.getFluidAmount() + recipeOutput.getAmount() && this.energy.getEnergyStored() >= (Integer)Config.LIQUIFIER_ENERGY_PER_TICK.get() && this.getInput().getStackInSlot(0).func_190916_E() >= this.currentRecipe.input.func_190916_E() && (this.outputTank.getFluid().getFluid() == recipeOutput.getFluid() || this.outputTank.getFluid().isEmpty());
        }
        return false;
    }

    public void process() {
        if (this.progressTicks < (Integer)Config.LIQUIFIER_TICKS_PER_OPERATION.get()) {
            ++this.progressTicks;
        } else {
            this.progressTicks = 0;
            this.outputTank.fill(this.currentRecipe.output.copy(), IFluidHandler.FluidAction.EXECUTE);
            this.getInput().getStackInSlot(0).func_190918_g(this.currentRecipe.input.func_190916_E());
        }
        this.energy.extractEnergy(((Integer)Config.LIQUIFIER_ENERGY_PER_TICK.get()).intValue(), false);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.progressTicks = compound.func_74762_e("progressTicks");
        this.outputTank.readFromNBT(compound.func_74775_l("outputTank"));
        this.updateRecipe();
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("progressTicks", this.progressTicks);
        compound.func_218657_a("outputTank", (INBT)this.outputTank.writeToNBT(new CompoundNBT()));
        return super.func_189515_b(compound);
    }

    public CustomStackHandler initInput() {
        return new CustomStackHandler((ABaseTile)this, 1){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (ModRecipes.liquifierRecipes.stream().anyMatch(it -> ItemStack.func_179545_c((ItemStack)it.input, (ItemStack)stack))) {
                    return super.isItemValid(slot, stack);
                }
                return false;
            }
        };
    }

    public CustomStackHandler initOutput() {
        return new CustomStackHandler((ABaseTile)this, 0);
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInv, PlayerEntity player) {
        return new LiquifierContainer(i, this.field_145850_b, this.field_174879_c, playerInv, player);
    }

    public IEnergyStorage initEnergy() {
        return new CustomEnergyStorage(((Integer)Config.LIQUIFIER_ENERGY_CAPACITY.get()).intValue());
    }

    public IEnergyStorage getEnergy() {
        return this.energy;
    }

    public LazyOptional<IFluidHandler> getFluidHandler() {
        return LazyOptional.empty();
    }
}

