/*
 * Decompiled with CFR 0.152.
 */
package al132.alchemistry.compat.jei.category;

import al132.alchemistry.Alchemistry;
import al132.alchemistry.Ref;
import al132.alchemistry.recipes.DissolverRecipe;
import al132.alchemistry.recipes.ProbabilityGroup;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class DissolverRecipeCategory
implements IRecipeCategory<DissolverRecipe> {
    private IGuiHelper guiHelper;
    private static final int u = 5;
    private static final int v = 5;
    private static final int INPUT_ONE = 2;
    private static final int OUTPUT_STARTING_INDEX = 3;

    public DissolverRecipeCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
    }

    public ResourceLocation getUid() {
        return new ResourceLocation(Alchemistry.data.MODID, "dissolver_recipe");
    }

    public Class<? extends DissolverRecipe> getRecipeClass() {
        return DissolverRecipe.class;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)"alchemistry.jei.dissolver", (Object[])new Object[0]);
    }

    public IDrawable getBackground() {
        return this.guiHelper.createDrawable(new ResourceLocation(Alchemistry.data.MODID, "textures/gui/dissolver_jei.png"), 5, 5, 180, 256);
    }

    public IDrawable getIcon() {
        return this.guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)Ref.dissolver));
    }

    public void setIngredients(DissolverRecipe recipe, IIngredients ingredients) {
        ArrayList inputs = Lists.newArrayList((Object[])new Ingredient[]{recipe.getInput()});
        ingredients.setInputIngredients((List)inputs);
        ingredients.setOutputs(VanillaTypes.ITEM, recipe.outputs.filterNonEmpty());
    }

    public void setRecipe(IRecipeLayout recipeLayout, DissolverRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        List<ProbabilityGroup> outputSet = recipe.outputs.getSet();
        int x = 90;
        int y = 2;
        guiItemStacks.init(2, true, x, y);
        guiItemStacks.set(2, Arrays.asList(recipe.getInput().func_193365_a()));
        x = 45;
        y = 45;
        int outputSlotIndex = 3;
        for (ProbabilityGroup component : outputSet) {
            for (ItemStack stack : component.getOutputs()) {
                guiItemStacks.init(outputSlotIndex, false, x, y);
                if (!stack.func_190926_b()) {
                    guiItemStacks.set(outputSlotIndex, stack);
                }
                x += 18;
                ++outputSlotIndex;
            }
            x = 45;
            y += 18;
        }
    }

    public void draw(DissolverRecipe recipe, MatrixStack ms, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.func_71410_x();
        int y = 50;
        for (int index = 0; index < recipe.outputs.getSet().size(); ++index) {
            String text = this.formatProbability(recipe, recipe.outputs.probabilityAtIndex(index));
            minecraft.field_71466_p.func_238421_b_(ms, text, 0.0f, (float)y, Color.BLACK.getRGB());
            y += 18;
        }
        String probabilityType = "";
        probabilityType = recipe.outputs.relativeProbability ? I18n.func_135052_a((String)"alchemistry.jei.dissolver.relative", (Object[])new Object[0]) : I18n.func_135052_a((String)"alchemistry.jei.dissolver.absolute", (Object[])new Object[0]);
        String typeLabel = I18n.func_135052_a((String)"alchemistry.jei.dissolver.type", (Object[])new Object[0]);
        String rollsLabel = I18n.func_135052_a((String)"alchemistry.jei.dissolver.rolls", (Object[])new Object[0]);
        int rolls = recipe.outputs.rolls;
        minecraft.field_71466_p.func_238421_b_(ms, typeLabel + ": " + probabilityType, 5.0f, 4.0f, Color.BLACK.getRGB());
        minecraft.field_71466_p.func_238421_b_(ms, rollsLabel + ": " + rolls, 5.0f, 16.0f, Color.BLACK.getRGB());
    }

    public String formatProbability(DissolverRecipe recipe, double probability) {
        if (recipe.outputs.relativeProbability) {
            return Ref.DECIMAL_FORMAT.format(probability * 100.0) + "%";
        }
        return Ref.DECIMAL_FORMAT.format(probability) + "%";
    }
}

