/*
 * Decompiled with CFR 0.152.
 */
package al132.alchemistry.recipes;

import al132.alchemistry.Alchemistry;
import al132.alchemistry.recipes.ModRecipes;
import al132.alchemistry.recipes.ProbabilitySet;
import al132.alchemistry.utils.TagUtils;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;

public class DissolverRecipe {
    private String inputTagName;
    private Ingredient inputIngredient;
    public boolean reversible = false;
    public ProbabilitySet outputs;

    public Ingredient getInput() {
        if (this.inputIngredient == null) {
            this.inputIngredient = Ingredient.func_199805_a(TagUtils.tag(this.inputTagName));
        }
        return this.inputIngredient;
    }

    public DissolverRecipe(BuilderFromIngredient builder) {
        this(builder.inputIngredient, builder.outputs);
        this.reversible = builder.reversible;
    }

    public DissolverRecipe(BuilderFromTag builder) {
        this(builder.inputTagName, builder.outputs);
        this.reversible = builder.reversible;
    }

    public DissolverRecipe(String inputTagName, ProbabilitySet outputs) {
        this.inputTagName = inputTagName;
        this.outputs = outputs;
    }

    public DissolverRecipe(Ingredient input, ProbabilitySet outputs) {
        this.inputIngredient = input;
        this.outputs = outputs;
    }

    public DissolverRecipe copy() {
        return new DissolverRecipe(this.inputIngredient, this.outputs);
    }

    @Nullable
    public static DissolverRecipe match(ItemStack input, boolean quantitySensitive) {
        for (DissolverRecipe recipe : ModRecipes.dissolverRecipes) {
            if (recipe.inputIngredient == null) continue;
            for (ItemStack recipeStack : (ItemStack[])recipe.inputIngredient.func_193365_a().clone()) {
                if (!ItemStack.func_179545_c((ItemStack)recipeStack, (ItemStack)input)) continue;
                if (quantitySensitive && input.func_190916_E() >= recipeStack.func_190916_E()) {
                    return recipe.copy();
                }
                if (quantitySensitive) continue;
                return recipe.copy();
            }
        }
        return null;
    }

    public static class BuilderFromTag {
        private String inputTagName;
        private ProbabilitySet outputs;
        private boolean reversible = false;

        public BuilderFromTag outputs(ProbabilitySet set) {
            this.outputs = set;
            return this;
        }

        public BuilderFromTag setReversible(boolean value) {
            this.reversible = value;
            return this;
        }

        public BuilderFromTag input(String tagLocation) {
            this.inputTagName = tagLocation;
            return this;
        }

        public void build() {
            String outs;
            String ins = this.inputTagName == null ? "null" : this.inputTagName.toString();
            String string = outs = this.outputs == null ? "null" : this.outputs.toString();
            if (this.inputTagName != null && this.outputs != null) {
                ModRecipes.dissolverRecipes.add(new DissolverRecipe(this));
            } else {
                Alchemistry.LOGGER.warn("Invalid dissolver recipe - input[" + ins + "], outputs[" + outs + "]");
            }
        }
    }

    public static class BuilderFromIngredient {
        private Ingredient inputIngredient;
        private ProbabilitySet outputs;
        private boolean reversible = false;

        public BuilderFromIngredient outputs(ProbabilitySet set) {
            this.outputs = set;
            return this;
        }

        public BuilderFromIngredient setReversible(boolean value) {
            this.reversible = value;
            return this;
        }

        public BuilderFromIngredient input(ItemStack input) {
            this.inputIngredient = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{input});
            return this;
        }

        public BuilderFromIngredient input(Item input) {
            this.inputIngredient = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{input});
            return this;
        }

        public BuilderFromIngredient input(Ingredient input) {
            this.inputIngredient = input;
            return this;
        }

        public void build() {
            String outs;
            String ins = this.inputIngredient == null ? "null" : this.inputIngredient.toString();
            String string = outs = this.outputs == null ? "null" : this.outputs.toString();
            if (this.inputIngredient != null && this.outputs != null) {
                ModRecipes.dissolverRecipes.add(new DissolverRecipe(this));
            } else {
                Alchemistry.LOGGER.warn("Invalid dissolver recipe - input[" + ins + "], outputs[" + outs + "]");
            }
        }
    }
}

