/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods;

import betterwithmods.BWCrafting;
import betterwithmods.BWFuelHandler;
import betterwithmods.BWIMCHandler;
import betterwithmods.BWMBlocks;
import betterwithmods.BWMItems;
import betterwithmods.BWRegistry;
import betterwithmods.BWSounds;
import betterwithmods.api.capabilities.MechanicalCapability;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.client.container.BWGuiHandler;
import betterwithmods.config.BWConfig;
import betterwithmods.config.ConfigSyncHandler;
import betterwithmods.entity.EntityBroadheadArrow;
import betterwithmods.entity.EntityDynamite;
import betterwithmods.entity.EntityExtendingRope;
import betterwithmods.entity.EntityFallingGourd;
import betterwithmods.entity.EntityMiningCharge;
import betterwithmods.entity.EntityShearedCreeper;
import betterwithmods.entity.item.EntityFallingBlockCustom;
import betterwithmods.entity.item.EntityItemBuoy;
import betterwithmods.event.BWMWorldGenEvent;
import betterwithmods.event.BlastingOilEvent;
import betterwithmods.event.BreedingHardnessEvent;
import betterwithmods.event.BucketEvent;
import betterwithmods.event.BuoyancyEventHandler;
import betterwithmods.event.EggImpactEvent;
import betterwithmods.event.HardcoreEndermenEvent;
import betterwithmods.event.HardcoreHardnessEventHandler;
import betterwithmods.event.HardcoreMelonEventHandler;
import betterwithmods.event.HungerEventHandler;
import betterwithmods.event.InferiorDropsEventHandler;
import betterwithmods.event.LogHarvestEvent;
import betterwithmods.event.MobAIEvent;
import betterwithmods.event.MobDropEvent;
import betterwithmods.event.NetherSpawnEvent;
import betterwithmods.event.PotionEventHandler;
import betterwithmods.event.RespawnEventHandler;
import betterwithmods.event.SaveSoupEvent;
import betterwithmods.event.StumpingEventHandler;
import betterwithmods.integration.ICompatModule;
import betterwithmods.network.BWNetwork;
import betterwithmods.proxy.IProxy;
import betterwithmods.util.ColorUtils;
import betterwithmods.util.HardcoreFunctions;
import betterwithmods.util.InvUtils;
import betterwithmods.util.RecipeUtils;
import betterwithmods.util.item.ItemExt;
import betterwithmods.world.BWComponentScatteredFeaturePieces;
import betterwithmods.world.BWMapGenScatteredFeature;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.gen.structure.ComponentScatteredFeaturePieces;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import org.apache.logging.log4j.Logger;

@Mod(modid="betterwithmods", name="Better With Mods", version="0.14.23 Beta", dependencies="required-after:Forge@[12.18.1.2076,);before:survivalist;after:tconstruct;after:minechem;after:natura;after:terrafirmacraft;after:immersiveengineering;after:techreborn;after:terraqueous;after:Mekanism;after:thermalexpansion", guiFactory="betterwithmods.client.gui.BWGuiFactory", acceptedMinecraftVersions="[1.10.2]")
public class BWMod {
    public static final String MODID = "betterwithmods";
    public static final String VERSION = "0.14.23 Beta";
    public static final String NAME = "Better With Mods";
    private static final Set<ICompatModule> loadedModules = new HashSet<ICompatModule>();
    private static final Map<String, String> compatClasses;
    public static Logger logger;
    @SidedProxy(serverSide="betterwithmods.proxy.ServerProxy", clientSide="betterwithmods.proxy.ClientProxy")
    public static IProxy proxy;
    @Mod.Instance(value="betterwithmods")
    public static BWMod instance;
    public static IForgeRegistry<Item> itemRegistry;

    public static Set<ICompatModule> getLoadedModules() {
        return loadedModules;
    }

    private static void loadCompatibilityModules() {
        for (Map.Entry<String, String> entry : compatClasses.entrySet()) {
            String modId = entry.getKey();
            String classPath = entry.getValue();
            if (!BWMod.isLoaded(modId)) continue;
            try {
                loadedModules.add(Class.forName(classPath).asSubclass(ICompatModule.class).newInstance());
                logger.info("Successfully load compat for " + modId);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                logger.error("Compatibility class " + classPath + " could not be loaded. Report this!");
                e.printStackTrace();
            }
        }
    }

    private static boolean isLoaded(String modId) {
        boolean loaded = Loader.isModLoaded((String)modId) && BWConfig.config.get("Mod Compat", modId.toLowerCase() + "_compat", true).getBoolean();
        logger.debug("Compat for " + modId + " is " + (loaded ? "loaded" : "not loaded"));
        BWConfig.config.save();
        return loaded;
    }

    private static void registerEventHandlers() {
        MinecraftForge.EVENT_BUS.register((Object)new BWConfig());
        MinecraftForge.EVENT_BUS.register((Object)new HungerEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new BuoyancyEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new RespawnEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new MobDropEvent());
        MinecraftForge.EVENT_BUS.register((Object)new BucketEvent());
        MinecraftForge.EVENT_BUS.register((Object)new NetherSpawnEvent());
        MinecraftForge.EVENT_BUS.register((Object)new LogHarvestEvent());
        MinecraftForge.EVENT_BUS.register((Object)new PotionEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new MobAIEvent());
        MinecraftForge.EVENT_BUS.register((Object)new HardcoreHardnessEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new HardcoreMelonEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new EggImpactEvent());
        MinecraftForge.EVENT_BUS.register((Object)new SaveSoupEvent());
        MinecraftForge.EVENT_BUS.register((Object)new BlastingOilEvent());
        MinecraftForge.EVENT_BUS.register((Object)new BreedingHardnessEvent());
        MinecraftForge.EVENT_BUS.register((Object)new HardcoreEndermenEvent());
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)new BWMWorldGenEvent());
        MinecraftForge.EVENT_BUS.register((Object)new StumpingEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new InferiorDropsEventHandler());
    }

    private static void registerEntities() {
        BWRegistry.registerEntity(EntityExtendingRope.class, "ExtendingRope", 64, 20, true);
        BWRegistry.registerEntity(EntityDynamite.class, "BWMDynamite", 10, 50, true);
        BWRegistry.registerEntity(EntityMiningCharge.class, "BWMMiningCharge", 10, 50, true);
        BWRegistry.registerEntity(EntityItemBuoy.class, "entityItemBuoy", 64, 20, true);
        BWRegistry.registerEntity(EntityShearedCreeper.class, "entityShearedCreeper", 64, 1, true);
        BWRegistry.registerEntity(EntityBroadheadArrow.class, "entityBroadheadArrow", 64, 1, true);
        BWRegistry.registerEntity(EntityFallingGourd.class, "entityFallingGourd", 64, 1, true);
        BWRegistry.registerEntity(EntityFallingBlockCustom.class, "falling_block_custom", 64, 20, true);
    }

    private static void registerWorldGen() {
        if (BWConfig.hardcoreStructures) {
            MapGenStructureIO.func_143034_b(BWMapGenScatteredFeature.Start.class, (String)"BWTemple");
            MapGenStructureIO.func_143031_a(BWComponentScatteredFeaturePieces.DesertPyramid.class, (String)"BWTeDP");
            MapGenStructureIO.func_143031_a(BWComponentScatteredFeaturePieces.JunglePyramid.class, (String)"BWTeJP");
            MapGenStructureIO.func_143031_a(BWComponentScatteredFeaturePieces.SwampHut.class, (String)"BWTeSH");
            MapGenStructureIO.func_143031_a(ComponentScatteredFeaturePieces.Igloo.class, (String)"BWIglu");
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        logger = evt.getModLog();
        BWConfig.init(evt.getSuggestedConfigurationFile());
        BWMBlocks.registerBlocks();
        BWMItems.registerItems();
        BWMBlocks.registerTileEntities();
        itemRegistry = GameRegistry.findRegistry(Item.class);
        if (BWConfig.hardcoreHardness) {
            HardcoreFunctions.applyHCHardness();
        }
        if (BWConfig.earlyPickaxesRebalance) {
            Items.field_151050_s.func_77656_e(5);
        }
        if (BWConfig.removeLowTools) {
            HardcoreFunctions.removeLowTierToolRecipes();
        }
        if (BWConfig.axeOnLeaves) {
            Blocks.field_150362_t.setHarvestLevel("axe", 0);
            Blocks.field_150361_u.setHarvestLevel("axe", 1);
        }
        BWRegistry.init();
        BWMod.loadCompatibilityModules();
        BWMod.getLoadedModules().forEach(ICompatModule::preInit);
        BWCrafting.init();
        BWMod.registerEntities();
        CapabilityManager.INSTANCE.register(IMechanicalPower.class, (Capability.IStorage)new MechanicalCapability.CapabilityMechanicalPower(), MechanicalCapability.DefaultMechanicalPower.class);
        BWNetwork.INSTANCE.init();
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        BWMod.registerWorldGen();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new BWGuiHandler());
        BWRegistry.registerHeatSources();
        GameRegistry.registerFuelHandler((IFuelHandler)new BWFuelHandler());
        BWRegistry.registerNetherWhitelist();
        BWMod.getLoadedModules().forEach(ICompatModule::init);
        BWSounds.registerSounds();
        ItemExt.initBuoyancy();
        ItemExt.initDesserts();
        ItemExt.initWeights();
        proxy.init();
    }

    @Mod.EventHandler
    public void processIMCMessages(FMLInterModComms.IMCEvent evt) {
        BWIMCHandler.processIMC((ImmutableList<FMLInterModComms.IMCMessage>)evt.getMessages());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        RecipeUtils.gatherCookableFood();
        BWRegistry.registerWood();
        InvUtils.postInitOreDictGathering();
        BWCrafting.postInit();
        ColorUtils.initColors();
        BWMod.registerEventHandlers();
        RecipeUtils.refreshRecipes();
        BWMod.getLoadedModules().forEach(ICompatModule::postInit);
        BucketEvent.editModdedFluidDispenseBehavior();
        if (evt.getSide().isServer()) {
            MinecraftForge.EVENT_BUS.register((Object)new ConfigSyncHandler());
        }
        proxy.postInit();
    }

    @Mod.EventHandler
    public void remap(FMLMissingMappingsEvent evt) throws MinecraftException {
        for (FMLMissingMappingsEvent.MissingMapping mapping : evt.get()) {
            switch (mapping.type) {
                case ITEM: {
                    if (!Objects.equals(mapping.name, "betterwithmods:creativeGenerator")) break;
                    Item creativeGeneratorItem = Item.func_150898_a((Block)BWMBlocks.CREATIVE_GENERATOR);
                    if (creativeGeneratorItem == null) {
                        throw new MinecraftException("The Creative Generator does not have an item. Can't remap.");
                    }
                    mapping.remap(creativeGeneratorItem);
                    break;
                }
                case BLOCK: {
                    if (!Objects.equals(mapping.name, "betterwithmods:creativeGenerator")) break;
                    mapping.remap(BWMBlocks.CREATIVE_GENERATOR);
                }
            }
        }
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("biomesoplenty", "betterwithmods.integration.BiomesOPlenty");
        map.put("harvestcraft", "betterwithmods.integration.Harvestcraft");
        map.put("immersiveengineering", "betterwithmods.integration.immersiveengineering.ImmersiveEngineering");
        map.put("MineTweaker3", "betterwithmods.integration.minetweaker.MineTweaker");
        map.put("Quark", "betterwithmods.integration.Quark");
        map.put("tconstruct", "betterwithmods.integration.tcon.TConstruct");
        map.put("nethercore", "betterwithmods.integration.NetherCore");
        compatClasses = Collections.unmodifiableMap(map);
    }
}

