/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods;

import betterwithmods.BWCrafting;
import betterwithmods.BWMBlocks;
import betterwithmods.BWMItems;
import betterwithmods.BWMod;
import betterwithmods.blocks.BehaviorDiodeDispense;
import betterwithmods.blocks.BlockBDispenser;
import betterwithmods.blocks.BlockBWMPane;
import betterwithmods.blocks.BlockRope;
import betterwithmods.config.BWConfig;
import betterwithmods.craft.ChoppingRecipe;
import betterwithmods.craft.HopperFilters;
import betterwithmods.craft.SawInteraction;
import betterwithmods.craft.heat.BWMHeatRegistry;
import betterwithmods.entity.EntityMiningCharge;
import betterwithmods.items.ItemMaterial;
import betterwithmods.potion.BWPotion;
import betterwithmods.util.DispenserBehaviorDynamite;
import betterwithmods.util.InvUtils;
import betterwithmods.util.NetherSpawnWhitelist;
import betterwithmods.util.RecipeUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class BWRegistry {
    public static final Potion POTION_TRUESIGHT = (Potion)new BWPotion(false, 14270531, 4, 1).setRegistryName("true_sight");
    private static int availableEntityId = 0;

    public static void init() {
        BWRegistry.registerOres();
        BWRegistry.registerPotions();
        BWRegistry.registerBlockDispenserBehavior();
        BWRegistry.registerHopperFilters();
        if (BWConfig.dropsHempSeeds) {
            MinecraftForge.addGrassSeed((ItemStack)new ItemStack(BWMBlocks.HEMP, 1, 0), (int)5);
        }
    }

    public static void registerHopperFilters() {
        HopperFilters.addFilter(1, Blocks.field_150468_ap, 0, BWRegistry::isNotBlock);
        HopperFilters.addFilter(2, Blocks.field_150415_aT, 0, stack -> BWRegistry.isNarrow(stack) || BWRegistry.isParticulate(stack));
        HopperFilters.addFilter(3, BWMBlocks.GRATE, Short.MAX_VALUE, stack -> BWRegistry.isNarrow(stack) || BWRegistry.isFlat(stack) || BWRegistry.isParticulate(stack));
        HopperFilters.addFilter(4, BWMBlocks.SLATS, Short.MAX_VALUE, stack -> BWRegistry.isParticulate(stack) || BWRegistry.isFlat(stack));
        HopperFilters.addFilter(5, BWMBlocks.PANE, BlockBWMPane.EnumPaneType.WICKER.getMeta(), BWRegistry::isParticulate);
        HopperFilters.addFilter(6, Blocks.field_150425_aM, 0, stack -> false);
        HopperFilters.addFilter(7, Blocks.field_150411_aY, 0, stack -> BWRegistry.isNotBlock(stack) && stack.func_77976_d() > 1);
    }

    public static void registerBlockDispenserBehavior() {
        BlockDispenser.field_149943_a.func_82595_a((Object)BWMItems.DYNAMITE, (Object)new DispenserBehaviorDynamite());
        if (BWConfig.hardcoreBuckets) {
            BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_151131_as, (Object)new BehaviorDefaultDispenseItem(){

                public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                    ItemStack outputStack = stack;
                    BlockPos pos = source.func_180699_d().func_177972_a((EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a));
                    if (source.func_82618_k().func_175623_d(pos) || source.func_82618_k().func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)source.func_82618_k(), pos)) {
                        source.func_82618_k().func_175656_a(pos, Blocks.field_150358_i.func_176203_a(2));
                        for (EnumFacing face : EnumFacing.field_176754_o) {
                            BlockPos off = pos.func_177972_a(face);
                            if (!source.func_82618_k().func_175623_d(off) && !source.func_82618_k().func_180495_p(off).func_177230_c().func_176200_f((IBlockAccess)source.func_82618_k(), off)) continue;
                            source.func_82618_k().func_175656_a(off, Blocks.field_150358_i.func_176203_a(5));
                        }
                        outputStack = new ItemStack(Items.field_151133_ar, 1);
                    }
                    return outputStack;
                }
            });
        }
        BlockBDispenser.BLOCK_DISPENSER_REGISTRY.func_82595_a((Object)Items.field_151107_aW, (Object)new BehaviorDiodeDispense());
        BlockBDispenser.BLOCK_DISPENSER_REGISTRY.func_82595_a((Object)Items.field_151132_bS, (Object)new BehaviorDiodeDispense());
        BlockBDispenser.BLOCK_DISPENSER_REGISTRY.func_82595_a((Object)Item.func_150898_a((Block)BWMBlocks.MINING_CHARGE), (source, stack) -> {
            World worldIn = source.func_82618_k();
            EnumFacing facing = (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
            BlockPos pos = source.func_180699_d().func_177972_a(facing);
            EntityMiningCharge miningCharge = new EntityMiningCharge(worldIn, (float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f, null, facing);
            miningCharge.func_189654_d(false);
            worldIn.func_72838_d((Entity)miningCharge);
            worldIn.func_184148_a(null, miningCharge.field_70165_t, miningCharge.field_70163_u, miningCharge.field_70161_v, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return stack;
        });
    }

    public static void registerEntity(Class<? extends Entity> entityClass, String entityName, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        EntityRegistry.registerModEntity(entityClass, (String)entityName, (int)availableEntityId, (Object)BWMod.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
        ++availableEntityId;
    }

    public static void registerOres() {
        OreDictionary.registerOre((String)"gearWood", (ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.GEAR));
        OreDictionary.registerOre((String)"cropHemp", (ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.HEMP));
        OreDictionary.registerOre((String)"dyeBrown", (ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.DUNG));
        OreDictionary.registerOre((String)"dung", (ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.DUNG));
        OreDictionary.registerOre((String)"slimeball", (ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.GLUE));
        OreDictionary.registerOre((String)"ingotSoulforgedSteel", (ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.INGOT_STEEL));
        OreDictionary.registerOre((String)"dustNetherrack", (ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.GROUND_NETHERRACK));
        OreDictionary.registerOre((String)"dustHellfire", (ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.HELLFIRE_DUST));
        OreDictionary.registerOre((String)"dustSoul", (ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.SOUL_DUST));
        OreDictionary.registerOre((String)"ingotHellfire", (ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.CONCENTRATED_HELLFIRE));
        OreDictionary.registerOre((String)"dustCoal", (ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.COAL_DUST));
        OreDictionary.registerOre((String)"dustPotash", (ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.POTASH));
        OreDictionary.registerOre((String)"dustWood", (ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.SAWDUST));
        OreDictionary.registerOre((String)"dustSulfur", (ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.BRIMSTONE));
        OreDictionary.registerOre((String)"dustSaltpeter", (ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.NITER));
        OreDictionary.registerOre((String)"nuggetIron", (ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.NUGGET_IRON));
        OreDictionary.registerOre((String)"nuggetSoulforgedSteel", (ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.NUGGET_STEEL));
        OreDictionary.registerOre((String)"foodFlour", (ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.FLOUR));
        OreDictionary.registerOre((String)"dustCharcoal", (ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.CHARCOAL_DUST));
        OreDictionary.registerOre((String)"foodCocoapowder", (ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.COCOA_POWDER));
        OreDictionary.registerOre((String)"foodChocolatebar", (ItemStack)new ItemStack(BWMItems.CHOCOLATE));
        OreDictionary.registerOre((String)"blockSoulforgedSteel", (ItemStack)new ItemStack(BWMBlocks.AESTHETIC, 1, 2));
        OreDictionary.registerOre((String)"blockHellfire", (ItemStack)new ItemStack(BWMBlocks.AESTHETIC, 1, 3));
        OreDictionary.registerOre((String)"barkWood", (ItemStack)new ItemStack(BWMItems.BARK, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"barkOak", (ItemStack)new ItemStack(BWMItems.BARK, 1, 0));
        OreDictionary.registerOre((String)"barkSpruce", (ItemStack)new ItemStack(BWMItems.BARK, 1, 1));
        OreDictionary.registerOre((String)"barkBirch", (ItemStack)new ItemStack(BWMItems.BARK, 1, 2));
        OreDictionary.registerOre((String)"barkJungle", (ItemStack)new ItemStack(BWMItems.BARK, 1, 3));
        OreDictionary.registerOre((String)"barkAcacia", (ItemStack)new ItemStack(BWMItems.BARK, 1, 4));
        OreDictionary.registerOre((String)"barkDarkOak", (ItemStack)new ItemStack(BWMItems.BARK, 1, 5));
        OreDictionary.registerOre((String)"craftingToolKnife", (ItemStack)new ItemStack(BWMItems.KNIFE, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"slabWood", (ItemStack)new ItemStack(BWMBlocks.WOOD_SIDING, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"itemKnife", (ItemStack)new ItemStack(BWMItems.KNIFE, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"fiberHemp", (ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.HEMP_FIBERS));
        OreDictionary.registerOre((String)"fabricHemp", (ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.HEMP_CLOTH));
        OreDictionary.registerOre((String)"listAllmeatcooked", (Item)Items.field_151157_am);
        OreDictionary.registerOre((String)"listAllmeatcooked", (Item)Items.field_151083_be);
        OreDictionary.registerOre((String)"listAllmeatcooked", (Item)Items.field_151077_bg);
        OreDictionary.registerOre((String)"listAllmeatcooked", (Item)Items.field_179566_aV);
        OreDictionary.registerOre((String)"listAllmeatcooked", (ItemStack)new ItemStack(Items.field_179566_aV, 1, ItemFishFood.FishType.SALMON.func_150976_a()));
        OreDictionary.registerOre((String)"listAllmeatcooked", (Item)Items.field_179557_bn);
        OreDictionary.registerOre((String)"listAllmeatcooked", (Item)Items.field_179559_bp);
    }

    public static void registerHeatSources() {
        BWMHeatRegistry.setBlockHeatRegistry((Block)Blocks.field_150480_ab, 3);
        BWMHeatRegistry.setBlockHeatRegistry(BWMBlocks.STOKED_FLAME, 8);
    }

    public static void registerNetherWhitelist() {
        NetherSpawnWhitelist.addBlock(Blocks.field_150424_aL);
        NetherSpawnWhitelist.addBlock(Blocks.field_150385_bj);
        NetherSpawnWhitelist.addBlock(Blocks.field_150425_aM);
        NetherSpawnWhitelist.addBlock(Blocks.field_150351_n);
        NetherSpawnWhitelist.addBlock(Blocks.field_150371_ca);
    }

    public static void registerWood() {
        for (BlockPlanks.EnumType type : BlockPlanks.EnumType.values()) {
            ItemStack plank = new ItemStack(Blocks.field_150344_f, BWConfig.hardcoreLumber ? 4 : 6, type.func_176839_a());
            ItemStack log = type.func_176839_a() < 4 ? new ItemStack(Blocks.field_150364_r, 1, type.func_176839_a()) : new ItemStack(Blocks.field_150363_s, 1, type.func_176839_a() - 4);
            Block block = ((ItemBlock)log.func_77973_b()).func_179223_d();
            ItemStack bark = new ItemStack(BWMItems.BARK, 1, type.func_176839_a());
            ItemStack sawdust = ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.SAWDUST, 2);
            if (BWConfig.hardcoreLumber) {
                BWRegistry.removeRecipe(plank, log);
                if (Loader.isModLoaded((String)"thermalexpansion")) {
                    BWRegistry.registerTESawmill(plank, log);
                }
                GameRegistry.addRecipe((IRecipe)new ChoppingRecipe(new ItemStack(Blocks.field_150344_f, 2, type.func_176839_a()), bark, sawdust, log));
            }
            SawInteraction.INSTANCE.addRecipe(block, log.func_77960_j(), plank, bark, sawdust);
            SawInteraction.INSTANCE.addRecipe(Blocks.field_150344_f, type.func_176839_a(), new ItemStack(BWMBlocks.WOOD_SIDING, 2, type.func_176839_a()));
            plank = new ItemStack(Blocks.field_150344_f, BWConfig.hardcoreLumber ? 3 : 5, type.func_176839_a());
            log = type.func_176839_a() < 4 ? new ItemStack(BWMBlocks.DEBARKED_OLD, 1, type.func_176839_a()) : new ItemStack(BWMBlocks.DEBARKED_NEW, 1, type.func_176839_a() - 4);
            block = ((ItemBlock)log.func_77973_b()).func_179223_d();
            SawInteraction.INSTANCE.addRecipe(block, log.func_77960_j(), plank, sawdust);
        }
        List logs = OreDictionary.getOres((String)"logWood");
        for (ItemStack log : logs) {
            Block block;
            if (log.func_77973_b() == null || !(log.func_77973_b() instanceof ItemBlock) || (block = ((ItemBlock)log.func_77973_b()).func_179223_d()).getRegistryName().func_110624_b().equals("minecraft")) continue;
            if (log.func_77952_i() == Short.MAX_VALUE) {
                for (int i = 0; i < 4; ++i) {
                    ItemStack planks = BWRegistry.getRecipeOutput(new ItemStack(log.func_77973_b(), 1, i));
                    if (planks == null) continue;
                    ItemStack[] output = new ItemStack[]{new ItemStack(planks.func_77973_b(), BWConfig.hardcoreLumber ? 4 : 6, planks.func_77960_j()), new ItemStack(BWMItems.BARK, 1, 0), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.SAWDUST, 2)};
                    if (BWConfig.hardcoreLumber) {
                        BWRegistry.removeRecipe(output[0], new ItemStack(log.func_77973_b(), 1, i));
                        if (Loader.isModLoaded((String)"thermalexpansion")) {
                            BWRegistry.registerTESawmill(output[0], new ItemStack(log.func_77973_b(), 1, i));
                        }
                        GameRegistry.addRecipe((IRecipe)new ChoppingRecipe(new ItemStack(planks.func_77973_b(), 2, planks.func_77960_j()), output[1], output[2], new ItemStack(log.func_77973_b(), 1, i)));
                    }
                    SawInteraction.INSTANCE.addRecipe(block, i, output);
                    SawInteraction.INSTANCE.addRecipe(planks, new ItemStack(BWMBlocks.WOOD_SIDING, 2, 0));
                }
                continue;
            }
            ItemStack planks = BWRegistry.getRecipeOutput(log);
            if (planks == null) continue;
            ItemStack[] output = new ItemStack[]{new ItemStack(planks.func_77973_b(), BWConfig.hardcoreLumber ? 4 : 6, planks.func_77960_j()), new ItemStack(BWMItems.BARK, 1, 0), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.SAWDUST, 2)};
            if (BWConfig.hardcoreLumber) {
                BWRegistry.removeRecipe(output[0], log);
                if (Loader.isModLoaded((String)"thermalexpansion")) {
                    BWRegistry.registerTESawmill(output[0], log);
                }
                GameRegistry.addRecipe((IRecipe)new ChoppingRecipe(new ItemStack(planks.func_77973_b(), 2, planks.func_77960_j()), output[1], output[2], log));
            }
            SawInteraction.INSTANCE.addRecipe(block, log.func_77960_j(), output);
            SawInteraction.INSTANCE.addRecipe(planks, new ItemStack(BWMBlocks.WOOD_SIDING, 2, 0));
        }
        BWCrafting.addKilnWood();
    }

    private static void registerTESawmill(ItemStack output, ItemStack input) {
        if (output == null || input == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a("energy", 800);
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("primaryOutput", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("secondaryOutput", (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l("input"));
        output.func_77955_b(toSend.func_74775_l("primaryOutput"));
        ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.SAWDUST).func_77955_b(toSend.func_74775_l("secondaryOutput"));
        toSend.func_74768_a("secondaryChance", 100);
        FMLInterModComms.sendMessage((String)"thermalexpansion", (String)"addsawmillrecipe", (NBTTagCompound)toSend);
    }

    private static ItemStack getRecipeOutput(ItemStack input) {
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe recipe : recipes) {
            ShapelessRecipes shapeless;
            if (recipe instanceof ShapelessRecipes) {
                shapeless = (ShapelessRecipes)recipe;
                if (shapeless.field_77579_b.size() != 1 || !((ItemStack)shapeless.field_77579_b.get(0)).func_77969_a(input)) continue;
                return shapeless.func_77571_b();
            }
            if (!(recipe instanceof ShapelessOreRecipe) || (shapeless = (ShapelessOreRecipe)recipe).func_77570_a() != 1 || !(shapeless.getInput().get(0) instanceof ItemStack) || !((ItemStack)shapeless.getInput().get(0)).func_77969_a(input)) continue;
            return shapeless.func_77571_b();
        }
        return null;
    }

    private static void removeRecipe(ItemStack output, ItemStack input) {
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        ArrayList<IRecipe> toRemove = new ArrayList<IRecipe>();
        for (IRecipe recipe : recipes) {
            ShapelessRecipes shapeless;
            ShapedRecipes shaped;
            if (recipe instanceof ShapedRecipes) {
                shaped = (ShapedRecipes)recipe;
                if (shaped.func_77570_a() != 1 || !shaped.field_77574_d[0].func_77969_a(input) || !output.func_77969_a(shaped.func_77571_b())) continue;
                toRemove.add(recipe);
                continue;
            }
            if (recipe instanceof ShapedOreRecipe) {
                ItemStack stack;
                shaped = (ShapedOreRecipe)recipe;
                if (shaped.func_77570_a() != 1 || !(shaped.getInput()[0] instanceof ItemStack) || !(stack = (ItemStack)shaped.getInput()[0]).func_77969_a(input) || !output.func_77969_a(shaped.func_77571_b())) continue;
                toRemove.add(recipe);
                continue;
            }
            if (recipe instanceof ShapelessRecipes) {
                shapeless = (ShapelessRecipes)recipe;
                if (shapeless.field_77579_b.size() != 1 || !((ItemStack)shapeless.field_77579_b.get(0)).func_77969_a(input) || !output.func_77969_a(shapeless.func_77571_b())) continue;
                toRemove.add(recipe);
                continue;
            }
            if (!(recipe instanceof ShapelessOreRecipe) || (shapeless = (ShapelessOreRecipe)recipe).func_77570_a() != 1 || !(shapeless.getInput().get(0) instanceof ItemStack) || !((ItemStack)shapeless.getInput().get(0)).func_77969_a(input) || !output.func_77969_a(shapeless.func_77571_b())) continue;
            toRemove.add(recipe);
        }
        for (IRecipe remove : toRemove) {
            if (CraftingManager.func_77594_a().func_77592_b().remove(remove)) continue;
            RecipeUtils.removeRecipes(remove.func_77571_b());
        }
    }

    private static void registerPotions() {
        BWRegistry.registerPotion(POTION_TRUESIGHT);
    }

    private static void registerPotion(Potion potion) {
        String potionName = potion.getRegistryName().toString().substring("betterwithmods".length() + ":".length());
        potion.func_76390_b("bwm.effect." + potionName);
        GameRegistry.register((IForgeRegistryEntry)potion);
    }

    private static boolean isNotBlock(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock) {
            Block block = ((ItemBlock)item).func_179223_d();
            return block instanceof BlockRope || block instanceof BlockBush || block instanceof BlockTorch || block instanceof BlockSand || block instanceof BlockGravel || InvUtils.isOre(stack, "treeSapling");
        }
        return true;
    }

    private static boolean isParticulate(ItemStack stack) {
        Item item = stack.func_77973_b();
        return InvUtils.listContains(stack, OreDictionary.getOres((String)"sand")) || item instanceof ItemSeeds || InvUtils.listContains(stack, OreDictionary.getOres((String)"listAllseeds")) || item == Items.field_151016_H || item == Items.field_151102_aT || item == Items.field_151065_br || InvUtils.listContains(stack, OreDictionary.getOres((String)"foodFlour")) || InvUtils.listContains(stack, InvUtils.dustNames) || item == BWMItems.DIRT_PILE || item == BWMItems.GRAVEL_PILE || item == BWMItems.SAND_PILE;
    }

    private static boolean isFlat(ItemStack stack) {
        Item item = stack.func_77973_b();
        int meta = stack.func_77960_j();
        if (item instanceof ItemMaterial) {
            return meta == ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.NETHERCOAL).func_77960_j() || meta == ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.HEMP_CLOTH).func_77960_j() || meta == ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.TANNED_LEATHER).func_77960_j() || meta == ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.SCOURED_LEATHER).func_77960_j() || meta == ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.LEATHER_STRAP).func_77960_j() || meta == ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.LEATHER_BELT).func_77960_j() || meta == ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.LEATHER_CUT).func_77960_j() || meta == ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.TANNED_LEATHER_CUT).func_77960_j() || meta == ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.SCOURED_LEATHER_CUT).func_77960_j();
        }
        return item == Item.func_150898_a((Block)Blocks.field_150325_L) || item == Item.func_150898_a((Block)Blocks.field_150404_cg) || item == Items.field_151116_aA || item == Items.field_151148_bJ || item == Items.field_151098_aY || InvUtils.listContains(stack, OreDictionary.getOres((String)"string")) || InvUtils.listContains(stack, OreDictionary.getOres((String)"paper"));
    }

    private static boolean isNarrow(ItemStack stack) {
        Item item = stack.func_77973_b();
        int meta = stack.func_77960_j();
        if (item instanceof ItemMaterial) {
            return meta == ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.LEATHER_STRAP).func_77960_j() || meta == ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.LEATHER_BELT).func_77960_j();
        }
        return item == Item.func_150898_a((Block)Blocks.field_150328_O) || item == Item.func_150898_a((Block)Blocks.field_150327_N) || item == Items.field_151103_aS || item == Items.field_151032_g || item == Items.field_185166_h || item == Items.field_185167_i || InvUtils.listContains(stack, OreDictionary.getOres((String)"stickWood")) || InvUtils.listContains(stack, InvUtils.cropNames) || item == Items.field_151120_aE || item == Items.field_151072_bj;
    }
}

