/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.blocks;

import betterwithmods.api.block.IMultiVariants;
import betterwithmods.blocks.BWMBlock;
import betterwithmods.client.BWCreativeTabs;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAesthetic
extends BWMBlock
implements IMultiVariants {
    public static final PropertyEnum<EnumType> blockType = PropertyEnum.func_177709_a((String)"blocktype", EnumType.class);

    public BlockAesthetic() {
        super(Material.field_151576_e);
        this.func_149711_c(2.0f);
        this.func_149647_a(BWCreativeTabs.BWTAB);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(blockType, (Comparable)((Object)EnumType.CHOPBLOCK)));
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return state.func_177229_b(blockType) != EnumType.STEEL || entity instanceof EntityPlayer;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        if (world.func_180495_p(pos).func_177229_b(blockType) != EnumType.STEEL) {
            super.onBlockExploded(world, pos, explosion);
        }
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        if (world.func_180495_p(pos).func_177229_b(blockType) != EnumType.STEEL) {
            return 10.0f;
        }
        return 2000.0f;
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    @Override
    public String[] getVariants() {
        return new String[]{"blocktype=chopping", "blocktype=chopping_blood", "blocktype=steel", "blocktype=hellfire", "blocktype=rope", "blocktype=flint", "blocktype=whitestone", "blocktype=whitecobble", "blocktype=enderblock"};
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < EnumType.META_LOOKUP.length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(blockType))).getMeta();
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        int meta = ((EnumType)((Object)world.func_180495_p(pos).func_177229_b(blockType))).getMeta();
        return meta == 3;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(blockType, (Comparable)((Object)EnumType.byMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(blockType))).getMeta();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{blockType});
    }

    public static enum EnumType implements IStringSerializable
    {
        CHOPBLOCK(0, "chopping", MapColor.field_151665_m),
        CHOPBLOCKBLOOD(1, "chopping_blood", MapColor.field_151655_K),
        STEEL(2, "steel", MapColor.field_151668_h),
        HELLFIRE(3, "hellfire", MapColor.field_151676_q),
        ROPE(4, "rope", MapColor.field_151664_l),
        FLINT(5, "flint", MapColor.field_151665_m),
        WHITESTONE(6, "whitestone", MapColor.field_151659_e),
        WHITECOBBLE(7, "whitecobble", MapColor.field_151659_e),
        ENDERBLOCK(8, "enderblock", MapColor.field_151679_y);

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final MapColor color;

        private EnumType(int meta, String name, MapColor color) {
            this.meta = meta;
            this.name = name;
            this.color = color;
        }

        public static EnumType byMeta(int meta) {
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getMeta() {
            return this.meta;
        }

        public MapColor getMapColor() {
            return this.color;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType blockType;
                EnumType.META_LOOKUP[blockType.getMeta()] = blockType = enumTypeArray[i];
            }
        }
    }
}

