/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.blocks;

import betterwithmods.BWMBlocks;
import betterwithmods.api.block.IAxle;
import betterwithmods.blocks.BlockGearbox;
import betterwithmods.client.BWCreativeTabs;
import betterwithmods.items.ItemMaterial;
import betterwithmods.util.DirUtils;
import betterwithmods.util.InvUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class BlockBrokenGearbox
extends Block {
    public static final PropertyInteger STAGE = PropertyInteger.func_177719_a((String)"repair", (int)0, (int)1);

    public BlockBrokenGearbox() {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)DirUtils.FACING, (Comparable)EnumFacing.UP).func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
        this.func_149647_a(BWCreativeTabs.BWTAB);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing side, float flX, float flY, float flZ, int meta, EntityLivingBase placer, ItemStack stack) {
        IBlockState state = super.getStateForPlacement(world, pos, side, flX, flY, flZ, meta, placer, stack);
        return state.func_177226_a((IProperty)DirUtils.FACING, (Comparable)side.func_176734_d());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        EnumFacing facing = DirUtils.convertEntityOrientationToFacing(entity, EnumFacing.NORTH);
        world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)DirUtils.FACING, (Comparable)facing));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack hold = player.func_184586_b(hand);
        if (hold != null && InvUtils.listContains(hold, OreDictionary.getOres((String)"gearWood"))) {
            if (world.field_72995_K) {
                return true;
            }
            this.advanceStage(world, pos, state);
            if (!player.field_71075_bZ.field_75098_d) {
                --hold.field_77994_a;
            }
            return true;
        }
        return false;
    }

    private void advanceStage(World world, BlockPos pos, IBlockState state) {
        if ((Integer)state.func_177229_b((IProperty)STAGE) == 0) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(1)));
        } else {
            world.func_175656_a(pos, BWMBlocks.GEARBOX.func_176223_P().func_177226_a((IProperty)DirUtils.FACING, state.func_177229_b((IProperty)DirUtils.FACING)).func_177226_a((IProperty)BlockGearbox.ISACTIVE, (Comparable)Boolean.valueOf(false)));
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        List list = super.getDrops(world, pos, state, fortune);
        if ((Integer)state.func_177229_b((IProperty)STAGE) == 1) {
            list.add(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.GEAR));
        }
        return list;
    }

    private boolean isAxle(IBlockAccess world, BlockPos origin, EnumFacing facing) {
        BlockPos pos = origin.func_177972_a(facing);
        Block block = world.func_180495_p(pos).func_177230_c();
        return block instanceof IAxle && ((IAxle)block).isAxleOrientedToFacing(world, pos, facing.func_176734_d());
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean[] dirs = new boolean[6];
        for (int i = 0; i < 6; ++i) {
            EnumFacing facing = EnumFacing.func_82600_a((int)i);
            dirs[i] = this.isAxle(world, pos, facing) && state.func_177229_b((IProperty)DirUtils.FACING) != facing;
        }
        return state.func_177226_a((IProperty)DirUtils.DOWN, (Comparable)Boolean.valueOf(dirs[0])).func_177226_a((IProperty)DirUtils.UP, (Comparable)Boolean.valueOf(dirs[1])).func_177226_a((IProperty)DirUtils.NORTH, (Comparable)Boolean.valueOf(dirs[2])).func_177226_a((IProperty)DirUtils.SOUTH, (Comparable)Boolean.valueOf(dirs[3])).func_177226_a((IProperty)DirUtils.WEST, (Comparable)Boolean.valueOf(dirs[4])).func_177226_a((IProperty)DirUtils.EAST, (Comparable)Boolean.valueOf(dirs[5]));
    }

    public int func_176201_c(IBlockState state) {
        int meta = (Integer)state.func_177229_b((IProperty)STAGE) == 1 ? 8 : 0;
        return meta += ((EnumFacing)state.func_177229_b((IProperty)DirUtils.FACING)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        int stage = 0;
        if (meta > 7) {
            stage = 1;
            meta -= 8;
        }
        return this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(stage)).func_177226_a((IProperty)DirUtils.FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DirUtils.FACING, STAGE, DirUtils.UP, DirUtils.DOWN, DirUtils.NORTH, DirUtils.SOUTH, DirUtils.WEST, DirUtils.EAST});
    }
}

