/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.blocks;

import betterwithmods.BWMItems;
import betterwithmods.api.block.IMultiVariants;
import betterwithmods.blocks.BlockGrassCustom;
import betterwithmods.blocks.BlockMyceliumCustom;
import betterwithmods.blocks.BlockSimpleSlab;
import betterwithmods.util.WorldUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDirtSlab
extends BlockSimpleSlab
implements IMultiVariants {
    public static final PropertyEnum<DirtSlabType> VARIANT = PropertyEnum.func_177709_a((String)"variant", DirtSlabType.class);
    private static final EnumFacing[] CHECKED_FACINGS_FOR_SNOW = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST};

    public BlockDirtSlab() {
        super(Material.field_151578_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)DirtSlabType.DIRT)).func_177226_a((IProperty)BlockDirt.field_176385_b, (Comparable)Boolean.valueOf(false)));
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.func_149675_a(true);
        this.setHarvestLevel("shovel", 0);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return this.isOverSupport(worldIn, pos);
    }

    private boolean isOverSupport(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos.func_177977_b());
        return state.isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) || state.func_177230_c().canPlaceTorchOnTop(state, (IBlockAccess)worldIn, pos.func_177977_b()) || state.func_185915_l() || state.func_185917_h() || state.func_185913_b();
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        if (!this.isOverSupport(worldIn, pos)) {
            worldIn.func_175655_b(pos, false);
            Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(BWMItems.DIRT_PILE));
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(new ItemStack(BWMItems.DIRT_PILE, 2));
        return drops;
    }

    public MapColor func_180659_g(IBlockState state) {
        return ((DirtSlabType)((Object)state.func_177229_b(VARIANT))).getColor();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean snowy = false;
        for (EnumFacing facing : CHECKED_FACINGS_FOR_SNOW) {
            BlockPos checkedPos = pos.func_177972_a(facing);
            Block block = worldIn.func_180495_p(checkedPos).func_177230_c();
            Block blockOver = worldIn.func_180495_p(checkedPos.func_177984_a()).func_177230_c();
            if (block != Blocks.field_150433_aE && block != Blocks.field_150431_aC && blockOver != Blocks.field_150433_aE && blockOver != Blocks.field_150431_aC) continue;
            snowy = true;
        }
        state = state.func_177226_a((IProperty)BlockDirt.field_176385_b, (Comparable)Boolean.valueOf(snowy));
        return state;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack((Block)this, 1, DirtSlabType.DIRT.getMetadata()));
        list.add(new ItemStack((Block)this, 1, DirtSlabType.GRASS.getMetadata()));
        list.add(new ItemStack((Block)this, 1, DirtSlabType.MYCELIUM.getMetadata()));
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this, 1, ((DirtSlabType)((Object)state.func_177229_b(VARIANT))).getMetadata());
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)DirtSlabType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((DirtSlabType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, BlockDirt.field_176385_b});
    }

    public Material func_149688_o(IBlockState state) {
        return ((DirtSlabType)((Object)state.func_177229_b(VARIANT))).getMaterial();
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Override
    public String[] getVariants() {
        ArrayList<String> variants = new ArrayList<String>();
        for (DirtSlabType enumtype : DirtSlabType.values()) {
            variants.add("snowy=false,variant=" + enumtype.func_176610_l());
        }
        return variants.toArray(new String[DirtSlabType.values().length]);
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        if (((Boolean)state.func_177229_b((IProperty)BlockDirt.field_176385_b)).booleanValue()) {
            return SoundType.field_185856_i;
        }
        switch ((DirtSlabType)((Object)state.func_177229_b(VARIANT))) {
            case DIRT: {
                return SoundType.field_185849_b;
            }
        }
        return SoundType.field_185850_c;
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        switch ((DirtSlabType)((Object)blockState.func_177229_b(VARIANT))) {
            case DIRT: {
                return 0.5f;
            }
        }
        return 0.6f;
    }

    private void handleSubtypeChange(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            int shrinkLight = WorldUtils.getNaturalLightFromNeighbors(world, pos.func_177984_a());
            int growthLight = shrinkLight - world.func_175657_ab();
            BlockPos check = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
            Block block = world.func_180495_p(check).func_177230_c();
            if (block == Blocks.field_150349_c || block == this && world.func_180495_p(check).func_177229_b(VARIANT) == DirtSlabType.GRASS) {
                if (growthLight >= 11) {
                    world.func_175656_a(pos, state.func_177226_a(VARIANT, (Comparable)((Object)DirtSlabType.GRASS)));
                }
            } else if ((block == Blocks.field_150391_bh || block == this && world.func_180495_p(check).func_177229_b(VARIANT) == DirtSlabType.MYCELIUM) && growthLight >= 9) {
                world.func_175656_a(pos, state.func_177226_a(VARIANT, (Comparable)((Object)DirtSlabType.MYCELIUM)));
            }
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            if (state.func_177229_b(VARIANT) == DirtSlabType.GRASS) {
                BlockGrassCustom.handleGrassSpreading(worldIn, pos, rand, this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)DirtSlabType.DIRT)));
            } else if (state.func_177229_b(VARIANT) == DirtSlabType.MYCELIUM) {
                BlockMyceliumCustom.handleMyceliumSpreading(worldIn, pos, rand, this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)DirtSlabType.DIRT)));
            } else {
                this.handleSubtypeChange(worldIn, pos, state, rand);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        super.func_180655_c(stateIn, worldIn, pos, rand);
        if (stateIn.func_177229_b(VARIANT) != DirtSlabType.MYCELIUM) {
            return;
        }
        if (rand.nextInt(10) == 0) {
            worldIn.func_175688_a(EnumParticleTypes.TOWN_AURA, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)((float)pos.func_177956_o() + 1.1f), (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public static enum DirtSlabType implements IStringSerializable
    {
        DIRT(0, "dirt", Material.field_151578_c),
        GRASS(1, "grass", Material.field_151577_b),
        MYCELIUM(2, "mycelium", MapColor.field_151678_z, Material.field_151577_b);

        private static final DirtSlabType[] METADATA_LOOKUP;
        private final int metadata;
        private final String name;
        private final MapColor color;
        private final Material material;

        private DirtSlabType(int metadataIn, String nameIn, Material material) {
            this(metadataIn, nameIn, material.func_151565_r(), material);
        }

        private DirtSlabType(int metadataIn, String nameIn, MapColor color, Material material) {
            this.metadata = metadataIn;
            this.name = nameIn;
            this.color = color;
            this.material = material;
        }

        public static DirtSlabType byMetadata(int metadata) {
            if (metadata < 0 || metadata >= METADATA_LOOKUP.length) {
                metadata = 0;
            }
            return METADATA_LOOKUP[metadata];
        }

        public int getMetadata() {
            return this.metadata;
        }

        public MapColor getColor() {
            return this.color;
        }

        public Material getMaterial() {
            return this.material;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            METADATA_LOOKUP = new DirtSlabType[DirtSlabType.values().length];
            DirtSlabType[] dirtSlabTypeArray = DirtSlabType.values();
            int n = dirtSlabTypeArray.length;
            for (int i = 0; i < n; ++i) {
                DirtSlabType blockdirt$dirttype;
                DirtSlabType.METADATA_LOOKUP[blockdirt$dirttype.getMetadata()] = blockdirt$dirttype = dirtSlabTypeArray[i];
            }
        }
    }
}

