/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.blocks;

import betterwithmods.blocks.BlockGearbox;
import betterwithmods.util.DirUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockRailPowered;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockGearBoostedRail
extends BlockRailPowered {
    public BlockGearBoostedRail() {
        this.func_149711_c(0.7f);
        this.func_149672_a(SoundType.field_185852_e);
    }

    protected void func_189541_b(IBlockState state, World world, BlockPos pos, Block block) {
        boolean isOnPoweredGearbox;
        boolean poweredProperty = (Boolean)state.func_177229_b((IProperty)field_176569_M);
        if (poweredProperty != (isOnPoweredGearbox = this.isOnActiveGearbox(state, world, pos))) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)field_176569_M, (Comparable)Boolean.valueOf(isOnPoweredGearbox)), 3);
            world.func_175685_c(pos.func_177977_b(), (Block)this);
            if (((BlockRailBase.EnumRailDirection)state.func_177229_b((IProperty)field_176568_b)).func_177018_c()) {
                world.func_175685_c(pos.func_177984_a(), (Block)this);
            }
        }
    }

    private boolean isOnActiveGearbox(IBlockState state, World world, BlockPos pos) {
        if (!(world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockGearbox)) {
            return false;
        }
        BlockRailBase.EnumRailDirection dir = (BlockRailBase.EnumRailDirection)state.func_177229_b((IProperty)field_176568_b);
        IBlockState below = world.func_180495_p(pos.func_177977_b());
        EnumFacing face = (EnumFacing)below.func_177229_b((IProperty)DirUtils.FACING);
        boolean correctFace = false;
        if (dir == BlockRailBase.EnumRailDirection.ASCENDING_EAST || dir == BlockRailBase.EnumRailDirection.ASCENDING_WEST || dir == BlockRailBase.EnumRailDirection.EAST_WEST) {
            correctFace = face == EnumFacing.DOWN || face == EnumFacing.NORTH || face == EnumFacing.SOUTH;
        } else if (dir == BlockRailBase.EnumRailDirection.ASCENDING_NORTH || dir == BlockRailBase.EnumRailDirection.ASCENDING_SOUTH || dir == BlockRailBase.EnumRailDirection.NORTH_SOUTH) {
            correctFace = face == EnumFacing.DOWN || face == EnumFacing.EAST || face == EnumFacing.WEST;
        }
        return correctFace && ((BlockGearbox)below.func_177230_c()).isGearboxOn((IBlockAccess)world, pos.func_177977_b());
    }

    public boolean isFlexibleRail(IBlockAccess world, BlockPos pos) {
        return false;
    }

    private void accelerateMinecart(World world, EntityMinecart cart, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        double planarMotion = Math.sqrt(cart.field_70159_w * cart.field_70159_w + cart.field_70179_y * cart.field_70179_y);
        EnumFacing gearboxFace = (EnumFacing)world.func_180495_p(pos.func_177977_b()).func_177229_b((IProperty)DirUtils.FACING);
        switch ((BlockRailBase.EnumRailDirection)state.func_177229_b((IProperty)field_176568_b)) {
            case ASCENDING_NORTH: 
            case ASCENDING_SOUTH: 
            case NORTH_SOUTH: {
                if (planarMotion > 0.01) {
                    if (gearboxFace == EnumFacing.EAST && cart.field_70179_y > 0.0 || gearboxFace == EnumFacing.WEST && cart.field_70179_y < 0.0) {
                        cart.field_70179_y -= cart.field_70179_y / planarMotion * 0.06;
                        if (world.field_72995_K || !(planarMotion > 0.02) || !(world.field_73012_v.nextDouble() < planarMotion)) break;
                        world.func_184133_a(null, pos, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 1.0f, 2.0f);
                        break;
                    }
                    cart.field_70179_y += cart.field_70179_y / planarMotion * 0.06;
                    break;
                }
                if (gearboxFace == EnumFacing.EAST && !world.func_180495_p(pos.func_177976_e()).func_185914_p()) {
                    cart.field_70179_y = -0.02;
                    break;
                }
                if (gearboxFace == EnumFacing.WEST && !world.func_180495_p(pos.func_177974_f()).func_185914_p()) {
                    cart.field_70179_y = 0.02;
                    break;
                }
                if (gearboxFace == EnumFacing.DOWN && world.func_180495_p(pos.func_177976_e()).func_185914_p()) {
                    cart.field_70179_y = 0.02;
                    break;
                }
                if (gearboxFace != EnumFacing.DOWN || !world.func_180495_p(pos.func_177974_f()).func_185914_p()) break;
                cart.field_70179_y = -0.02;
                break;
            }
            case ASCENDING_EAST: 
            case ASCENDING_WEST: 
            case EAST_WEST: {
                if (planarMotion > 0.01) {
                    if (gearboxFace == EnumFacing.SOUTH && cart.field_70159_w > 0.0 || gearboxFace == EnumFacing.NORTH && cart.field_70159_w < 0.0) {
                        cart.field_70159_w -= cart.field_70159_w / planarMotion * 0.06;
                        if (world.field_72995_K || !(planarMotion > 0.02) || !(world.field_73012_v.nextDouble() < planarMotion)) break;
                        world.func_184133_a(null, pos, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 1.0f, 2.0f);
                        break;
                    }
                    cart.field_70159_w += cart.field_70159_w / planarMotion * 0.06;
                    break;
                }
                if (gearboxFace == EnumFacing.SOUTH && !world.func_180495_p(pos.func_177976_e()).func_185914_p()) {
                    cart.field_70159_w = -0.02;
                    break;
                }
                if (gearboxFace == EnumFacing.NORTH && !world.func_180495_p(pos.func_177974_f()).func_185914_p()) {
                    cart.field_70159_w = 0.02;
                    break;
                }
                if (gearboxFace == EnumFacing.DOWN && world.func_180495_p(pos.func_177976_e()).func_185914_p()) {
                    cart.field_70159_w = 0.02;
                    break;
                }
                if (gearboxFace != EnumFacing.DOWN || !world.func_180495_p(pos.func_177974_f()).func_185914_p()) break;
                cart.field_70159_w = -0.02;
                break;
            }
        }
    }

    private void decelerateMinecart(World world, EntityMinecart cart, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        double planarMotion = Math.sqrt(cart.field_70159_w * cart.field_70159_w + cart.field_70179_y * cart.field_70179_y);
        if (planarMotion > 0.01) {
            double zMotion = Math.sqrt(cart.field_70179_y * cart.field_70179_y);
            double xMotion = Math.sqrt(cart.field_70159_w * cart.field_70159_w);
            if (xMotion > 0.0) {
                cart.field_70159_w -= cart.field_70159_w / planarMotion * 0.06;
            } else if (zMotion > 0.0) {
                cart.field_70179_y -= cart.field_70179_y / planarMotion * 0.06;
            }
            this.playBoosterSound(world, pos, planarMotion);
        } else if (state.func_177229_b((IProperty)field_176568_b) == BlockRailBase.EnumRailDirection.EAST_WEST || state.func_177229_b((IProperty)field_176568_b) == BlockRailBase.EnumRailDirection.NORTH_SOUTH) {
            cart.field_70159_w = 0.0;
            cart.field_70179_y = 0.0;
        }
    }

    private void playBoosterSound(World world, BlockPos pos, double planarMotion) {
        if (!world.field_72995_K && planarMotion > 0.02 && world.field_73012_v.nextDouble() < planarMotion) {
            world.func_184133_a(null, pos, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 1.0f, 2.0f);
        }
    }

    public void onMinecartPass(World world, EntityMinecart cart, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return;
        }
        Block blockUnder = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (blockUnder instanceof BlockGearbox) {
            BlockGearbox gearbox = (BlockGearbox)blockUnder;
            EnumFacing face = (EnumFacing)world.func_180495_p(pos.func_177977_b()).func_177229_b((IProperty)DirUtils.FACING);
            if (face == EnumFacing.UP) {
                return;
            }
            if (world.func_175640_z(pos.func_177977_b())) {
                return;
            }
            if (gearbox.isGearboxOn((IBlockAccess)world, pos.func_177977_b())) {
                this.accelerateMinecart(world, cart, pos);
            } else {
                this.decelerateMinecart(world, cart, pos);
            }
        } else {
            double planarMotion = Math.sqrt(cart.field_70159_w * cart.field_70159_w + cart.field_70179_y * cart.field_70179_y);
            this.playBoosterSound(world, pos, planarMotion);
        }
    }
}

