/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.blocks;

import betterwithmods.BWMBlocks;
import betterwithmods.blocks.BWMBlock;
import betterwithmods.blocks.BlockLens;
import betterwithmods.util.DirUtils;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockInvisibleLight
extends BWMBlock {
    public static final PropertyBool SUNLIGHT = PropertyBool.func_177716_a((String)"sunlight");

    public BlockInvisibleLight() {
        super(Material.field_151579_a);
        this.func_149715_a(1.0f);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)SUNLIGHT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DirUtils.FACING, (Comparable)EnumFacing.UP));
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public int func_149738_a(World world) {
        return 6;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        world.func_175684_a(pos, (Block)this, 5);
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return field_185506_k;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_176209_a(IBlockState state, boolean playerActivated) {
        return false;
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float f, int fortune) {
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block) {
        if (world.func_180495_p(pos).func_177230_c() == BWMBlocks.LIGHT_SOURCE) {
            world.func_175698_g(pos);
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        EntityLiving living;
        if (!world.field_72995_K && ((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)SUNLIGHT)).booleanValue() && entity instanceof EntityLiving && (living = (EntityLiving)entity).func_70668_bt() == EnumCreatureAttribute.UNDEAD) {
            living.func_70015_d(4);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!this.hasClearViewToLens(world, pos)) {
            world.func_175698_g(pos);
        } else {
            world.func_175684_a(pos, (Block)this, 5);
        }
    }

    public EnumFacing getFacing(IBlockAccess world, BlockPos pos) {
        return (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)DirUtils.FACING);
    }

    @Override
    public EnumFacing getFacingFromBlockState(IBlockState state) {
        return (EnumFacing)state.func_177229_b((IProperty)DirUtils.FACING);
    }

    @Override
    public IBlockState setFacingInBlock(IBlockState state, EnumFacing facing) {
        return state.func_177226_a((IProperty)DirUtils.FACING, (Comparable)facing);
    }

    private boolean hasClearViewToLens(World world, BlockPos pos) {
        boolean clear = true;
        EnumFacing face = this.getFacingFromBlockState(world.func_180495_p(pos));
        for (int i = 1; i < 32; ++i) {
            int z;
            int y;
            BlockPos bPos = pos.func_177967_a(face, i);
            int x = bPos.func_177958_n();
            List entity = world.func_72872_a(Entity.class, new AxisAlignedBB((double)x, (double)(y = bPos.func_177956_o()), (double)(z = bPos.func_177952_p()), (double)(x + 1), (double)(y + 1), (double)(z + 1)));
            if (entity.size() > 0) {
                clear = false;
            } else if (world.func_180495_p(bPos).func_177230_c() == BWMBlocks.LIGHT_SOURCE) {
                clear = false;
            } else {
                if (world.func_180495_p(bPos).func_177230_c() == BWMBlocks.LENS) {
                    BlockLens lens = (BlockLens)world.func_180495_p(bPos).func_177230_c();
                    return lens.getFacing((IBlockAccess)world, bPos) == DirUtils.getOpposite(this.getFacing((IBlockAccess)world, bPos));
                }
                if (!world.func_175623_d(bPos)) {
                    clear = false;
                }
            }
            if (!clear) break;
        }
        return clear;
    }

    public IBlockState func_176203_a(int meta) {
        boolean sun = false;
        if (meta > 7) {
            sun = true;
            meta -= 8;
        }
        return this.func_176223_P().func_177226_a((IProperty)SUNLIGHT, (Comparable)Boolean.valueOf(sun)).func_177226_a((IProperty)DirUtils.FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        int meta = (Boolean)state.func_177229_b((IProperty)SUNLIGHT) != false ? 8 : 0;
        return meta + ((EnumFacing)state.func_177229_b((IProperty)DirUtils.FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DirUtils.FACING, SUNLIGHT});
    }
}

